/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.util.Cache;
import org.h2.util.CacheObject;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class RowList {
    private final Session session;
    private final ObjectArray<Row> list = ObjectArray.newInstance();
    private int size;
    private int index;
    private int listIndex;
    private FileStore file;
    private DataPage rowBuff;
    private Cache cache;
    private ObjectArray<ValueLob> lobs;
    private int memory;
    private int maxMemory;
    private boolean written;
    private boolean readUncached;

    public RowList(Session session) {
        this.session = session;
        if (SysProperties.DEFAULT_MAX_OPERATION_MEMORY > 0 && session.getDatabase().isPersistent()) {
            this.maxMemory = session.getDatabase().getMaxOperationMemory();
        }
    }

    private void writeRow(DataPage dataPage, Row row) throws SQLException {
        dataPage.checkCapacity(29);
        dataPage.writeByte((byte)1);
        dataPage.writeInt(row.getMemorySize());
        dataPage.writeInt(row.getColumnCount());
        dataPage.writeInt(row.getPos());
        dataPage.writeInt(row.getVersion());
        dataPage.writeInt(row.getDeleted() ? 1 : 0);
        dataPage.writeInt(row.getSessionId());
        dataPage.writeInt(row.getStorageId());
        for (int i = 0; i < row.getColumnCount(); ++i) {
            ValueLob valueLob;
            Value value = row.getValue(i);
            if ((value.getType() == 16 || value.getType() == 15) && (valueLob = (ValueLob)value).getSmall() == null && valueLob.getTableId() == 0) {
                if (this.lobs == null) {
                    this.lobs = ObjectArray.newInstance();
                }
                this.lobs.add(valueLob);
            }
            dataPage.checkCapacity(dataPage.getValueLen(value));
            dataPage.writeValue(value);
        }
    }

    private void writeAllRows() throws SQLException {
        Object object;
        if (this.file == null) {
            object = this.session.getDatabase();
            if (!SysProperties.PAGE_STORE) {
                this.cache = ((Database)object).getDataFile().getCache();
            }
            String string = ((Database)object).createTempFile();
            this.file = ((Database)object).openFile(string, "rw", false);
            this.file.seek(48L);
            this.rowBuff = DataPage.create((DataHandler)object, 512);
            this.file.seek(48L);
        }
        object = this.rowBuff;
        this.initBuffer((DataPage)object);
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0 && ((DataPage)object).length() > 4096) {
                this.flushBuffer((DataPage)object);
                this.initBuffer((DataPage)object);
            }
            Row row = this.list.get(i);
            this.writeRow((DataPage)object, row);
        }
        this.flushBuffer((DataPage)object);
        this.file.autoDelete();
        this.list.clear();
        this.memory = 0;
    }

    private void initBuffer(DataPage dataPage) {
        dataPage.reset();
        dataPage.writeInt(0);
    }

    private void flushBuffer(DataPage dataPage) throws SQLException {
        dataPage.checkCapacity(1);
        dataPage.writeByte((byte)0);
        dataPage.fillAligned();
        dataPage.setInt(0, dataPage.length() / 16);
        dataPage.updateChecksum();
        this.file.write(dataPage.getBytes(), 0, dataPage.length());
    }

    public void add(Row row) throws SQLException {
        this.list.add(row);
        this.memory += row.getMemorySize();
        if (this.maxMemory > 0 && this.memory > this.maxMemory) {
            this.writeAllRows();
        }
        ++this.size;
    }

    public void reset() throws SQLException {
        this.index = 0;
        if (this.file != null) {
            this.listIndex = 0;
            if (!this.written) {
                this.writeAllRows();
                this.written = true;
            }
            this.list.clear();
            this.file.seek(48L);
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    private Row readRow(DataPage dataPage) throws SQLException {
        CacheObject cacheObject;
        if (dataPage.readByte() == 0) {
            return null;
        }
        int n = dataPage.readInt();
        int n2 = dataPage.readInt();
        int n3 = dataPage.readInt();
        int n4 = dataPage.readInt();
        if (this.readUncached) {
            n3 = 0;
        }
        boolean bl = dataPage.readInt() == 1;
        int n5 = dataPage.readInt();
        int n6 = dataPage.readInt();
        Value[] valueArray = new Value[n2];
        for (int i = 0; i < n2; ++i) {
            ValueLob valueLob;
            Value value = dataPage.readValue();
            if (value.isLinked() && (valueLob = (ValueLob)value).getTableId() == 0) {
                this.session.unlinkAtCommit(valueLob);
            }
            valueArray[i] = value;
        }
        if (n3 != 0 && this.cache != null && (cacheObject = this.cache.find(n3)) != null) {
            return (Row)cacheObject;
        }
        Row row = new Row(valueArray, n);
        row.setPos(n3);
        row.setVersion(n4);
        row.setDeleted(bl);
        row.setSessionId(n5);
        row.setStorageId(n6);
        return row;
    }

    public Row next() throws SQLException {
        Row row;
        if (this.file == null) {
            row = this.list.get(this.index++);
        } else {
            if (this.listIndex >= this.list.size()) {
                this.list.clear();
                this.listIndex = 0;
                DataPage dataPage = this.rowBuff;
                dataPage.reset();
                int n = 16;
                this.file.readFully(dataPage.getBytes(), 0, n);
                int n2 = dataPage.readInt() * 16;
                dataPage.checkCapacity(n2);
                if (n2 - n > 0) {
                    this.file.readFully(dataPage.getBytes(), n, n2 - n);
                }
                dataPage.check(n2);
                int n3 = 0;
                while ((row = this.readRow(dataPage)) != null) {
                    this.list.add(row);
                    ++n3;
                }
            }
            ++this.index;
            row = this.list.get(this.listIndex++);
        }
        return row;
    }

    public int size() {
        return this.size;
    }

    public void invalidateCache() {
        this.readUncached = true;
    }

    public void close() {
        if (this.file != null) {
            this.file.autoDelete();
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }
}

