/*
 * Decompiled with CFR 0.152.
 */
package org.h2.log;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.table.Table;
import org.h2.value.Value;

public class UndoLogRecord {
    public static final short INSERT = 0;
    public static final short DELETE = 1;
    private static final int IN_MEMORY = 0;
    private static final int STORED = 1;
    private static final int IN_MEMORY_READ_POS = 2;
    private Table table;
    private Row row;
    private short operation;
    private short state;
    private int filePos;

    public UndoLogRecord(Table table, short s, Row row) {
        this.table = table;
        this.row = row;
        this.operation = s;
        this.state = 0;
    }

    boolean isStored() {
        return this.state == 1;
    }

    boolean canStore() {
        return this.table.getUniqueIndex() != null;
    }

    public void undo(Session session) throws SQLException {
        switch (this.operation) {
            case 0: {
                if (this.state == 2) {
                    Index index = this.table.getUniqueIndex();
                    Cursor cursor = index.find(session, this.row, this.row);
                    cursor.next();
                    int n = cursor.getPos();
                    this.row.setPos(n);
                    this.state = 0;
                }
                if (session.getDatabase().getLockMode() == 0 && this.row.getDeleted()) {
                    return;
                }
                try {
                    this.table.removeRow(session, this.row);
                    break;
                }
                catch (SQLException sQLException) {
                    if (session.getDatabase().getLockMode() == 0 && sQLException.getErrorCode() == 90112) break;
                    throw sQLException;
                }
            }
            case 1: {
                try {
                    this.row.setPos(0);
                    this.table.addRow(session, this.row);
                    this.row.commit();
                    break;
                }
                catch (SQLException sQLException) {
                    if (session.getDatabase().getLockMode() == 0 && sQLException.getErrorCode() == 23001) break;
                    throw sQLException;
                }
            }
            default: {
                Message.throwInternalError("op=" + this.operation);
            }
        }
    }

    void save(DataPage dataPage, FileStore fileStore) throws SQLException {
        dataPage.reset();
        dataPage.writeInt(0);
        dataPage.writeInt(this.operation);
        dataPage.writeInt(this.row.getColumnCount());
        for (int i = 0; i < this.row.getColumnCount(); ++i) {
            dataPage.writeValue(this.row.getValue(i));
        }
        dataPage.fillAligned();
        dataPage.setInt(0, dataPage.length() / 16);
        dataPage.updateChecksum();
        this.filePos = (int)(fileStore.getFilePointer() / 16L);
        fileStore.write(dataPage.getBytes(), 0, dataPage.length());
        this.row = null;
        this.state = 1;
    }

    void seek(FileStore fileStore) throws SQLException {
        fileStore.seek(this.filePos * 16);
    }

    void load(DataPage dataPage, FileStore fileStore) throws SQLException {
        int n = 16;
        this.seek(fileStore);
        dataPage.reset();
        fileStore.readFully(dataPage.getBytes(), 0, n);
        int n2 = dataPage.readInt() * 16;
        dataPage.checkCapacity(n2);
        if (n2 - n > 0) {
            fileStore.readFully(dataPage.getBytes(), n, n2 - n);
        }
        dataPage.check(n2);
        int n3 = dataPage.readInt();
        if (SysProperties.CHECK && this.operation != n3) {
            Message.throwInternalError("operation=" + this.operation + " op=" + n3);
        }
        int n4 = dataPage.readInt();
        Value[] valueArray = new Value[n4];
        for (int i = 0; i < n4; ++i) {
            valueArray[i] = dataPage.readValue();
        }
        this.row = new Row(valueArray, 0);
        this.state = (short)2;
    }

    public Table getTable() {
        return this.table;
    }

    public void commit() throws SQLException {
        for (Index index : this.table.getIndexes()) {
            index.commit(this.operation, this.row);
        }
    }

    public Row getRow() {
        return this.row;
    }
}

