/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.store.DataPage;
import org.h2.store.PageStore;

public class PageInputStream
extends InputStream {
    private PageStore store;
    private final Trace trace;
    private int parentPage;
    private int type;
    private int streamId = -1;
    private int nextPage;
    private DataPage page;
    private boolean endOfFile;
    private int remaining;
    private byte[] buffer = new byte[1];

    public PageInputStream(PageStore pageStore, int n, int n2, int n3) {
        this.store = pageStore;
        this.trace = pageStore.getTrace();
        this.parentPage = n;
        this.type = n3;
        this.nextPage = n2;
        this.page = pageStore.createDataPage();
    }

    public int read() throws IOException {
        int n = this.read(this.buffer);
        return n < 0 ? -1 : this.buffer[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
            n4 += n3;
            n += n3;
            n2 -= n3;
        }
        return n4 == 0 ? -1 : n4;
    }

    private int readBlock(byte[] byArray, int n, int n2) throws IOException {
        this.fillBuffer();
        if (this.endOfFile) {
            return -1;
        }
        int n3 = Math.min(this.remaining, n2);
        this.page.read(byArray, n, n3);
        this.remaining -= n3;
        return n3;
    }

    private void fillBuffer() throws IOException {
        boolean bl;
        if (this.remaining > 0 || this.endOfFile) {
            return;
        }
        if (this.nextPage == 0) {
            this.endOfFile = true;
            return;
        }
        this.page.reset();
        try {
            this.store.readPage(this.nextPage, this.page);
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
        int n = this.page.readInt();
        int n2 = this.page.readByte();
        int n3 = this.page.readByte();
        if (this.streamId == -1) {
            this.streamId = n3;
        }
        boolean bl2 = bl = (n2 & 0x10) != 0;
        if (this.type != (n2 &= 0xFFFFFFEF) || n != this.parentPage || n3 != this.streamId) {
            throw new EOFException();
        }
        this.parentPage = this.nextPage;
        if (bl) {
            this.nextPage = 0;
            this.remaining = this.page.readInt();
        } else {
            this.nextPage = this.page.readInt();
            this.remaining = this.store.getPageSize() - this.page.length();
        }
        if (this.trace.isDebugEnabled()) {
            // empty if block
        }
    }
}

