/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.command.Parser;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.SequenceValue;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.SingleColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class Column {
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;
    private final int type;
    private final long precision;
    private final int scale;
    private final int displaySize;
    private Table table;
    private String name;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private Expression checkConstraint;
    private String checkConstraintSQL;
    private String originalSQL;
    private boolean autoIncrement;
    private long start;
    private long increment;
    private boolean convertNullToDefault;
    private Sequence sequence;
    private boolean isComputed;
    private TableFilter computeTableFilter;
    private int selectivity;
    private SingleColumnResolver resolver;
    private String comment;
    private boolean primaryKey;

    public Column(String string, int n) {
        this(string, n, -1L, -1, -1);
    }

    public Column(String string, int n, long l, int n2, int n3) {
        this.name = string;
        this.type = n;
        if (l == -1L && n2 == -1 && n3 == -1) {
            DataType dataType = DataType.getDataType(n);
            l = dataType.defaultPrecision;
            n2 = dataType.defaultScale;
            n3 = dataType.defaultDisplaySize;
        }
        this.precision = l;
        this.scale = n2;
        this.displaySize = n3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Column)) {
            return false;
        }
        Column column = (Column)object;
        if (this.table == null || column.table == null || this.name == null || column.name == null) {
            return false;
        }
        return this.table == column.table && this.name.equals(column.name);
    }

    public int hashCode() {
        if (this.table == null || this.name == null) {
            return 0;
        }
        return this.table.getId() ^ this.name.hashCode();
    }

    public Column getClone() {
        Column column = new Column(this.name, this.type, this.precision, this.scale, this.displaySize);
        column.nullable = this.nullable;
        column.defaultExpression = this.defaultExpression;
        column.originalSQL = this.originalSQL;
        column.convertNullToDefault = this.convertNullToDefault;
        column.sequence = this.sequence;
        column.comment = this.comment;
        column.computeTableFilter = this.computeTableFilter;
        column.isComputed = this.isComputed;
        column.selectivity = this.selectivity;
        column.primaryKey = this.primaryKey;
        return column;
    }

    boolean getComputed() {
        return this.isComputed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value computeValue(Session session, Row row) throws SQLException {
        Column column = this;
        synchronized (column) {
            this.computeTableFilter.setSession(session);
            this.computeTableFilter.set(row);
            return this.defaultExpression.getValue(session);
        }
    }

    public void setComputedExpression(Expression expression) {
        this.isComputed = true;
        this.defaultExpression = expression;
    }

    public void setTable(Table table, int n) {
        this.table = table;
        this.columnId = n;
    }

    public Table getTable() {
        return this.table;
    }

    public void setDefaultExpression(Session session, Expression expression) throws SQLException {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.defaultExpression = expression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public String getSQL() {
        return Parser.quoteIdentifier(this.name);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public int getScale() {
        return this.scale;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value validateConvertUpdateSequence(Session session, Value value) throws SQLException {
        Object object;
        Object object2;
        if (value == null) {
            if (this.defaultExpression == null) {
                value = ValueNull.INSTANCE;
            } else {
                object2 = this;
                synchronized (object2) {
                    value = this.defaultExpression.getValue(session).convertTo(this.type);
                }
                if (this.primaryKey) {
                    session.setLastIdentity(value);
                }
            }
        }
        object2 = session.getDatabase().getMode();
        if (value == ValueNull.INSTANCE) {
            if (this.convertNullToDefault) {
                object = this;
                synchronized (object) {
                    value = this.defaultExpression.getValue(session).convertTo(this.type);
                }
            }
            if (value == ValueNull.INSTANCE && !this.nullable) {
                if (((Mode)object2).convertInsertNullToZero) {
                    object = DataType.getDataType(this.type);
                    value = ((DataType)object).decimal ? ValueInt.get(0).convertTo(this.type) : (((DataType)object).type == 11 ? ValueTimestamp.getNoCopy(new Timestamp(System.currentTimeMillis())) : (((DataType)object).type == 9 ? ValueTime.get(Time.valueOf("0:0:0")) : (((DataType)object).type == 10 ? ValueTimestamp.getNoCopy(new Timestamp(System.currentTimeMillis())).convertTo(((DataType)object).type) : ValueString.get("").convertTo(this.type))));
                } else {
                    throw Message.getSQLException(90006, this.name);
                }
            }
        }
        if (this.checkConstraint != null) {
            this.resolver.setValue(value);
            Column column = this;
            synchronized (column) {
                object = this.checkConstraint.getValue(session);
            }
            if (Boolean.FALSE.equals(((Value)object).getBoolean())) {
                throw Message.getSQLException(23000, this.checkConstraint.getSQL());
            }
        }
        value = value.convertScale(((Mode)object2).convertOnlyToSmallerScale, this.scale);
        if (this.precision > 0L && !value.checkPrecision(this.precision)) {
            object = value.getTraceSQL();
            if (((String)object).length() > 127) {
                object = ((String)object).substring(0, 128) + "...";
            }
            throw Message.getSQLException(90005, new String[]{this.getCreateSQL(), (String)object + " (" + value.getPrecision() + ")"});
        }
        this.updateSequenceIfRequired(session, value);
        return value;
    }

    private void updateSequenceIfRequired(Session session, Value value) throws SQLException {
        if (this.sequence != null) {
            long l = this.sequence.getCurrentValue();
            long l2 = this.sequence.getIncrement();
            long l3 = value.getLong();
            boolean bl = false;
            if (l2 > 0L && l3 > l) {
                bl = true;
            } else if (l2 < 0L && l3 < l) {
                bl = true;
            }
            if (bl) {
                this.sequence.setStartValue(l3 + l2);
                session.setLastIdentity(ValueLong.get(l3));
                this.sequence.flush(session);
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int n, boolean bl) throws SQLException {
        String string;
        Object object;
        if (!this.autoIncrement) {
            Message.throwInternalError();
        }
        if ("IDENTITY".equals(this.originalSQL)) {
            this.originalSQL = "BIGINT";
        }
        int n2 = 0;
        while (true) {
            object = ValueUuid.getNewRandom();
            String string2 = ((ValueUuid)object).getString();
            string2 = string2.replace('-', '_').toUpperCase();
            string = "SYSTEM_SEQUENCE_" + string2;
            if (schema.findSequence(string) == null) break;
            ++n2;
        }
        Sequence sequence = new Sequence(schema, n, string, true);
        sequence.setStartValue(this.start);
        sequence.setIncrement(this.increment);
        if (!bl) {
            session.getDatabase().addSchemaObject(session, sequence);
        }
        this.setAutoIncrement(false, 0L, 0L);
        object = new SequenceValue(sequence);
        this.setDefaultExpression(session, (Expression)object);
        this.setSequence(sequence);
    }

    public void prepareExpression(Session session) throws SQLException {
        if (this.defaultExpression != null) {
            this.computeTableFilter = new TableFilter(session, this.table, null, false, null);
            this.defaultExpression.mapColumns(this.computeTableFilter, 0);
            this.defaultExpression = this.defaultExpression.optimize(session);
        }
    }

    public String getCreateSQL() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name != null) {
            stringBuffer.append(Parser.quoteIdentifier(this.name));
            stringBuffer.append(' ');
        }
        if (this.originalSQL != null) {
            stringBuffer.append(this.originalSQL);
        } else {
            stringBuffer.append(DataType.getDataType((int)this.type).name);
            switch (this.type) {
                case 6: {
                    stringBuffer.append("(");
                    stringBuffer.append(this.precision);
                    stringBuffer.append(", ");
                    stringBuffer.append(this.scale);
                    stringBuffer.append(")");
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 21: {
                    if (this.precision >= Integer.MAX_VALUE) break;
                    stringBuffer.append("(");
                    stringBuffer.append(this.precision);
                    stringBuffer.append(")");
                    break;
                }
            }
        }
        if (this.defaultExpression != null && (string = this.defaultExpression.getSQL()) != null) {
            if (this.isComputed) {
                stringBuffer.append(" AS ");
                stringBuffer.append(string);
            } else if (this.defaultExpression != null) {
                stringBuffer.append(" DEFAULT ");
                stringBuffer.append(string);
            }
        }
        if (!this.nullable) {
            stringBuffer.append(" NOT NULL");
        }
        if (this.convertNullToDefault) {
            stringBuffer.append(" NULL_TO_DEFAULT");
        }
        if (this.sequence != null) {
            stringBuffer.append(" SEQUENCE ");
            stringBuffer.append(this.sequence.getSQL());
        }
        if (this.selectivity != 0) {
            stringBuffer.append(" SELECTIVITY ");
            stringBuffer.append(this.selectivity);
        }
        if (this.checkConstraint != null) {
            stringBuffer.append(" CHECK ");
            stringBuffer.append(this.checkConstraintSQL);
        }
        if (this.comment != null) {
            stringBuffer.append(" COMMENT ");
            stringBuffer.append(StringUtils.quoteStringSQL(this.comment));
        }
        return stringBuffer.toString();
    }

    public boolean getNullable() {
        return this.nullable;
    }

    public void setOriginalSQL(String string) {
        this.originalSQL = string;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean bl, long l, long l2) {
        this.autoIncrement = bl;
        this.start = l;
        this.increment = l2;
        this.nullable = false;
        if (bl) {
            this.convertNullToDefault = true;
        }
    }

    public void setConvertNullToDefault(boolean bl) {
        this.convertNullToDefault = bl;
    }

    public void rename(String string) {
        this.name = string;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int n) {
        this.selectivity = n = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckConstraint(Session session, Expression expression) throws SQLException {
        this.resolver = new SingleColumnResolver(this);
        Column column = this;
        synchronized (column) {
            String string = this.name;
            if (this.name == null) {
                this.name = "VALUE";
            }
            expression.mapColumns(this.resolver, 0);
            this.name = string;
        }
        expression = expression.optimize(session);
        this.resolver.setValue(ValueNull.INSTANCE);
        column = this;
        synchronized (column) {
            expression.getValue(session);
        }
        this.checkConstraint = this.checkConstraint == null ? expression : new ConditionAndOr(0, this.checkConstraint, expression);
        this.checkConstraintSQL = this.getCheckConstraintSQL(session, this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(Session session, String string) throws SQLException {
        String string2;
        if (this.checkConstraint == null) {
            return null;
        }
        Parser parser = new Parser(session);
        Object object = this;
        synchronized (object) {
            String string3 = this.name;
            this.name = string;
            string2 = this.checkConstraint.getSQL();
            this.name = string3;
        }
        object = parser.parseExpression(string2);
        return object;
    }

    String getDefaultSQL() {
        return this.defaultExpression == null ? null : this.defaultExpression.getSQL();
    }

    int getPrecisionAsInt() {
        return MathUtils.convertLongToInt(this.precision);
    }

    DataType getDataType() {
        return DataType.getDataType(this.type);
    }

    String getCheckConstraintSQL(Session session, String string) throws SQLException {
        Expression expression = this.getCheckConstraint(session, string);
        return expression == null ? "" : expression.getSQL();
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 7 && this.sequence != null) {
            expressionVisitor.getDependencies().add(this.sequence);
        }
        if (this.defaultExpression != null && !this.defaultExpression.isEverything(expressionVisitor)) {
            return false;
        }
        return this.checkConstraint == null || this.checkConstraint.isEverything(expressionVisitor);
    }

    public boolean getPrimaryKey() {
        return this.primaryKey;
    }
}

