/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.oembedler.moon.graphql.boot.GraphQLJavaToolsAutoConfiguration;
import com.oembedler.moon.graphql.boot.GraphQLServletProperties;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import graphql.servlet.DefaultExecutionStrategyProvider;
import graphql.servlet.DefaultGraphQLSchemaProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.GraphQLRootObjectBuilder;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServlet;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.ObjectMapperConfigurer;
import graphql.servlet.SimpleGraphQLServlet;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.CorsRegistryWorkaround;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@Conditional(value={OnSchemaOrSchemaProvider.class})
@ConditionalOnProperty(value={"graphql.servlet.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={GraphQLJavaToolsAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLServletProperties.class})
public class GraphQLWebAutoConfiguration {
    public static final String QUERY_EXECUTION_STRATEGY = "queryExecutionStrategy";
    public static final String MUTATION_EXECUTION_STRATEGY = "mutationExecutionStrategy";
    public static final String SUBSCRIPTION_EXECUTION_STRATEGY = "subscriptionExecutionStrategy";
    @Autowired
    private GraphQLServletProperties graphQLServletProperties;
    @Autowired(required=false)
    private List<GraphQLServletListener> listeners;
    @Autowired(required=false)
    private Instrumentation instrumentation;
    @Autowired(required=false)
    private GraphQLErrorHandler errorHandler;
    @Autowired(required=false)
    private Map<String, ExecutionStrategy> executionStrategies;
    @Autowired(required=false)
    private GraphQLContextBuilder contextBuilder;
    @Autowired(required=false)
    private GraphQLRootObjectBuilder graphQLRootObjectBuilder;
    @Autowired(required=false)
    private ObjectMapperConfigurer objectMapperConfigurer;
    @Autowired(required=false)
    private PreparsedDocumentProvider preparsedDocumentProvider;

    @Bean
    @ConditionalOnClass(value={CorsFilter.class})
    @ConditionalOnProperty(value={"graphql.servlet.corsEnabled"}, havingValue="true", matchIfMissing=true)
    public CorsFilter corsConfigurer() {
        UrlBasedCorsConfigurationSource configurationSource = new UrlBasedCorsConfigurationSource();
        configurationSource.setCorsConfigurations(CorsRegistryWorkaround.getCorsConfiguration(this.graphQLServletProperties.getCorsMapping()));
        configurationSource.setAlwaysUseFullPath(true);
        return new CorsFilter((CorsConfigurationSource)configurationSource);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchemaProvider graphQLSchemaProvider(GraphQLSchema schema) {
        return new DefaultGraphQLSchemaProvider(schema);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExecutionStrategyProvider executionStrategyProvider() {
        if (this.executionStrategies == null || this.executionStrategies.isEmpty()) {
            return new DefaultExecutionStrategyProvider();
        }
        if (this.executionStrategies.entrySet().size() == 1) {
            return new DefaultExecutionStrategyProvider((ExecutionStrategy)((Map.Entry)this.executionStrategies.entrySet().stream().findFirst().get()).getValue());
        }
        if (!this.executionStrategies.containsKey(QUERY_EXECUTION_STRATEGY)) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        if (this.executionStrategies.size() == 2 && !this.executionStrategies.containsKey(MUTATION_EXECUTION_STRATEGY) && !this.executionStrategies.containsKey(SUBSCRIPTION_EXECUTION_STRATEGY)) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        if (!(this.executionStrategies.size() < 3 || this.executionStrategies.containsKey(MUTATION_EXECUTION_STRATEGY) && this.executionStrategies.containsKey(SUBSCRIPTION_EXECUTION_STRATEGY))) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        return new DefaultExecutionStrategyProvider(this.executionStrategies.get(QUERY_EXECUTION_STRATEGY), this.executionStrategies.get(MUTATION_EXECUTION_STRATEGY), this.executionStrategies.get(SUBSCRIPTION_EXECUTION_STRATEGY));
    }

    private void throwIncorrectExecutionStrategyNameException() {
        throw new IllegalStateException(String.format("When defining more than one execution strategy, they must be named %s, %s, or %s", QUERY_EXECUTION_STRATEGY, MUTATION_EXECUTION_STRATEGY, SUBSCRIPTION_EXECUTION_STRATEGY));
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLServlet graphQLServlet(GraphQLSchemaProvider schemaProvider, ExecutionStrategyProvider executionStrategyProvider) {
        return new SimpleGraphQLServlet(schemaProvider, executionStrategyProvider, this.objectMapperConfigurer, this.listeners, this.instrumentation, this.errorHandler, this.contextBuilder, this.graphQLRootObjectBuilder, this.preparsedDocumentProvider);
    }

    @Bean
    ServletRegistrationBean graphQLServletRegistrationBean(GraphQLServlet servlet) {
        return new ServletRegistrationBean((Servlet)servlet, new String[]{this.graphQLServletProperties.getServletMapping()});
    }

    static class OnSchemaOrSchemaProvider
    extends AnyNestedCondition {
        public OnSchemaOrSchemaProvider() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={GraphQLSchemaProvider.class})
        static class OnSchemaProvider {
            OnSchemaProvider() {
            }
        }

        @ConditionalOnBean(value={GraphQLSchema.class})
        static class OnSchema {
            OnSchema() {
            }
        }
    }
}

