/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static final String ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO8601_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String ISO8601_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_PATTERN = "MM/dd/yyyy";
    public static final String TIME_PATTERN = "h:mm aa";
    public static final String LOCAL_DATE_PATTERN = "MM/dd/yyyy";
    public static final String LOCAL_TIME_PATTERN = "h:mm a";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private DateUtils() {
    }

    public static long utc() {
        return DateUtils.utc(new Date());
    }

    public static long utc(Date date) {
        return DateUtils.utc(date.getTime());
    }

    public static long utc(long date) {
        return date - DateUtils.offset(date);
    }

    public static long offset(long time) {
        return TimeZone.getDefault().getOffset(time);
    }

    public static Date parse(String date) throws ParseException {
        return new SimpleDateFormat(ISO8601).parse(date);
    }

    public static String toString(Date date) {
        return new SimpleDateFormat(ISO8601_TZ).format(date);
    }

    public static String toString(ZonedDateTime date) {
        return String.valueOf(date.toInstant());
    }

    public static String toUTCString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(ISO8601_UTC);
        formatter.setTimeZone(UTC);
        return formatter.format(date);
    }

    public static LocalDate toLocalDate(long timestamp) {
        return DateUtils.toLocalDate(Instant.ofEpochMilli(timestamp));
    }

    public static LocalDate toLocalDate(Instant instant) {
        return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(Date time) {
        if (time != null) {
            return DateUtils.toLocalTime(time.getTime());
        }
        return null;
    }

    public static LocalTime toLocalTime(long timestamp) {
        return DateUtils.toLocalTime(Instant.ofEpochMilli(timestamp));
    }

    public static LocalTime toLocalTime(Instant instant) {
        return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate date, LocalTime time) {
        return LocalDateTime.of(date, time != null ? time : LocalTime.MIDNIGHT);
    }

    public static ZonedDateTime toZuluDateTime(long timestamp) {
        return DateUtils.toZuluDateTime(Instant.ofEpochMilli(timestamp));
    }

    public static ZonedDateTime toZuluDateTime(Instant instant) {
        return DateUtils.toZonedDateTime(instant, ZoneOffset.UTC);
    }

    public static ZonedDateTime toZonedDateTime(long timestamp, ZoneOffset offset) {
        return DateUtils.toZonedDateTime(Instant.ofEpochMilli(timestamp), offset);
    }

    public static ZonedDateTime toZonedDateTime(Instant instant, ZoneOffset offset) {
        return ZonedDateTime.ofInstant(instant, offset);
    }
}

