/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core;

import com.googlecode.wicket.jquery.core.utils.DateUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.io.IClusterable;

public class Options
implements IClusterable {
    private static final long serialVersionUID = 1L;
    public static final String QUOTE = "\"";
    private final Map<String, Serializable> map = new HashMap<String, Serializable>();

    public static String asString(Object value) {
        return Options.asString(String.valueOf(value));
    }

    public static String asString(String value) {
        return String.format("%s%s%s", QUOTE, String.valueOf(value).replace(QUOTE, "\\\""), QUOTE);
    }

    public static String asDate(Date date) {
        return Options.asString(DateUtils.toISO8601(date));
    }

    public static String fromArray(Object ... objects) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(objects[i]);
        }
        return builder.toString();
    }

    public Options() {
    }

    public Options(String key, Serializable value) {
        this();
        this.set(key, value);
    }

    public Serializable get(String key) {
        return this.map.get(key);
    }

    public final Options set(String key, Serializable value) {
        if (value != null) {
            this.map.put(key, value);
        } else {
            this.map.remove(key);
        }
        return this;
    }

    public Set<Map.Entry<String, Serializable>> entries() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{ ");
        int i = 0;
        for (Map.Entry<String, Serializable> entry : this.map.entrySet()) {
            if (i++ > 0) {
                builder.append(", ");
            }
            builder.append(QUOTE).append(entry.getKey()).append(QUOTE).append(": ").append(entry.getValue());
        }
        return builder.append(" }").toString();
    }
}

