/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.util.TomcatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.logging.Log;

public final class ForkedTomcatShutdownHook
extends Thread {
    private static final long SLEEPTIME = 10000L;
    private final File binDirectory;
    private final Log log;

    public ForkedTomcatShutdownHook(File binDirectory, Log log) {
        this.binDirectory = binDirectory;
        this.log = log;
    }

    @Override
    public void run() {
        ProcessBuilder processBuilder = new ProcessBuilder(TomcatUtil.getStopScriptName(), "stop");
        int exitValue = -1;
        try {
            String line;
            Process p = processBuilder.directory(this.binDirectory).start();
            InputStream is = p.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                this.log.info((CharSequence)line);
            }
            exitValue = p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        this.log.debug((CharSequence)("Exit-Value ForkedTomcatShutdownHook " + exitValue));
    }
}

