/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.JarArtifact;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;

final class TomcatJarArtifactHelper {
    protected Properties tomcatLibs = new Properties();

    TomcatJarArtifactHelper() {
    }

    List<JarArtifact> getTomcatArtifacts(String tomcatVersion) throws MojoExecutionException {
        ArrayList<JarArtifact> tomcatArtifactList = new ArrayList<JarArtifact>();
        try {
            this.tomcatLibs.load(TomcatJarArtifactHelper.class.getResourceAsStream("artifacts.properties"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        for (Map.Entry<Object, Object> entry : this.tomcatLibs.entrySet()) {
            String groupId = entry.getKey().toString().substring(0, entry.getKey().toString().lastIndexOf("."));
            String artifactId = entry.getValue().toString();
            String version = null;
            if (artifactId.startsWith("tomcat-")) {
                version = tomcatVersion;
            } else {
                String[] split = artifactId.split(":");
                version = split[1];
                artifactId = split[0];
            }
            JarArtifact jarArtifact = new JarArtifact();
            jarArtifact.setGroupId(groupId);
            jarArtifact.setArtifactId(artifactId);
            jarArtifact.setVersion(version);
            tomcatArtifactList.add(jarArtifact);
        }
        return tomcatArtifactList;
    }
}

