/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.AbstractArtifact;
import com.googlecode.t7mp.MyArtifactResolver;
import com.googlecode.t7mp.SetupUtil;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.WebappArtifact;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

class TomcatArtifactDispatcher {
    protected MyArtifactResolver myArtifactResolver;
    protected List<AbstractArtifact> resolvedArtifacts = new ArrayList<AbstractArtifact>();
    protected File catalinaBaseDir;
    protected SetupUtil setupUtil;
    protected Log log;

    public TomcatArtifactDispatcher(MyArtifactResolver myArtifactResolver, File catalinaBaseDir, SetupUtil setupUtil, Log log) {
        this.myArtifactResolver = myArtifactResolver;
        this.catalinaBaseDir = catalinaBaseDir;
        this.setupUtil = setupUtil;
        this.log = log;
    }

    public TomcatArtifactDispatcher resolveArtifacts(List<? extends AbstractArtifact> artifacts) {
        for (AbstractArtifact abstractArtifact : artifacts) {
            Artifact artifact;
            this.log.debug((CharSequence)("Resolve artifact for " + abstractArtifact.toString()));
            try {
                artifact = this.myArtifactResolver.resolve(abstractArtifact.getGroupId(), abstractArtifact.getArtifactId(), abstractArtifact.getVersion(), abstractArtifact.getType(), "compile");
            }
            catch (MojoExecutionException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
            abstractArtifact.setArtifact(artifact);
            this.resolvedArtifacts.add(abstractArtifact);
        }
        return this;
    }

    public void copyTo(String directoryName) {
        for (AbstractArtifact artifact : this.resolvedArtifacts) {
            try {
                String targetFileName = this.createTargetFileName(artifact);
                File sourceFile = artifact.getArtifact().getFile();
                File targetFile = new File(this.catalinaBaseDir, "/" + directoryName + "/" + targetFileName);
                this.log.debug((CharSequence)("Copy artifact from " + sourceFile.getAbsolutePath() + " to " + targetFile.getAbsolutePath()));
                this.setupUtil.copy(new FileInputStream(sourceFile), new FileOutputStream(targetFile));
            }
            catch (IOException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
        }
    }

    protected String createTargetFileName(AbstractArtifact abstractArtifact) {
        if (abstractArtifact.getClass().isAssignableFrom(WebappArtifact.class)) {
            return ((WebappArtifact)abstractArtifact).getContextPath() + "." + abstractArtifact.getType();
        }
        return abstractArtifact.getArtifactId() + "-" + abstractArtifact.getVersion() + "." + abstractArtifact.getType();
    }

    void clear() {
        this.resolvedArtifacts.clear();
    }
}

