/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.search.hibernate;

import com.googlecode.genericdao.search.Metadata;
import com.googlecode.genericdao.search.hibernate.HibernateNonEntityMetadata;
import java.io.Serializable;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class HibernateEntityMetadata
implements Metadata {
    private SessionFactory sessionFactory;
    private ClassMetadata metadata;
    private Class<?> collectionType;

    public HibernateEntityMetadata(SessionFactory sessionFactory, ClassMetadata classMetadata, Class<?> collectionType) {
        this.sessionFactory = sessionFactory;
        this.metadata = classMetadata;
        this.collectionType = collectionType;
    }

    public String getEntityName() {
        return this.metadata.getEntityName();
    }

    public String getIdProperty() {
        return this.metadata.getIdentifierPropertyName();
    }

    public Metadata getIdType() {
        return new HibernateNonEntityMetadata(this.sessionFactory, this.metadata.getIdentifierType(), null);
    }

    public Serializable getIdValue(Object object) {
        return this.metadata.getIdentifier(object, null);
    }

    public Class<?> getJavaClass() {
        return this.metadata.getMappedClass();
    }

    public String[] getProperties() {
        String[] pn = this.metadata.getPropertyNames();
        String[] result = new String[pn.length + 1];
        result[0] = this.metadata.getIdentifierPropertyName();
        for (int i = 0; i < pn.length; ++i) {
            result[i + 1] = pn[i];
        }
        return result;
    }

    public Metadata getPropertyType(String property) {
        Type pType = this.metadata.getPropertyType(property);
        Class pCollectionType = null;
        if (pType.isCollectionType()) {
            pType = ((CollectionType)pType).getElementType((SessionFactoryImplementor)this.sessionFactory);
            pCollectionType = pType.getReturnedClass();
        }
        if (pType.isEntityType()) {
            return new HibernateEntityMetadata(this.sessionFactory, this.sessionFactory.getClassMetadata(((EntityType)pType).getName()), pCollectionType);
        }
        return new HibernateNonEntityMetadata(this.sessionFactory, pType, pCollectionType);
    }

    public Object getPropertyValue(Object object, String property) {
        if (this.getIdProperty().equals(property)) {
            return this.getIdValue(object);
        }
        return this.metadata.getPropertyValue(object, property);
    }

    public boolean isCollection() {
        return this.collectionType != null;
    }

    public Class<?> getCollectionClass() {
        return this.collectionType;
    }

    public boolean isEmeddable() {
        return false;
    }

    public boolean isEntity() {
        return true;
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isString() {
        return false;
    }
}

