/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import com.googlecode.flyway.core.util.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FeatureDetector {
    private static final Log LOG = LogFactory.getLog(FeatureDetector.class);
    private static Boolean springJdbcAvailable;
    private static Boolean jbossVfsAvailable;
    private static Boolean equinoxCommonAvailable;

    private FeatureDetector() {
    }

    public static boolean isSpringJdbcAvailable() {
        if (springJdbcAvailable == null) {
            springJdbcAvailable = ClassUtils.isPresent("org.springframework.jdbc.core.JdbcTemplate");
            LOG.debug((Object)("Spring Jdbc available: " + springJdbcAvailable));
        }
        return springJdbcAvailable;
    }

    public static boolean isJBossVFSAvailable() {
        if (jbossVfsAvailable == null) {
            jbossVfsAvailable = ClassUtils.isPresent("org.jboss.vfs.VFS");
            LOG.debug((Object)("JBoss VFS available: " + jbossVfsAvailable));
        }
        return jbossVfsAvailable;
    }

    public static boolean isEquinoxCommonAvailable() {
        if (equinoxCommonAvailable == null) {
            equinoxCommonAvailable = ClassUtils.isPresent("org.eclipse.core.runtime.FileLocator");
            LOG.debug((Object)("Equinox Common OSGi Bundle available: " + equinoxCommonAvailable));
        }
        return equinoxCommonAvailable;
    }
}

