/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.spring;

import com.googlecode.flyway.core.api.migration.spring.SpringJdbcMigration;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.spring.SpringJdbcMigrationExecutor;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.scanner.ClassPathScanner;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringJdbcMigrationResolver
implements MigrationResolver {
    private final String basePackage;

    public SpringJdbcMigrationResolver(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public List<Migration> resolveMigrations() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        try {
            Class<?>[] classes;
            for (Class<?> clazz : classes = new ClassPathScanner().scanForClasses(this.basePackage, SpringJdbcMigration.class)) {
                SpringJdbcMigration springJdbcMigration = (SpringJdbcMigration)ClassUtils.instantiate(clazz.getName());
                migrations.add(new SpringJdbcMigrationExecutor(springJdbcMigration));
            }
        }
        catch (Exception e) {
            throw new FlywayException("Unable to resolve Spring Jdbc Java migrations in location: " + this.basePackage, e);
        }
        return migrations;
    }
}

