/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.Collections;
import com.google.zxing.common.Comparator;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Hashtable;
import java.util.Vector;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 57;
    private static final int INTEGER_MATH_SHIFT = 8;
    private final BitMatrix image;
    private final Vector possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix image) {
        this(image, null);
    }

    public FinderPatternFinder(BitMatrix image, ResultPointCallback resultPointCallback) {
        this.image = image;
        this.possibleCenters = new Vector();
        this.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    protected BitMatrix getImage() {
        return this.image;
    }

    protected Vector getPossibleCenters() {
        return this.possibleCenters;
    }

    FinderPatternInfo find(Hashtable hints) throws NotFoundException {
        boolean tryHarder = hints != null && hints.containsKey(DecodeHintType.TRY_HARDER);
        int maxI = this.image.getHeight();
        int maxJ = this.image.getWidth();
        int iSkip = 3 * maxI / 228;
        if (iSkip < 3 || tryHarder) {
            iSkip = 3;
        }
        boolean done = false;
        int[] stateCount = new int[5];
        for (int i = iSkip - 1; i < maxI && !done; i += iSkip) {
            boolean confirmed;
            stateCount[0] = 0;
            stateCount[1] = 0;
            stateCount[2] = 0;
            stateCount[3] = 0;
            stateCount[4] = 0;
            int currentState = 0;
            for (int j = 0; j < maxJ; ++j) {
                block5: {
                    block6: {
                        block7: {
                            block10: {
                                block8: {
                                    block9: {
                                        if (this.image.get(j, i)) {
                                            if (currentState & true) {
                                                // empty if block
                                            }
                                            int n = ++currentState;
                                            stateCount[n] = stateCount[n] + 1;
                                            continue;
                                        }
                                        if (currentState & true) break block5;
                                        if (currentState != 4) break block6;
                                        if (!FinderPatternFinder.foundPatternCross(stateCount)) break block7;
                                        boolean confirmed2 = this.handlePossibleCenter(stateCount, i, j);
                                        if (!confirmed2) break block8;
                                        iSkip = 2;
                                        if (!this.hasSkipped) break block9;
                                        done = this.haveMultiplyConfirmedCenters();
                                        break block10;
                                    }
                                    int rowSkip = this.findRowSkip();
                                    if (rowSkip <= stateCount[2]) break block10;
                                    i += rowSkip - stateCount[2] - iSkip;
                                    j = maxJ - 1;
                                    break block10;
                                }
                                stateCount[0] = stateCount[2];
                                stateCount[1] = stateCount[3];
                                stateCount[2] = stateCount[4];
                                stateCount[3] = 1;
                                stateCount[4] = 0;
                                currentState = 3;
                                continue;
                            }
                            currentState = 0;
                            stateCount[0] = 0;
                            stateCount[1] = 0;
                            stateCount[2] = 0;
                            stateCount[3] = 0;
                            stateCount[4] = 0;
                            continue;
                        }
                        stateCount[0] = stateCount[2];
                        stateCount[1] = stateCount[3];
                        stateCount[2] = stateCount[4];
                        stateCount[3] = 1;
                        stateCount[4] = 0;
                        currentState = 3;
                        continue;
                    }
                    int n = ++currentState;
                    stateCount[n] = stateCount[n] + 1;
                    continue;
                }
                int n = currentState;
                stateCount[n] = stateCount[n] + 1;
            }
            if (!FinderPatternFinder.foundPatternCross(stateCount) || !(confirmed = this.handlePossibleCenter(stateCount, i, maxJ))) continue;
            iSkip = stateCount[0];
            if (!this.hasSkipped) continue;
            done = this.haveMultiplyConfirmedCenters();
        }
        ResultPoint[] patternInfo = this.selectBestPatterns();
        ResultPoint.orderBestPatterns(patternInfo);
        return new FinderPatternInfo((FinderPattern[])patternInfo);
    }

    private static float centerFromEnd(int[] stateCount, int end) {
        return (float)(end - stateCount[4] - stateCount[3]) - (float)stateCount[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] stateCount) {
        int totalModuleSize = 0;
        for (int i = 0; i < 5; ++i) {
            int count = stateCount[i];
            if (count == 0) {
                return false;
            }
            totalModuleSize += count;
        }
        if (totalModuleSize < 7) {
            return false;
        }
        int moduleSize = (totalModuleSize << 8) / 7;
        int maxVariance = moduleSize / 2;
        return Math.abs(moduleSize - (stateCount[0] << 8)) < maxVariance && Math.abs(moduleSize - (stateCount[1] << 8)) < maxVariance && Math.abs(3 * moduleSize - (stateCount[2] << 8)) < 3 * maxVariance && Math.abs(moduleSize - (stateCount[3] << 8)) < maxVariance && Math.abs(moduleSize - (stateCount[4] << 8)) < maxVariance;
    }

    private int[] getCrossCheckStateCount() {
        this.crossCheckStateCount[0] = 0;
        this.crossCheckStateCount[1] = 0;
        this.crossCheckStateCount[2] = 0;
        this.crossCheckStateCount[3] = 0;
        this.crossCheckStateCount[4] = 0;
        return this.crossCheckStateCount;
    }

    private float crossCheckVertical(int startI, int centerJ, int maxCount, int originalStateCountTotal) {
        int i;
        BitMatrix image = this.image;
        int maxI = image.getHeight();
        int[] stateCount = this.getCrossCheckStateCount();
        for (i = startI; i >= 0 && image.get(centerJ, i); --i) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (i < 0) {
            return Float.NaN;
        }
        while (i >= 0 && !image.get(centerJ, i) && stateCount[1] <= maxCount) {
            stateCount[1] = stateCount[1] + 1;
            --i;
        }
        if (i < 0 || stateCount[1] > maxCount) {
            return Float.NaN;
        }
        while (i >= 0 && image.get(centerJ, i) && stateCount[0] <= maxCount) {
            stateCount[0] = stateCount[0] + 1;
            --i;
        }
        if (stateCount[0] > maxCount) {
            return Float.NaN;
        }
        for (i = startI + 1; i < maxI && image.get(centerJ, i); ++i) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (i == maxI) {
            return Float.NaN;
        }
        while (i < maxI && !image.get(centerJ, i) && stateCount[3] < maxCount) {
            stateCount[3] = stateCount[3] + 1;
            ++i;
        }
        if (i == maxI || stateCount[3] >= maxCount) {
            return Float.NaN;
        }
        while (i < maxI && image.get(centerJ, i) && stateCount[4] < maxCount) {
            stateCount[4] = stateCount[4] + 1;
            ++i;
        }
        if (stateCount[4] >= maxCount) {
            return Float.NaN;
        }
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= 2 * originalStateCountTotal) {
            return Float.NaN;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) ? FinderPatternFinder.centerFromEnd(stateCount, i) : Float.NaN;
    }

    private float crossCheckHorizontal(int startJ, int centerI, int maxCount, int originalStateCountTotal) {
        int j;
        BitMatrix image = this.image;
        int maxJ = image.getWidth();
        int[] stateCount = this.getCrossCheckStateCount();
        for (j = startJ; j >= 0 && image.get(j, centerI); --j) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (j < 0) {
            return Float.NaN;
        }
        while (j >= 0 && !image.get(j, centerI) && stateCount[1] <= maxCount) {
            stateCount[1] = stateCount[1] + 1;
            --j;
        }
        if (j < 0 || stateCount[1] > maxCount) {
            return Float.NaN;
        }
        while (j >= 0 && image.get(j, centerI) && stateCount[0] <= maxCount) {
            stateCount[0] = stateCount[0] + 1;
            --j;
        }
        if (stateCount[0] > maxCount) {
            return Float.NaN;
        }
        for (j = startJ + 1; j < maxJ && image.get(j, centerI); ++j) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (j == maxJ) {
            return Float.NaN;
        }
        while (j < maxJ && !image.get(j, centerI) && stateCount[3] < maxCount) {
            stateCount[3] = stateCount[3] + 1;
            ++j;
        }
        if (j == maxJ || stateCount[3] >= maxCount) {
            return Float.NaN;
        }
        while (j < maxJ && image.get(j, centerI) && stateCount[4] < maxCount) {
            stateCount[4] = stateCount[4] + 1;
            ++j;
        }
        if (stateCount[4] >= maxCount) {
            return Float.NaN;
        }
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= originalStateCountTotal) {
            return Float.NaN;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) ? FinderPatternFinder.centerFromEnd(stateCount, j) : Float.NaN;
    }

    protected boolean handlePossibleCenter(int[] stateCount, int i, int j) {
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        float centerJ = FinderPatternFinder.centerFromEnd(stateCount, j);
        float centerI = this.crossCheckVertical(i, (int)centerJ, stateCount[2], stateCountTotal);
        if (!Float.isNaN(centerI) && !Float.isNaN(centerJ = this.crossCheckHorizontal((int)centerJ, (int)centerI, stateCount[2], stateCountTotal))) {
            float estimatedModuleSize = (float)stateCountTotal / 7.0f;
            boolean found = false;
            int max = this.possibleCenters.size();
            for (int index = 0; index < max; ++index) {
                FinderPattern center = (FinderPattern)this.possibleCenters.elementAt(index);
                if (!center.aboutEquals(estimatedModuleSize, centerI, centerJ)) continue;
                center.incrementCount();
                found = true;
                break;
            }
            if (!found) {
                FinderPattern point = new FinderPattern(centerJ, centerI, estimatedModuleSize);
                this.possibleCenters.addElement(point);
                if (this.resultPointCallback != null) {
                    this.resultPointCallback.foundPossibleResultPoint(point);
                }
            }
            return true;
        }
        return false;
    }

    private int findRowSkip() {
        int max = this.possibleCenters.size();
        if (max <= 1) {
            return 0;
        }
        FinderPattern firstConfirmedCenter = null;
        for (int i = 0; i < max; ++i) {
            FinderPattern center = (FinderPattern)this.possibleCenters.elementAt(i);
            if (center.getCount() < 2) continue;
            if (firstConfirmedCenter == null) {
                firstConfirmedCenter = center;
                continue;
            }
            this.hasSkipped = true;
            return (int)(Math.abs(firstConfirmedCenter.getX() - center.getX()) - Math.abs(firstConfirmedCenter.getY() - center.getY())) / 2;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        int confirmedCount = 0;
        float totalModuleSize = 0.0f;
        int max = this.possibleCenters.size();
        for (int i = 0; i < max; ++i) {
            FinderPattern pattern = (FinderPattern)this.possibleCenters.elementAt(i);
            if (pattern.getCount() < 2) continue;
            ++confirmedCount;
            totalModuleSize += pattern.getEstimatedModuleSize();
        }
        if (confirmedCount < 3) {
            return false;
        }
        float average = totalModuleSize / (float)max;
        float totalDeviation = 0.0f;
        for (int i = 0; i < max; ++i) {
            FinderPattern pattern = (FinderPattern)this.possibleCenters.elementAt(i);
            totalDeviation += Math.abs(pattern.getEstimatedModuleSize() - average);
        }
        return totalDeviation <= 0.05f * totalModuleSize;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        float totalModuleSize;
        int startSize = this.possibleCenters.size();
        if (startSize < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (startSize > 3) {
            totalModuleSize = 0.0f;
            float square = 0.0f;
            for (int i = 0; i < startSize; ++i) {
                float size = ((FinderPattern)this.possibleCenters.elementAt(i)).getEstimatedModuleSize();
                totalModuleSize += size;
                square += size * size;
            }
            float average = totalModuleSize / (float)startSize;
            float stdDev = (float)Math.sqrt(square / (float)startSize - average * average);
            Collections.insertionSort(this.possibleCenters, new FurthestFromAverageComparator(average));
            float limit = Math.max(0.2f * average, stdDev);
            for (int i = 0; i < this.possibleCenters.size() && this.possibleCenters.size() > 3; ++i) {
                FinderPattern pattern = (FinderPattern)this.possibleCenters.elementAt(i);
                if (!(Math.abs(pattern.getEstimatedModuleSize() - average) > limit)) continue;
                this.possibleCenters.removeElementAt(i);
                --i;
            }
        }
        if (this.possibleCenters.size() > 3) {
            totalModuleSize = 0.0f;
            for (int i = 0; i < this.possibleCenters.size(); ++i) {
                totalModuleSize += ((FinderPattern)this.possibleCenters.elementAt(i)).getEstimatedModuleSize();
            }
            float average = totalModuleSize / (float)this.possibleCenters.size();
            Collections.insertionSort(this.possibleCenters, new CenterComparator(average));
            this.possibleCenters.setSize(3);
        }
        return new FinderPattern[]{(FinderPattern)this.possibleCenters.elementAt(0), (FinderPattern)this.possibleCenters.elementAt(1), (FinderPattern)this.possibleCenters.elementAt(2)};
    }

    private static class CenterComparator
    implements Comparator {
        private final float average;

        private CenterComparator(float f) {
            this.average = f;
        }

        @Override
        public int compare(Object center1, Object center2) {
            if (((FinderPattern)center2).getCount() == ((FinderPattern)center1).getCount()) {
                float dB;
                float dA = Math.abs(((FinderPattern)center2).getEstimatedModuleSize() - this.average);
                return dA < (dB = Math.abs(((FinderPattern)center1).getEstimatedModuleSize() - this.average)) ? 1 : (dA == dB ? 0 : -1);
            }
            return ((FinderPattern)center2).getCount() - ((FinderPattern)center1).getCount();
        }
    }

    private static class FurthestFromAverageComparator
    implements Comparator {
        private final float average;

        private FurthestFromAverageComparator(float f) {
            this.average = f;
        }

        @Override
        public int compare(Object center1, Object center2) {
            float dB;
            float dA = Math.abs(((FinderPattern)center2).getEstimatedModuleSize() - this.average);
            return dA < (dB = Math.abs(((FinderPattern)center1).getEstimatedModuleSize() - this.average)) ? -1 : (dA == dB ? 0 : 1);
        }
    }
}

