/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.ByteString;

public class UrlSigner {
    private static final String ALGORITHM_HMAC_SHA1 = "HmacSHA1";
    private final Mac mac;

    public UrlSigner(String keyString) throws NoSuchAlgorithmException, InvalidKeyException {
        String base64 = keyString.replace('-', '+').replace('_', '/');
        ByteString decodedKey = ByteString.decodeBase64((String)base64);
        if (decodedKey == null) {
            throw new IllegalArgumentException("Private key is invalid.");
        }
        this.mac = Mac.getInstance(ALGORITHM_HMAC_SHA1);
        this.mac.init(new SecretKeySpec(decodedKey.toByteArray(), ALGORITHM_HMAC_SHA1));
    }

    public String getSignature(String path) {
        byte[] digest = this.getMac().doFinal(path.getBytes());
        return ByteString.of((byte[])digest).base64().replace('+', '-').replace('/', '_');
    }

    private Mac getMac() {
        try {
            return (Mac)this.mac.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

