/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.refactoring.SuggestedFix;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ErrorToFixMapper {
    private static final Pattern DID_YOU_MEAN = Pattern.compile(".*Did you mean (.*)\\?");
    private static final Pattern MISSING_REQUIRE = Pattern.compile("'([^']+)' used but not goog\\.require'd");
    private static final Pattern EXTRA_REQUIRE = Pattern.compile("'([^']+)' goog\\.require'd but not used");

    private ErrorToFixMapper() {
    }

    public static List<SuggestedFix> getFixesForJsError(JSError error, AbstractCompiler compiler) {
        SuggestedFix fix = ErrorToFixMapper.getFixForJsError(error, compiler);
        if (fix != null) {
            return ImmutableList.of((Object)fix);
        }
        switch (error.getType().key) {
            case "JSC_IMPLICITLY_NULLABLE_JSDOC": {
                return ErrorToFixMapper.getFixesForImplicitlyNullableJsDoc(error);
            }
        }
        return ImmutableList.of();
    }

    public static SuggestedFix getFixForJsError(JSError error, AbstractCompiler compiler) {
        switch (error.getType().key) {
            case "JSC_DEBUGGER_STATEMENT_PRESENT": {
                return ErrorToFixMapper.getFixForDebuggerStatement(error);
            }
            case "JSC_INEXISTENT_PROPERTY": {
                return ErrorToFixMapper.getFixForInexistentProperty(error);
            }
            case "JSC_MISSING_REQUIRE_WARNING": {
                return ErrorToFixMapper.getFixForMissingRequire(error, compiler);
            }
            case "JSC_EXTRA_REQUIRE_WARNING": {
                return ErrorToFixMapper.getFixForExtraRequire(error, compiler);
            }
            case "JSC_UNNECESSARY_CAST": {
                return ErrorToFixMapper.getFixForUnnecessaryCast(error, compiler);
            }
        }
        return null;
    }

    private static List<SuggestedFix> getFixesForImplicitlyNullableJsDoc(JSError error) {
        SuggestedFix qmark = new SuggestedFix.Builder().setOriginalMatchedNode(error.node).insertBefore(error.node, "?").setDescription("Make nullability explicit").build();
        SuggestedFix bang = new SuggestedFix.Builder().setOriginalMatchedNode(error.node).insertBefore(error.node, "!").setDescription("Make type non-nullable").build();
        return ImmutableList.of((Object)qmark, (Object)bang);
    }

    private static SuggestedFix getFixForDebuggerStatement(JSError error) {
        return new SuggestedFix.Builder().setOriginalMatchedNode(error.node).delete(error.node).build();
    }

    private static SuggestedFix getFixForInexistentProperty(JSError error) {
        Matcher m = DID_YOU_MEAN.matcher(error.description);
        if (m.matches()) {
            String suggestedPropName = m.group(1);
            return new SuggestedFix.Builder().setOriginalMatchedNode(error.node).rename(error.node, suggestedPropName).build();
        }
        return null;
    }

    private static SuggestedFix getFixForMissingRequire(JSError error, AbstractCompiler compiler) {
        Matcher regexMatcher = MISSING_REQUIRE.matcher(error.description);
        Preconditions.checkState((boolean)regexMatcher.matches(), (String)"Unexpected error description: %s", (Object[])new Object[]{error.description});
        String namespaceToRequire = regexMatcher.group(1);
        NodeMetadata metadata = new NodeMetadata(compiler);
        Match match = new Match(error.node, metadata);
        return new SuggestedFix.Builder().setOriginalMatchedNode(error.node).addGoogRequire(match, namespaceToRequire).build();
    }

    private static SuggestedFix getFixForExtraRequire(JSError error, AbstractCompiler compiler) {
        Matcher regexMatcher = EXTRA_REQUIRE.matcher(error.description);
        Preconditions.checkState((boolean)regexMatcher.matches(), (String)"Unexpected error description: %s", (Object[])new Object[]{error.description});
        String namespace = regexMatcher.group(1);
        NodeMetadata metadata = new NodeMetadata(compiler);
        Match match = new Match(error.node, metadata);
        return new SuggestedFix.Builder().setOriginalMatchedNode(error.node).removeGoogRequire(match, namespace).build();
    }

    private static SuggestedFix getFixForUnnecessaryCast(JSError error, AbstractCompiler compiler) {
        return new SuggestedFix.Builder().setOriginalMatchedNode(error.node).removeCast(error.node, compiler).build();
    }
}

