/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.shared.impl;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.ValueCodex;
import com.google.web.bindery.autobean.shared.impl.AbstractAutoBean;
import com.google.web.bindery.autobean.shared.impl.EnumMap;
import com.google.web.bindery.autobean.shared.impl.HasSplittable;
import com.google.web.bindery.autobean.shared.impl.SplittableComplexMap;
import com.google.web.bindery.autobean.shared.impl.SplittableList;
import com.google.web.bindery.autobean.shared.impl.SplittableSet;
import com.google.web.bindery.autobean.shared.impl.SplittableSimpleMap;
import com.google.web.bindery.autobean.shared.impl.StringQuoter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class AutoBeanCodexImpl {
    private static final Map<String, Coder> coderFor = new HashMap<String, Coder>();
    private static final Map<Class<?>, Coder> coders = new HashMap();

    public static Coder collectionCoder(Class<?> type, Coder elementCoder) {
        return new CollectionCoder(type, elementCoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Coder doCoderFor(AutoBean<?> bean, String propertyName) {
        Map<String, Coder> map = coderFor;
        synchronized (map) {
            String key = AutoBeanCodexImpl.key(bean, propertyName);
            Coder toReturn = coderFor.get(key);
            if (toReturn == null) {
                bean.accept(new PropertyCoderCreator());
                toReturn = coderFor.get(key);
                if (toReturn == null) {
                    throw new IllegalArgumentException(propertyName);
                }
            }
            return toReturn;
        }
    }

    public static <T> AutoBean<T> doDecode(EncodeState state, Class<T> clazz, Splittable data) {
        AutoBean<T> toReturn = (AutoBean<T>)data.getReified(AutoBeanCodexImpl.class.getName());
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = state.factory.create(clazz);
        data.setReified(AutoBeanCodexImpl.class.getName(), toReturn);
        if (toReturn == null) {
            throw new IllegalArgumentException(clazz.getName());
        }
        ((AbstractAutoBean)toReturn).setData(data);
        return toReturn;
    }

    public static void doDecodeInto(EncodeState state, Splittable data, AutoBean<?> bean) {
        new PropertySetter().decodeInto(state, data, bean);
    }

    public static void doEncode(EncodeState state, AutoBean<?> bean) {
        PropertyGetter e = new PropertyGetter(state);
        try {
            bean.accept(e);
        }
        catch (HaltException ex) {
            throw ex.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Enum<?>> Coder enumCoder(Class<E> type) {
        Map<Class<?>, Coder> map = coders;
        synchronized (map) {
            EnumCoder<E> toReturn = coders.get(type);
            if (toReturn == null) {
                toReturn = new EnumCoder<E>(type);
                coders.put(type, toReturn);
            }
            return toReturn;
        }
    }

    public static Coder mapCoder(Coder valueCoder, Coder keyCoder) {
        return new MapCoder(valueCoder, keyCoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Coder objectCoder(Class<?> type) {
        Map<Class<?>, Coder> map = coders;
        synchronized (map) {
            Coder toReturn = coders.get(type);
            if (toReturn == null) {
                toReturn = new ObjectCoder(type);
                coders.put(type, toReturn);
            }
            return toReturn;
        }
    }

    public static Coder splittableCoder() {
        return SplittableCoder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Coder valueCoder(Class<?> type) {
        Map<Class<?>, Coder> map = coders;
        synchronized (map) {
            Coder toReturn = coders.get(type);
            if (toReturn == null) {
                toReturn = new ValueCoder(type);
                coders.put(type, toReturn);
            }
            return toReturn;
        }
    }

    static Splittable tryExtractSplittable(Object value) {
        AutoBean bean = AutoBeanUtils.getAutoBean(value);
        if (bean != null) {
            value = bean;
        }
        if (bean instanceof HasSplittable) {
            return ((HasSplittable)((Object)bean)).getSplittable();
        }
        return null;
    }

    private static String key(AutoBean<?> bean, String propertyName) {
        String string = String.valueOf(bean.getType().getName());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(propertyName).length()).append(string).append(":").append(propertyName).toString();
    }

    static class ValueCoder
    implements Coder {
        private final Class<?> type;

        public ValueCoder(Class<?> type) {
            assert (type.getEnumConstants() == null) : "Should use EnumTypeCodex";
            this.type = type;
        }

        @Override
        public Object decode(EncodeState state, Splittable propertyValue) {
            if (propertyValue == null || propertyValue == Splittable.NULL) {
                return ValueCodex.getUninitializedFieldValue(this.type);
            }
            return ValueCodex.decode(this.type, propertyValue);
        }

        @Override
        public void encode(EncodeState state, Object value) {
            state.sb.append(ValueCodex.encode(this.type, value).getPayload());
        }

        @Override
        public Splittable extractSplittable(EncodeState state, Object value) {
            return ValueCodex.encode(this.type, value);
        }
    }

    static class SplittableCoder
    implements Coder {
        static final Coder INSTANCE = new SplittableCoder();

        SplittableCoder() {
        }

        @Override
        public Object decode(EncodeState state, Splittable data) {
            return data;
        }

        @Override
        public void encode(EncodeState state, Object value) {
            if (value == null) {
                state.sb.append("null");
                return;
            }
            state.sb.append(((Splittable)value).getPayload());
        }

        @Override
        public Splittable extractSplittable(EncodeState state, Object value) {
            return (Splittable)value;
        }
    }

    static class PropertySetter
    extends AutoBeanVisitor {
        private Splittable data;
        private EncodeState state;

        PropertySetter() {
        }

        public void decodeInto(EncodeState state, Splittable data, AutoBean<?> bean) {
            this.data = data;
            this.state = state;
            bean.accept(this);
        }

        @Override
        public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            this.decodeProperty(propertyName, ctx);
            return false;
        }

        @Override
        public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            this.decodeProperty(propertyName, ctx);
            return false;
        }

        protected void decodeProperty(String propertyName, AutoBeanVisitor.PropertyContext ctx) {
            if (!this.data.isNull(propertyName)) {
                CoderCreator pd = new CoderCreator();
                ctx.accept(pd);
                Coder decoder = pd.getCoder();
                Object propertyValue = decoder.decode(this.state, this.data.get(propertyName));
                ctx.set(propertyValue);
            }
        }
    }

    static class PropertyGetter
    extends AutoBeanVisitor {
        private boolean first = true;
        private final EncodeState state;

        public PropertyGetter(EncodeState state) {
            this.state = state;
        }

        @Override
        public void endVisit(AutoBean<?> bean, AutoBeanVisitor.Context ctx) {
            this.state.sb.append("}");
            this.state.seen.pop();
        }

        @Override
        public boolean visit(AutoBean<?> bean, AutoBeanVisitor.Context ctx) {
            if (this.state.seen.contains(bean)) {
                throw new HaltException(new UnsupportedOperationException("Cycles not supported"));
            }
            this.state.seen.push(bean);
            this.state.sb.append("{");
            return true;
        }

        @Override
        public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            if (value != null) {
                this.encodeProperty(propertyName, value.as(), ctx);
            }
            return false;
        }

        @Override
        public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            if (value != null && !value.equals(ValueCodex.getUninitializedFieldValue(ctx.getType()))) {
                this.encodeProperty(propertyName, value, ctx);
            }
            return false;
        }

        private void encodeProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            CoderCreator pd = new CoderCreator();
            ctx.accept(pd);
            Coder decoder = pd.getCoder();
            if (this.first) {
                this.first = false;
            } else {
                this.state.sb.append(",");
            }
            this.state.sb.append(StringQuoter.quote(propertyName));
            this.state.sb.append(":");
            decoder.encode(this.state, value);
        }
    }

    static class PropertyCoderCreator
    extends AutoBeanVisitor {
        private AutoBean<?> bean;

        PropertyCoderCreator() {
        }

        @Override
        public boolean visit(AutoBean<?> bean, AutoBeanVisitor.Context ctx) {
            this.bean = bean;
            return true;
        }

        @Override
        public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            this.maybeCreateCoder(propertyName, ctx);
            return false;
        }

        @Override
        public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            this.maybeCreateCoder(propertyName, ctx);
            return false;
        }

        private void maybeCreateCoder(String propertyName, AutoBeanVisitor.PropertyContext ctx) {
            CoderCreator creator = new CoderCreator();
            ctx.accept(creator);
            coderFor.put(AutoBeanCodexImpl.key(this.bean, propertyName), creator.getCoder());
        }
    }

    static class ObjectCoder
    implements Coder {
        private final Class<?> type;

        public ObjectCoder(Class<?> type) {
            this.type = type;
        }

        @Override
        public Object decode(EncodeState state, Splittable data) {
            AutoBean<?> bean = AutoBeanCodexImpl.doDecode(state, this.type, data);
            return bean == null ? null : bean.as();
        }

        @Override
        public void encode(EncodeState state, Object value) {
            if (value == null) {
                state.sb.append("null");
                return;
            }
            AutoBeanCodexImpl.doEncode(state, AutoBeanUtils.getAutoBean(value));
        }

        @Override
        public Splittable extractSplittable(EncodeState state, Object value) {
            return AutoBeanCodexImpl.tryExtractSplittable(value);
        }
    }

    static class MapCoder
    implements Coder {
        private final Coder keyDecoder;
        private final Coder valueDecoder;

        public MapCoder(Coder valueDecoder, Coder keyDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }

        @Override
        public Object decode(EncodeState state, Splittable data) {
            Map toReturn;
            if (data.isIndexed()) {
                if (!$assertionsDisabled && data.size() != 2) {
                    int n = data.size();
                    throw new AssertionError((Object)new StringBuilder(28).append("Wrong data size: ").append(n).toString());
                }
                toReturn = new SplittableComplexMap(data, this.keyDecoder, this.valueDecoder, state);
            } else {
                toReturn = new SplittableSimpleMap(data, this.keyDecoder, this.valueDecoder, state);
            }
            return toReturn;
        }

        @Override
        public void encode(EncodeState state, Object value) {
            if (value == null) {
                state.sb.append("null");
                return;
            }
            Map map = (Map)value;
            boolean isSimpleMap = this.keyDecoder instanceof ValueCoder;
            if (isSimpleMap) {
                boolean first = true;
                state.sb.append("{");
                for (Map.Entry entry : map.entrySet()) {
                    Object mapKey = entry.getKey();
                    if (mapKey == null) continue;
                    Object mapValue = entry.getValue();
                    if (first) {
                        first = false;
                    } else {
                        state.sb.append(",");
                    }
                    this.keyDecoder.encode(state, mapKey);
                    state.sb.append(":");
                    if (mapValue == null) {
                        state.sb.append("null");
                        continue;
                    }
                    this.valueDecoder.encode(state, mapValue);
                }
                state.sb.append("}");
            } else {
                ArrayList keys = new ArrayList(map.size());
                ArrayList values = new ArrayList(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    keys.add(entry.getKey());
                    values.add(entry.getValue());
                }
                state.sb.append("[");
                AutoBeanCodexImpl.collectionCoder(List.class, this.keyDecoder).encode(state, keys);
                state.sb.append(",");
                AutoBeanCodexImpl.collectionCoder(List.class, this.valueDecoder).encode(state, values);
                state.sb.append("]");
            }
        }

        @Override
        public Splittable extractSplittable(EncodeState state, Object value) {
            return AutoBeanCodexImpl.tryExtractSplittable(value);
        }
    }

    static class HaltException
    extends RuntimeException {
        public HaltException(RuntimeException cause) {
            super(cause);
        }

        @Override
        public RuntimeException getCause() {
            return (RuntimeException)super.getCause();
        }
    }

    static class EnumCoder<E extends Enum<?>>
    implements Coder {
        private final Class<E> type;

        public EnumCoder(Class<E> type) {
            this.type = type;
        }

        @Override
        public Object decode(EncodeState state, Splittable data) {
            return state.enumMap.getEnum(this.type, data.asString());
        }

        @Override
        public void encode(EncodeState state, Object value) {
            if (value == null) {
                state.sb.append("null");
                return;
            }
            state.sb.append(StringQuoter.quote(state.enumMap.getToken((Enum)value)));
        }

        @Override
        public Splittable extractSplittable(EncodeState state, Object value) {
            return StringQuoter.split(StringQuoter.quote(state.enumMap.getToken((Enum)value)));
        }
    }

    static class CollectionCoder
    implements Coder {
        private final Coder elementDecoder;
        private final Class<?> type;

        public CollectionCoder(Class<?> type, Coder elementDecoder) {
            this.elementDecoder = elementDecoder;
            this.type = type;
        }

        @Override
        public Object decode(EncodeState state, Splittable data) {
            AbstractCollection collection;
            if (List.class.equals(this.type)) {
                collection = new SplittableList(data, this.elementDecoder, state);
            } else if (Set.class.equals(this.type)) {
                collection = new SplittableSet(data, this.elementDecoder, state);
            } else {
                throw new RuntimeException(this.type.getName());
            }
            return collection;
        }

        @Override
        public void encode(EncodeState state, Object value) {
            if (value == null) {
                state.sb.append("null");
                return;
            }
            Iterator it = ((Collection)value).iterator();
            state.sb.append("[");
            if (it.hasNext()) {
                this.elementDecoder.encode(state, it.next());
                while (it.hasNext()) {
                    state.sb.append(",");
                    this.elementDecoder.encode(state, it.next());
                }
            }
            state.sb.append("]");
        }

        @Override
        public Splittable extractSplittable(EncodeState state, Object value) {
            return AutoBeanCodexImpl.tryExtractSplittable(value);
        }
    }

    static class CoderCreator
    extends AutoBeanVisitor.ParameterizationVisitor {
        private Stack<Coder> stack = new Stack();

        CoderCreator() {
        }

        @Override
        public void endVisitType(Class<?> type) {
            if (List.class.equals(type) || Set.class.equals(type)) {
                this.stack.push(AutoBeanCodexImpl.collectionCoder(type, this.stack.pop()));
            } else if (Map.class.equals(type)) {
                this.stack.push(AutoBeanCodexImpl.mapCoder(this.stack.pop(), this.stack.pop()));
            } else if (Splittable.class.equals(type)) {
                this.stack.push(AutoBeanCodexImpl.splittableCoder());
            } else if (type.getEnumConstants() != null) {
                Class<?> enumType = type;
                this.stack.push(AutoBeanCodexImpl.enumCoder(enumType));
            } else if (ValueCodex.canDecode(type)) {
                this.stack.push(AutoBeanCodexImpl.valueCoder(type));
            } else {
                this.stack.push(AutoBeanCodexImpl.objectCoder(type));
            }
        }

        public Coder getCoder() {
            if (!$assertionsDisabled && this.stack.size() != 1) {
                int n = this.stack.size();
                throw new AssertionError((Object)new StringBuilder(27).append("Incorrect size: ").append(n).toString());
            }
            return this.stack.pop();
        }
    }

    public static class EncodeState {
        final EnumMap enumMap;
        final AutoBeanFactory factory;
        final StringBuilder sb;
        final Stack<AutoBean<?>> seen;

        public static EncodeState forDecode(AutoBeanFactory factory) {
            return new EncodeState(factory, null);
        }

        public static EncodeState forEncode(AutoBeanFactory factory, StringBuilder sb) {
            return new EncodeState(factory, sb);
        }

        public static EncodeState forTesting() {
            return new EncodeState(null, null);
        }

        private EncodeState(AutoBeanFactory factory, StringBuilder sb) {
            this.factory = factory;
            this.enumMap = factory instanceof EnumMap ? (EnumMap)((Object)factory) : null;
            this.sb = sb;
            this.seen = sb == null ? null : new Stack();
        }
    }

    public static interface Coder {
        public Object decode(EncodeState var1, Splittable var2);

        public void encode(EncodeState var1, Object var2);

        public Splittable extractSplittable(EncodeState var1, Object var2);
    }
}

