/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTree;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.CellTreeNodeView;
import com.google.gwt.user.cellview.client.TreeNode;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.view.client.TreeViewModel;
import java.util.ArrayList;
import java.util.HashSet;

public class CellTree
extends AbstractCellTree
implements HasAnimation,
Focusable {
    private static final int DEFAULT_LIST_SIZE = 25;
    private static Resources DEFAULT_RESOURCES;
    private static Template template;
    boolean cellIsEditing;
    boolean isFocused;
    boolean isRefreshing;
    final CellTreeNodeView<?> rootNode;
    private char accessKey = '\u0000';
    private NodeAnimation animation;
    private final SafeHtml closedImageHtml;
    private final SafeHtml closedImageTopHtml;
    private int defaultNodeSize = 25;
    private final int imageWidth;
    private boolean isAnimationEnabled;
    private CellTreeNodeView<?> keyboardSelectedNode;
    private final SafeHtml loadingImageHtml;
    private final SafeHtml openImageHtml;
    private final SafeHtml openImageTopHtml;
    private final Style style;
    private int tabIndex;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public <T> CellTree(TreeViewModel viewModel, T rootValue) {
        this(viewModel, rootValue, CellTree.getDefaultResources());
    }

    public <T> CellTree(TreeViewModel viewModel, T rootValue, Resources resources) {
        this(viewModel, rootValue, resources, (CellTreeMessages)GWT.create(CellTreeMessages.class));
    }

    public <T> CellTree(TreeViewModel viewModel, T rootValue, Resources resources, CellTreeMessages messages) {
        this(viewModel, rootValue, resources, messages, 25);
    }

    public <T> CellTree(TreeViewModel viewModel, T rootValue, Resources resources, CellTreeMessages messages, int defaultNodeSize) {
        super(viewModel);
        this.defaultNodeSize = defaultNodeSize;
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        this.style = resources.cellTreeStyle();
        this.style.ensureInjected();
        this.initWidget(new SimplePanel());
        this.setStyleName(this.style.cellTreeWidget());
        ImageResource treeOpen = resources.cellTreeOpenItem();
        ImageResource treeClosed = resources.cellTreeClosedItem();
        ImageResource treeLoading = resources.cellTreeLoading();
        this.openImageHtml = this.getImageHtml(treeOpen, false);
        this.closedImageHtml = this.getImageHtml(treeClosed, false);
        this.openImageTopHtml = this.getImageHtml(treeOpen, true);
        this.closedImageTopHtml = this.getImageHtml(treeClosed, true);
        this.loadingImageHtml = this.getImageHtml(treeLoading, false);
        this.imageWidth = Math.max(Math.max(treeOpen.getWidth(), treeClosed.getWidth()), treeLoading.getWidth());
        this.setAnimation(SlideAnimation.create());
        HashSet<String> eventTypes = new HashSet<String>();
        eventTypes.add("focus");
        eventTypes.add("blur");
        eventTypes.add("keydown");
        eventTypes.add("keyup");
        eventTypes.add("mousedown");
        eventTypes.add("click");
        CellBasedWidgetImpl.get().sinkEvents(this, eventTypes);
        CellTreeNodeView<T> root = new CellTreeNodeView<T>(this, null, null, this.getElement(), rootValue, messages);
        this.rootNode = root;
        this.keyboardSelectedNode = this.rootNode;
        root.setOpen(true, false);
        Roles.getTreeRole().set(this.getElement());
    }

    public NodeAnimation getAnimation() {
        return this.animation;
    }

    public int getDefaultNodeSize() {
        return this.defaultNodeSize;
    }

    @Override
    public TreeNode getRootTreeNode() {
        return this.rootNode.getTreeNode();
    }

    @Override
    public int getTabIndex() {
        return this.tabIndex;
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    @Override
    public void onBrowserEvent(Event event) {
        CellBasedWidgetImpl.get().onBrowserEvent(this, event);
        if (this.isRefreshing) {
            return;
        }
        super.onBrowserEvent(event);
        String eventType = event.getType();
        if ("focus".equals(eventType)) {
            this.isFocused = true;
            this.onFocus();
        } else if ("blur".equals(eventType)) {
            this.isFocused = false;
            this.onBlur();
        } else if ("keydown".equals(eventType) && !this.cellIsEditing) {
            int keyCode = event.getKeyCode();
            switch (keyCode) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.handleKeyNavigation(keyCode);
                    event.preventDefault();
                    return;
                }
                case 32: {
                    event.preventDefault();
                }
            }
        }
        Element target = (Element)event.getEventTarget().cast();
        ArrayList<Element> chain = new ArrayList<Element>();
        this.collectElementChain(chain, this.getElement(), target);
        boolean isMouseDown = "mousedown".equals(eventType);
        boolean isClick = "click".equals(eventType);
        CellTreeNodeView<?> nodeView = this.findItemByChain(chain, 0, this.rootNode);
        if (nodeView != null) {
            if (isMouseDown) {
                Element showMoreElem = nodeView.getShowMoreElement();
                if (!nodeView.isRootNode() && nodeView.getImageElement().isOrHasChild(target)) {
                    nodeView.setOpen(!nodeView.isOpen(), true);
                    return;
                }
                if (showMoreElem != null && showMoreElem.isOrHasChild(target)) {
                    nodeView.showMore();
                    return;
                }
            }
            if (nodeView != this.rootNode && nodeView.getSelectionElement().isOrHasChild(target)) {
                if (isClick) {
                    boolean isFocusable = CellBasedWidgetImpl.get().isFocusable(target);
                    this.isFocused = this.isFocused || isFocusable;
                    this.keyboardSelect(nodeView, !isFocusable);
                }
                nodeView.fireEventToCell(event);
            }
        }
    }

    @Override
    public void setAccessKey(char key) {
        this.accessKey = key;
        this.keyboardSelectedNode.setKeyboardSelected(true, false);
    }

    public void setAnimation(NodeAnimation animation) {
        assert (animation != null) : "animation cannot be null";
        this.animation = animation;
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
        if (!enable && this.animation != null) {
            this.animation.cancel();
        }
    }

    public void setDefaultNodeSize(int defaultNodeSize) {
        this.defaultNodeSize = defaultNodeSize;
    }

    @Override
    public void setFocus(boolean focused) {
        this.keyboardSelectedNode.setKeyboardSelected(true, true);
    }

    public void setKeyboardSelectedTreeNode(TreeNode parentNode, int childIndex, boolean stealFocus) {
        CellTreeNodeView nodeView = this.getCellTreeNodeView(parentNode);
        nodeView.getTreeNode().getChildValue(childIndex);
        this.keyboardSelect(nodeView.getChildNode(childIndex), stealFocus);
    }

    @Override
    public void setTabIndex(int index) {
        this.tabIndex = index;
        this.keyboardSelectedNode.setKeyboardSelected(true, false);
    }

    protected char getAccessKey() {
        return this.accessKey;
    }

    protected void onBlur() {
        this.keyboardSelectedNode.setKeyboardSelectedStyle(false);
    }

    protected void onFocus() {
        this.keyboardSelectedNode.setKeyboardSelectedStyle(true);
    }

    void cancelTreeNodeAnimation() {
        this.animation.cancel();
    }

    SafeHtml getClosedImageHtml(boolean isTop) {
        return isTop ? this.closedImageTopHtml : this.closedImageHtml;
    }

    int getImageWidth() {
        return this.imageWidth;
    }

    CellTreeNodeView<?> getKeyboardSelectedNode() {
        return this.keyboardSelectedNode;
    }

    public TreeNode getKeyboardSelectedTreeNode() {
        return this.keyboardSelectedNode == null ? null : this.keyboardSelectedNode.getTreeNode();
    }

    SafeHtml getLoadingImageHtml() {
        return this.loadingImageHtml;
    }

    SafeHtml getOpenImageHtml(boolean isTop) {
        return isTop ? this.openImageTopHtml : this.openImageHtml;
    }

    Style getStyle() {
        return this.style;
    }

    void keyboardSelect(CellTreeNodeView<?> node, boolean stealFocus) {
        if (this.isKeyboardSelectionDisabled()) {
            return;
        }
        if (this.keyboardSelectedNode != null && !this.keyboardSelectedNode.isDestroyed()) {
            this.keyboardSelectedNode.setKeyboardSelected(false, false);
        }
        this.keyboardSelectedNode = node;
        this.keyboardSelectedNode.setKeyboardSelected(true, stealFocus);
    }

    void maybeAnimateTreeNode(CellTreeNodeView<?> node) {
        if (this.animation != null) {
            this.animation.animate(node, node.consumeAnimate() && this.isAnimationEnabled() && !node.isRootNode());
        }
    }

    void resetFocus() {
        CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

            @Override
            public void execute() {
                if (CellTree.this.isFocused && !CellTree.this.keyboardSelectedNode.isDestroyed() && !CellTree.this.keyboardSelectedNode.resetFocusOnCell()) {
                    CellTree.this.keyboardSelectedNode.setKeyboardSelected(true, true);
                }
            }
        });
    }

    private void collectElementChain(ArrayList<Element> chain, Element hRoot, Element hElem) {
        if (hElem == null || hElem == hRoot) {
            return;
        }
        this.collectElementChain(chain, hRoot, hElem.getParentElement());
        chain.add(hElem);
    }

    private CellTreeNodeView getCellTreeNodeView(TreeNode treeNode) {
        if (!(treeNode instanceof CellTreeNodeView.TreeNodeImpl)) {
            String string = String.valueOf(treeNode.getClass());
            throw new UnsupportedOperationException(new StringBuilder(28 + String.valueOf(string).length()).append("Operation not supported for ").append(string).toString());
        }
        CellTreeNodeView<?> nodeView = ((CellTreeNodeView.TreeNodeImpl)treeNode).getNodeView();
        if (!nodeView.belongsToTree(this)) {
            throw new IllegalArgumentException("The tree node does not belong to the tree.");
        }
        return nodeView;
    }

    private CellTreeNodeView<?> findItemByChain(ArrayList<Element> chain, int idx, CellTreeNodeView<?> parent) {
        if (idx == chain.size()) {
            return parent;
        }
        Element hCurElem = chain.get(idx);
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            CellTreeNodeView<?> child = parent.getChildNode(i);
            if (child.getElement() != hCurElem) continue;
            CellTreeNodeView<?> retItem = this.findItemByChain(chain, idx + 1, child);
            if (retItem == null) {
                return child;
            }
            return retItem;
        }
        return this.findItemByChain(chain, idx + 1, parent);
    }

    private SafeHtml getImageHtml(ImageResource res, boolean isTop) {
        StringBuilder classesBuilder = new StringBuilder(this.style.cellTreeItemImage());
        if (isTop) {
            classesBuilder.append(" ").append(this.style.cellTreeTopItemImage());
        }
        SafeStylesBuilder cssBuilder = new SafeStylesBuilder();
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            cssBuilder.appendTrustedString("right: 0px;");
        } else {
            cssBuilder.appendTrustedString("left: 0px;");
        }
        int n = res.getWidth();
        cssBuilder.appendTrustedString(new StringBuilder(21).append("width: ").append(n).append("px;").toString());
        n = res.getHeight();
        cssBuilder.appendTrustedString(new StringBuilder(22).append("height: ").append(n).append("px;").toString());
        AbstractImagePrototype proto = AbstractImagePrototype.create(res);
        SafeHtml image = SafeHtmlUtils.fromTrustedString(proto.getHTML());
        return template.imageWrapper(classesBuilder.toString(), cssBuilder.toSafeStyles(), image);
    }

    void handleKeyNavigation(int keyCode) {
        CellTreeNodeView<?> parent = this.keyboardSelectedNode.getParentNode();
        int parentChildCount = parent == null ? 0 : parent.getChildCount();
        int index = this.keyboardSelectedNode.getIndex();
        int childCount = this.keyboardSelectedNode.getChildCount();
        boolean isRtl = LocaleInfo.getCurrentLocale().isRTL();
        keyCode = KeyCodes.maybeSwapArrowKeysForRtl(keyCode, isRtl);
        switch (keyCode) {
            case 40: {
                CellTreeNodeView<?> grandparent;
                if (this.keyboardSelectedNode.isOpen() && childCount > 0) {
                    this.keyboardSelect(this.keyboardSelectedNode.getChildNode(0), true);
                    break;
                }
                if (index < parentChildCount - 1) {
                    this.keyboardSelect(parent.getChildNode(index + 1), true);
                    break;
                }
                CellTreeNodeView<?> curParent = parent;
                CellTreeNodeView<?> nextSibling = null;
                while (curParent != null && curParent != this.rootNode && (grandparent = curParent.getParentNode()) != null) {
                    int curParentIndex = grandparent.indexOf(curParent);
                    if (curParentIndex < grandparent.getChildCount() - 1) {
                        nextSibling = grandparent.getChildNode(curParentIndex + 1);
                        break;
                    }
                    curParent = grandparent;
                }
                if (nextSibling == null) break;
                this.keyboardSelect(nextSibling, true);
                break;
            }
            case 38: {
                if (index > 0) {
                    CellTreeNodeView<?> prevSibling = parent.getChildNode(index - 1);
                    while (prevSibling.isOpen() && prevSibling.getChildCount() > 0) {
                        prevSibling = prevSibling.getChildNode(prevSibling.getChildCount() - 1);
                    }
                    this.keyboardSelect(prevSibling, true);
                    break;
                }
                if (parent == null || parent == this.rootNode) break;
                this.keyboardSelect(parent, true);
                break;
            }
            case 39: {
                this.keyboardNavigateDeep();
                break;
            }
            case 37: {
                this.keyboardNavigateShallow();
            }
        }
    }

    private void keyboardNavigateDeep() {
        if (!this.keyboardSelectedNode.isLeaf()) {
            boolean isOpen = this.keyboardSelectedNode.isOpen();
            if (isOpen && this.keyboardSelectedNode.getChildCount() > 0) {
                this.keyboardSelect(this.keyboardSelectedNode.getChildNode(0), true);
            } else if (!isOpen) {
                this.keyboardSelectedNode.setOpen(true, true);
            }
        }
    }

    private void keyboardNavigateShallow() {
        CellTreeNodeView<?> parent = this.keyboardSelectedNode.getParentNode();
        if (this.keyboardSelectedNode.isOpen()) {
            this.keyboardSelectedNode.setOpen(false, true);
        } else if (parent != null && parent != this.rootNode) {
            this.keyboardSelect(parent, true);
        }
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div class=\"{0}\" style=\"{1}position:absolute;\">{2}</div>")
        public SafeHtml imageWrapper(String var1, SafeStyles var2, SafeHtml var3);
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellTree")
    static interface BasicStyle
    extends Style {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellTreeBasic.css";
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellTree")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellTree.css";

        public String cellTreeEmptyMessage();

        public String cellTreeItem();

        public String cellTreeItemImage();

        public String cellTreeItemImageValue();

        public String cellTreeItemValue();

        public String cellTreeKeyboardSelectedItem();

        public String cellTreeOpenItem();

        public String cellTreeSelectedItem();

        public String cellTreeShowMoreButton();

        public String cellTreeTopItem();

        public String cellTreeTopItemImage();

        public String cellTreeTopItemImageValue();

        public String cellTreeWidget();
    }

    public static class SlideAnimation
    extends RevealAnimation {
        public static SlideAnimation create() {
            return new SlideAnimation();
        }

        private SlideAnimation() {
        }

        @Override
        protected void onComplete() {
            this.contentContainer.getStyle().clearPosition();
            this.contentContainer.getStyle().clearTop();
            this.contentContainer.getStyle().clearWidth();
            super.onComplete();
        }

        @Override
        protected void onStart() {
            super.onStart();
            if (this.opening) {
                this.contentContainer.getStyle().setTop(-this.height, Style.Unit.PX);
            } else {
                this.contentContainer.getStyle().setTop(0.0, Style.Unit.PX);
            }
            this.contentContainer.getStyle().setPosition(Style.Position.RELATIVE);
        }

        @Override
        protected void onUpdate(double progress) {
            super.onUpdate(progress);
            if (this.opening) {
                double curTop = (1.0 - progress) * (double)(-this.height);
                this.contentContainer.getStyle().setTop(curTop, Style.Unit.PX);
            } else {
                double curTop = progress * (double)(-this.height);
                this.contentContainer.getStyle().setTop(curTop, Style.Unit.PX);
            }
        }
    }

    public static class RevealAnimation
    extends NodeAnimation {
        Element contentContainer;
        int height;
        boolean opening;
        private Element animFrame;
        private Element childContainer;

        public static RevealAnimation create() {
            return new RevealAnimation();
        }

        private RevealAnimation() {
        }

        @Override
        protected void onComplete() {
            this.cleanup();
        }

        @Override
        protected void onStart() {
            if (this.opening) {
                this.animFrame.getStyle().setHeight(1.0, Style.Unit.PX);
                this.animFrame.getStyle().setPosition(Style.Position.RELATIVE);
                this.animFrame.getStyle().clearDisplay();
                this.height = this.contentContainer.getScrollHeight();
            } else {
                this.height = this.contentContainer.getOffsetHeight();
            }
        }

        @Override
        protected void onUpdate(double progress) {
            if (this.opening) {
                double curHeight = progress * (double)this.height;
                this.animFrame.getStyle().setHeight(curHeight, Style.Unit.PX);
            } else {
                double curHeight = (1.0 - progress) * (double)this.height;
                this.animFrame.getStyle().setHeight(curHeight, Style.Unit.PX);
            }
            this.animFrame.getStyle().setOverflow(Style.Overflow.HIDDEN);
            this.animFrame.getStyle().setPosition(Style.Position.RELATIVE);
        }

        @Override
        void animate(CellTreeNodeView<?> node, boolean isAnimationEnabled) {
            this.cancel();
            this.opening = node.isOpen();
            this.animFrame = node.ensureAnimationFrame();
            this.contentContainer = node.ensureContentContainer();
            this.childContainer = node.ensureChildContainer();
            if (isAnimationEnabled) {
                int duration = this.getDuration();
                int childCount = this.childContainer.getChildCount();
                if (childCount < 4) {
                    duration = (int)((double)childCount / 4.0 * (double)duration);
                }
                this.run(duration);
            } else {
                this.cleanup();
            }
        }

        private void cleanup() {
            if (this.opening) {
                this.animFrame.getStyle().clearDisplay();
            } else {
                this.animFrame.getStyle().setDisplay(Style.Display.NONE);
                this.childContainer.setInnerHTML("");
            }
            this.animFrame.getStyle().clearHeight();
            this.animFrame.getStyle().clearPosition();
            this.contentContainer = null;
            this.childContainer = null;
            this.animFrame = null;
        }
    }

    public static interface Resources
    extends ClientBundle {
        @ImageResource.ImageOptions(flipRtl=true)
        @ClientBundle.Source(value={"cellTreeClosedArrow.png"})
        public ImageResource cellTreeClosedItem();

        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTreeLoading();

        @ImageResource.ImageOptions(flipRtl=true)
        @ClientBundle.Source(value={"cellTreeOpenArrow.png"})
        public ImageResource cellTreeOpenItem();

        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellTreeSelectedBackground();

        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellTree.css"})
        public Style cellTreeStyle();
    }

    public static abstract class NodeAnimation
    extends Animation {
        private static final int DEFAULT_ANIMATION_DURATION = 450;
        private int duration = 450;

        NodeAnimation() {
        }

        public int getDuration() {
            return this.duration;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }

        abstract void animate(CellTreeNodeView<?> var1, boolean var2);
    }

    @LocalizableResource.DefaultLocale(value="en_US")
    public static interface CellTreeMessages
    extends Messages {
        @Messages.DefaultMessage(value="Show more")
        public String showMore();

        @Messages.DefaultMessage(value="Empty")
        public String emptyTree();
    }

    public static interface BasicResources
    extends Resources {
        @Override
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTreeClosedItem();

        @Override
        @ImageResource.ImageOptions(flipRtl=true)
        @ClientBundle.Source(value={"cellTreeLoadingBasic.gif"})
        public ImageResource cellTreeLoading();

        @Override
        @ImageResource.ImageOptions(flipRtl=true)
        public ImageResource cellTreeOpenItem();

        @Override
        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellTreeBasic.css"})
        public BasicStyle cellTreeStyle();
    }
}

