/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.builder.shared.DivBuilder;
import com.google.gwt.dom.builder.shared.ElementBuilderBase;
import com.google.gwt.dom.builder.shared.HtmlBuilderFactory;
import com.google.gwt.dom.builder.shared.HtmlTableSectionBuilder;
import com.google.gwt.dom.builder.shared.StylesBuilder;
import com.google.gwt.dom.builder.shared.TableRowBuilder;
import com.google.gwt.dom.builder.shared.TableSectionBuilder;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.FooterBuilder;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.HeaderBuilder;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractHeaderOrFooterBuilder<T>
implements HeaderBuilder<T>,
FooterBuilder<T> {
    private static final String COLUMN_ATTRIBUTE = "__gwt_column";
    private static final String HEADER_ATTRIBUTE = "__gwt_header";
    private static final String ROW_ATTRIBUTE = "__gwt_header_row";
    private static final int ICON_PADDING = 6;
    private final boolean isFooter;
    private boolean isSortIconStartOfLine = true;
    private final int sortAscIconHalfHeight;
    private SafeHtml sortAscIconHtml;
    private final int sortAscIconWidth;
    private final int sortDescIconHalfHeight;
    private SafeHtml sortDescIconHtml;
    private final int sortDescIconWidth;
    private final AbstractCellTable<T> table;
    private int rowIndex;
    private HtmlTableSectionBuilder section;
    private final Map<String, Column<T, ?>> idToColumnMap = new HashMap();
    private final TwoWayHashMap<String, Header<?>> idToHeaderMap = new TwoWayHashMap();

    public AbstractHeaderOrFooterBuilder(AbstractCellTable<T> table, boolean isFooter) {
        this.isFooter = isFooter;
        this.table = table;
        ImageResource asc = table.getResources().sortAscending();
        ImageResource desc = table.getResources().sortDescending();
        if (asc != null) {
            this.sortAscIconWidth = asc.getWidth() + 6;
            this.sortAscIconHalfHeight = (int)Math.round((double)asc.getHeight() / 2.0);
        } else {
            this.sortAscIconWidth = 0;
            this.sortAscIconHalfHeight = 0;
        }
        if (desc != null) {
            this.sortDescIconWidth = desc.getWidth() + 6;
            this.sortDescIconHalfHeight = (int)Math.round((double)desc.getHeight() / 2.0);
        } else {
            this.sortDescIconWidth = 0;
            this.sortDescIconHalfHeight = 0;
        }
    }

    @Override
    public final TableSectionBuilder buildFooter() {
        if (!this.isFooter) {
            throw new UnsupportedOperationException("Cannot build footer because this builder is designated to build a header");
        }
        return this.buildHeaderOrFooter();
    }

    @Override
    public final TableSectionBuilder buildHeader() {
        if (this.isFooter) {
            throw new UnsupportedOperationException("Cannot build header because this builder is designated to build a footer");
        }
        return this.buildHeaderOrFooter();
    }

    @Override
    public Column<T, ?> getColumn(Element elem) {
        String cellId = this.getColumnId(elem);
        return cellId == null ? null : this.idToColumnMap.get(cellId);
    }

    @Override
    public Header<?> getHeader(Element elem) {
        String headerId = this.getHeaderId(elem);
        return headerId == null ? null : this.idToHeaderMap.getValue(headerId);
    }

    @Override
    public int getRowIndex(TableRowElement row) {
        return Integer.parseInt(row.getAttribute(ROW_ATTRIBUTE));
    }

    public boolean isBuildingFooter() {
        return this.isFooter;
    }

    @Override
    public boolean isColumn(Element elem) {
        return this.getColumnId(elem) != null;
    }

    @Override
    public boolean isHeader(Element elem) {
        return this.getHeaderId(elem) != null;
    }

    public boolean isSortIconStartOfLine() {
        return this.isSortIconStartOfLine;
    }

    public void setSortIconStartOfLine(boolean isStartOfLine) {
        this.isSortIconStartOfLine = isStartOfLine;
    }

    protected abstract boolean buildHeaderOrFooterImpl();

    protected final void enableColumnHandlers(ElementBuilderBase<?> builder, Column<T, ?> column) {
        String columnId = "column-" + Document.get().createUniqueId();
        this.idToColumnMap.put(columnId, column);
        builder.attribute(COLUMN_ATTRIBUTE, columnId);
    }

    protected final Header<?> getHeader(int index) {
        return this.isFooter ? this.getTable().getFooter(index) : this.getTable().getHeader(index);
    }

    protected AbstractCellTable<T> getTable() {
        return this.table;
    }

    protected final <H> void renderHeader(ElementBuilderBase<?> out, Cell.Context context, Header<H> header) {
        String headerId = this.idToHeaderMap.getKey(header);
        if (headerId == null) {
            headerId = "header-" + Document.get().createUniqueId();
            this.idToHeaderMap.put(headerId, header);
        }
        out.attribute(HEADER_ATTRIBUTE, headerId);
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        header.render(context, sb);
        out.html(sb.toSafeHtml());
    }

    protected final void renderSortableHeader(ElementBuilderBase<?> out, Cell.Context context, Header<?> header, boolean isSorted, boolean isSortAscending) {
        DivBuilder headerContainer = out;
        boolean bl = isSorted = isSorted && !this.isFooter;
        if (isSorted) {
            boolean posRight = LocaleInfo.getCurrentLocale().isRTL() ? this.isSortIconStartOfLine : !this.isSortIconStartOfLine;
            int iconWidth = isSortAscending ? this.sortAscIconWidth : this.sortDescIconWidth;
            int halfHeight = isSortAscending ? this.sortAscIconHalfHeight : this.sortDescIconHalfHeight;
            DivBuilder outerDiv = out.startDiv();
            StylesBuilder style = outerDiv.style().position(Style.Position.RELATIVE).trustedProperty("zoom", "1");
            if (posRight) {
                style.paddingRight(iconWidth, Style.Unit.PX);
            } else {
                style.paddingLeft(iconWidth, Style.Unit.PX);
            }
            style.endStyle();
            DivBuilder imageHolder = outerDiv.startDiv();
            style = outerDiv.style().position(Style.Position.ABSOLUTE).top(50.0, Style.Unit.PCT).lineHeight(0.0, Style.Unit.PX).marginTop(-halfHeight, Style.Unit.PX);
            if (posRight) {
                style.right(0.0, Style.Unit.PX);
            } else {
                style.left(0.0, Style.Unit.PX);
            }
            style.endStyle();
            imageHolder.html(this.getSortIcon(isSortAscending));
            imageHolder.endDiv();
            headerContainer = outerDiv.startDiv();
        }
        this.renderHeader(headerContainer, context, header);
        if (isSorted) {
            headerContainer.endDiv();
            headerContainer.endDiv();
        }
    }

    protected final TableRowBuilder startRow() {
        while (this.section.getDepth() > 1) {
            this.section.end();
        }
        if (this.section.getDepth() < 1) {
            throw new IllegalStateException("Cannot start a row.  Did you call TableRowBuilder.end() too many times?");
        }
        TableRowBuilder row = this.section.startTR();
        row.attribute(ROW_ATTRIBUTE, this.rowIndex);
        ++this.rowIndex;
        return row;
    }

    private TableSectionBuilder buildHeaderOrFooter() {
        this.section = this.isFooter ? HtmlBuilderFactory.get().createTFootBuilder() : HtmlBuilderFactory.get().createTHeadBuilder();
        this.idToHeaderMap.clear();
        this.idToColumnMap.clear();
        this.rowIndex = 0;
        if (!this.buildHeaderOrFooterImpl()) {
            return null;
        }
        while (this.section.getDepth() > 0) {
            this.section.end();
        }
        return this.section;
    }

    private String getColumnId(Element elem) {
        return this.getElementAttribute(elem, COLUMN_ATTRIBUTE);
    }

    private String getElementAttribute(Element elem, String attribute) {
        if (elem == null) {
            return null;
        }
        String value = elem.getAttribute(attribute);
        return value == null || value.length() == 0 ? null : value;
    }

    private String getHeaderId(Element elem) {
        return this.getElementAttribute(elem, HEADER_ATTRIBUTE);
    }

    private SafeHtml getSortIcon(boolean isAscending) {
        if (isAscending) {
            if (this.sortAscIconHtml == null) {
                AbstractImagePrototype proto = AbstractImagePrototype.create(this.table.getResources().sortAscending());
                this.sortAscIconHtml = SafeHtmlUtils.fromTrustedString(proto.getHTML());
            }
            return this.sortAscIconHtml;
        }
        if (this.sortDescIconHtml == null) {
            AbstractImagePrototype proto = AbstractImagePrototype.create(this.table.getResources().sortDescending());
            this.sortDescIconHtml = SafeHtmlUtils.fromTrustedString(proto.getHTML());
        }
        return this.sortDescIconHtml;
    }

    private static class TwoWayHashMap<K, V> {
        private final Map<K, V> keyToValue = new HashMap();
        private final Map<V, K> valueToKey = new HashMap<V, K>();

        private TwoWayHashMap() {
        }

        void clear() {
            this.keyToValue.clear();
            this.valueToKey.clear();
        }

        K getKey(V value) {
            return this.valueToKey.get(value);
        }

        V getValue(K key) {
            return this.keyToValue.get(key);
        }

        void put(K key, V value) {
            this.keyToValue.put(key, value);
            this.valueToKey.put(value, key);
        }
    }
}

