/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ms" locale.
 */
public class DateTimeFormatInfoImpl_ms extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE dd MMM y";
  }

  @Override
  public String dateFormatLong() {
    return "dd MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "dd MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "dd/MM/yyyy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "S.M.",
        "T.M."
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "S.M.",
        "T.M."
    };
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d-M";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M-y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "Januari",
        "Februari",
        "Mac",
        "April",
        "Mei",
        "Jun",
        "Julai",
        "Ogos",
        "September",
        "Oktober",
        "November",
        "Disember"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "Jan",
        "Feb",
        "Mac",
        "Apr",
        "Mei",
        "Jun",
        "Jul",
        "Ogos",
        "Sep",
        "Okt",
        "Nov",
        "Dis"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "suku pertama",
        "suku kedua",
        "suku ketiga",
        "suku keempat"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "S1",
        "S2",
        "S3",
        "S4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "Ahad",
        "Isnin",
        "Selasa",
        "Rabu",
        "Khamis",
        "Jumaat",
        "Sabtu"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "Ahd",
        "Isn",
        "Sel",
        "Rab",
        "Kha",
        "Jum",
        "Sab"
    };
  }
}
