/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.sym;

import com.sun.tools.javac.Main;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.sym.Profiles;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

@SupportedOptions(value={"com.sun.tools.javac.sym.Jar", "com.sun.tools.javac.sym.Dest", "com.sun.tools.javac.sym.Profiles"})
@SupportedAnnotationTypes(value={"*"})
public class CreateSymbols
extends AbstractProcessor {
    static Set<String> getLegacyPackages() {
        ResourceBundle legacyBundle = ResourceBundle.getBundle("com.sun.tools.javac.resources.legacy");
        HashSet<String> keys = new HashSet<String>();
        Enumeration<String> e = legacyBundle.getKeys();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        return keys;
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment renv) {
        try {
            if (renv.processingOver()) {
                this.createSymbols();
            }
        }
        catch (IOException e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = e.toString();
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
        catch (Throwable t) {
            String msg;
            t.printStackTrace();
            Throwable cause = t.getCause();
            if (cause == null) {
                cause = t;
            }
            if ((msg = cause.getLocalizedMessage()) == null) {
                msg = cause.toString();
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
        return true;
    }

    void createSymbols() throws IOException {
        Set<String> legacy2 = CreateSymbols.getLegacyPackages();
        Set<String> legacyProprietary = CreateSymbols.getLegacyPackages();
        HashSet<String> documented = new HashSet<String>();
        Set<Symbol.PackageSymbol> packages = ((JavacProcessingEnvironment)this.processingEnv).getSpecifiedPackages();
        Map<String, String> pOptions = this.processingEnv.getOptions();
        String jarName = pOptions.get("com.sun.tools.javac.sym.Jar");
        if (jarName == null) {
            throw new RuntimeException("Must use -Acom.sun.tools.javac.sym.Jar=LOCATION_OF_JAR");
        }
        String destName = pOptions.get("com.sun.tools.javac.sym.Dest");
        if (destName == null) {
            throw new RuntimeException("Must use -Acom.sun.tools.javac.sym.Dest=LOCATION_OF_JAR");
        }
        String profileSpec = pOptions.get("com.sun.tools.javac.sym.Profiles");
        if (profileSpec == null) {
            throw new RuntimeException("Must use -Acom.sun.tools.javac.sym.Profiles=PROFILES_SPEC");
        }
        Profiles profiles = Profiles.read(new File(profileSpec));
        for (Symbol.PackageSymbol psym : packages) {
            String name = psym.getQualifiedName().toString();
            legacyProprietary.remove(name);
            documented.add(name);
        }
        JavaCompiler tool = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fm = tool.getStandardFileManager(null, null, null);
        JavaFileManager.Location jarLocation = StandardLocation.locationFor(jarName);
        File jarFile = new File(jarName);
        fm.setLocation(jarLocation, List.of(jarFile));
        fm.setLocation(StandardLocation.CLASS_PATH, List.nil());
        fm.setLocation(StandardLocation.SOURCE_PATH, List.nil());
        ArrayList<File> bootClassPath = new ArrayList<File>();
        bootClassPath.add(jarFile);
        for (File file : fm.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) {
            if (new File(file.getName()).equals(new File("rt.jar"))) continue;
            bootClassPath.add(file);
        }
        Object i$ = String.valueOf(String.valueOf(bootClassPath));
        System.err.println(new StringBuilder(24 + ((String)i$).length()).append("Using boot class path = ").append((String)i$).toString());
        fm.setLocation(StandardLocation.PLATFORM_CLASS_PATH, bootClassPath);
        File destDir = new File(destName);
        if (!destDir.exists() && !destDir.mkdirs()) {
            i$ = String.valueOf(String.valueOf(destDir));
            throw new RuntimeException(new StringBuilder(17 + ((String)i$).length()).append("Could not create ").append((String)i$).toString());
        }
        fm.setLocation(StandardLocation.CLASS_OUTPUT, List.of(destDir));
        HashSet<String> hiddenPackages = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        List<String> options = List.of("-XDdev");
        JavacTaskImpl task = (JavacTaskImpl)tool.getTask(null, fm, null, options, null, null);
        com.sun.tools.javac.main.JavaCompiler compiler2 = com.sun.tools.javac.main.JavaCompiler.instance(task.getContext());
        ClassWriter writer = ClassWriter.instance(task.getContext());
        Symtab syms = Symtab.instance(task.getContext());
        Names names = Names.instance(task.getContext());
        Attribute.Compound proprietaryAnno = new Attribute.Compound(syms.proprietaryType, List.nil());
        Attribute.Compound[] profileAnnos = new Attribute.Compound[profiles.getProfileCount() + 1];
        Symbol.MethodSymbol profileValue = (Symbol.MethodSymbol)syms.profileType.tsym.members().findFirst(names.value);
        for (int i = 1; i < profileAnnos.length; ++i) {
            profileAnnos[i] = new Attribute.Compound(syms.profileType, List.of(new Pair<Symbol.MethodSymbol, Attribute.Constant>(profileValue, new Attribute.Constant(syms.intType, i))));
        }
        Type.moreInfo = true;
        Types types = Types.instance(task.getContext());
        Pool pool = new Pool(types);
        for (JavaFileObject file : fm.list(jarLocation, "", EnumSet.of(JavaFileObject.Kind.CLASS), true)) {
            int p;
            String string;
            String className = fm.inferBinaryName(jarLocation, file);
            int index = className.lastIndexOf(46);
            String pckName = index == -1 ? "" : className.substring(0, index);
            boolean addLegacyAnnotation = false;
            if (documented.contains(pckName)) {
                if (!legacy2.contains(pckName)) {
                    hashSet.add(pckName);
                }
            } else if (legacyProprietary.contains(pckName)) {
                addLegacyAnnotation = true;
            } else {
                hiddenPackages.add(pckName);
                continue;
            }
            Symbol.TypeSymbol sym = (Symbol.TypeSymbol)compiler2.resolveIdent(className);
            if (sym.kind != 2) {
                if (className.indexOf(36) >= 0) continue;
                string = String.valueOf(String.valueOf(className));
                String string2 = String.valueOf(String.valueOf(sym));
                System.err.println(new StringBuilder(20 + string.length() + string2.length()).append("Ignoring (other) ").append(string).append(" : ").append(string2).toString());
                String string3 = String.valueOf(String.valueOf(sym.getClass().getSimpleName()));
                String string4 = String.valueOf(String.valueOf(sym.type));
                System.err.println(new StringBuilder(4 + string3.length() + string4.length()).append("   ").append(string3).append(" ").append(string4).toString());
                continue;
            }
            sym.complete();
            if (((Symbol)sym.getEnclosingElement()).getKind() != ElementKind.PACKAGE) {
                string = String.valueOf(String.valueOf(sym.getQualifiedName()));
                System.err.println(new StringBuilder(15 + string.length()).append("Ignoring (bad) ").append(string).toString());
                continue;
            }
            Symbol.ClassSymbol cs = (Symbol.ClassSymbol)sym;
            if (addLegacyAnnotation) {
                cs.prependAttributes(List.of(proprietaryAnno));
            }
            if (0 < (p = profiles.getProfile(cs.fullname.toString().replace(".", "/"))) && p < profileAnnos.length) {
                cs.prependAttributes(List.of(profileAnnos[p]));
            }
            this.writeClass(pool, cs, writer);
        }
    }

    void writeClass(Pool pool, Symbol.ClassSymbol cs, ClassWriter writer) throws IOException {
        try {
            pool.reset();
            cs.pool = pool;
            writer.writeClass(cs);
            for (Symbol sym : cs.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (sym.kind != 2) continue;
                Symbol.ClassSymbol nestedClass = (Symbol.ClassSymbol)sym;
                nestedClass.complete();
                this.writeClass(pool, nestedClass, writer);
            }
        }
        catch (ClassWriter.PoolOverflow | ClassWriter.StringOverflow ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public static void main(String ... args) {
        String rt_jar = args[0];
        String dest = args[1];
        String[] stringArray = new String[228];
        String string = String.valueOf(rt_jar);
        stringArray[0] = string.length() != 0 ? "-Xbootclasspath:".concat(string) : new String("-Xbootclasspath:");
        stringArray[1] = "-XDprocess.packages";
        stringArray[2] = "-proc:only";
        stringArray[3] = "-processor";
        stringArray[4] = "com.sun.tools.javac.sym.CreateSymbols";
        String string2 = String.valueOf(rt_jar);
        stringArray[5] = string2.length() != 0 ? "-Acom.sun.tools.javac.sym.Jar=".concat(string2) : new String("-Acom.sun.tools.javac.sym.Jar=");
        String string3 = String.valueOf(dest);
        stringArray[6] = string3.length() != 0 ? "-Acom.sun.tools.javac.sym.Dest=".concat(string3) : new String("-Acom.sun.tools.javac.sym.Dest=");
        stringArray[7] = "java.applet";
        stringArray[8] = "java.awt";
        stringArray[9] = "java.awt.color";
        stringArray[10] = "java.awt.datatransfer";
        stringArray[11] = "java.awt.dnd";
        stringArray[12] = "java.awt.event";
        stringArray[13] = "java.awt.font";
        stringArray[14] = "java.awt.geom";
        stringArray[15] = "java.awt.im";
        stringArray[16] = "java.awt.im.spi";
        stringArray[17] = "java.awt.image";
        stringArray[18] = "java.awt.image.renderable";
        stringArray[19] = "java.awt.print";
        stringArray[20] = "java.beans";
        stringArray[21] = "java.beans.beancontext";
        stringArray[22] = "java.io";
        stringArray[23] = "java.lang";
        stringArray[24] = "java.lang.annotation";
        stringArray[25] = "java.lang.instrument";
        stringArray[26] = "java.lang.management";
        stringArray[27] = "java.lang.ref";
        stringArray[28] = "java.lang.reflect";
        stringArray[29] = "java.math";
        stringArray[30] = "java.net";
        stringArray[31] = "java.nio";
        stringArray[32] = "java.nio.channels";
        stringArray[33] = "java.nio.channels.spi";
        stringArray[34] = "java.nio.charset";
        stringArray[35] = "java.nio.charset.spi";
        stringArray[36] = "java.rmi";
        stringArray[37] = "java.rmi.activation";
        stringArray[38] = "java.rmi.dgc";
        stringArray[39] = "java.rmi.registry";
        stringArray[40] = "java.rmi.server";
        stringArray[41] = "java.security";
        stringArray[42] = "java.security.acl";
        stringArray[43] = "java.security.cert";
        stringArray[44] = "java.security.interfaces";
        stringArray[45] = "java.security.spec";
        stringArray[46] = "java.sql";
        stringArray[47] = "java.text";
        stringArray[48] = "java.text.spi";
        stringArray[49] = "java.util";
        stringArray[50] = "java.util.concurrent";
        stringArray[51] = "java.util.concurrent.atomic";
        stringArray[52] = "java.util.concurrent.locks";
        stringArray[53] = "java.util.jar";
        stringArray[54] = "java.util.logging";
        stringArray[55] = "java.util.prefs";
        stringArray[56] = "java.util.regex";
        stringArray[57] = "java.util.spi";
        stringArray[58] = "java.util.zip";
        stringArray[59] = "javax.accessibility";
        stringArray[60] = "javax.activation";
        stringArray[61] = "javax.activity";
        stringArray[62] = "javax.annotation";
        stringArray[63] = "javax.annotation.processing";
        stringArray[64] = "javax.crypto";
        stringArray[65] = "javax.crypto.interfaces";
        stringArray[66] = "javax.crypto.spec";
        stringArray[67] = "javax.imageio";
        stringArray[68] = "javax.imageio.event";
        stringArray[69] = "javax.imageio.metadata";
        stringArray[70] = "javax.imageio.plugins.jpeg";
        stringArray[71] = "javax.imageio.plugins.bmp";
        stringArray[72] = "javax.imageio.spi";
        stringArray[73] = "javax.imageio.stream";
        stringArray[74] = "javax.jws";
        stringArray[75] = "javax.jws.soap";
        stringArray[76] = "javax.lang.model";
        stringArray[77] = "javax.lang.model.element";
        stringArray[78] = "javax.lang.model.type";
        stringArray[79] = "javax.lang.model.util";
        stringArray[80] = "javax.management";
        stringArray[81] = "javax.management.loading";
        stringArray[82] = "javax.management.monitor";
        stringArray[83] = "javax.management.relation";
        stringArray[84] = "javax.management.openmbean";
        stringArray[85] = "javax.management.timer";
        stringArray[86] = "javax.management.modelmbean";
        stringArray[87] = "javax.management.remote";
        stringArray[88] = "javax.management.remote.rmi";
        stringArray[89] = "javax.naming";
        stringArray[90] = "javax.naming.directory";
        stringArray[91] = "javax.naming.event";
        stringArray[92] = "javax.naming.ldap";
        stringArray[93] = "javax.naming.spi";
        stringArray[94] = "javax.net";
        stringArray[95] = "javax.net.ssl";
        stringArray[96] = "javax.print";
        stringArray[97] = "javax.print.attribute";
        stringArray[98] = "javax.print.attribute.standard";
        stringArray[99] = "javax.print.event";
        stringArray[100] = "javax.rmi";
        stringArray[101] = "javax.rmi.CORBA";
        stringArray[102] = "javax.rmi.ssl";
        stringArray[103] = "javax.script";
        stringArray[104] = "javax.security.auth";
        stringArray[105] = "javax.security.auth.callback";
        stringArray[106] = "javax.security.auth.kerberos";
        stringArray[107] = "javax.security.auth.login";
        stringArray[108] = "javax.security.auth.spi";
        stringArray[109] = "javax.security.auth.x500";
        stringArray[110] = "javax.security.cert";
        stringArray[111] = "javax.security.sasl";
        stringArray[112] = "javax.sound.sampled";
        stringArray[113] = "javax.sound.sampled.spi";
        stringArray[114] = "javax.sound.midi";
        stringArray[115] = "javax.sound.midi.spi";
        stringArray[116] = "javax.sql";
        stringArray[117] = "javax.sql.rowset";
        stringArray[118] = "javax.sql.rowset.serial";
        stringArray[119] = "javax.sql.rowset.spi";
        stringArray[120] = "javax.swing";
        stringArray[121] = "javax.swing.border";
        stringArray[122] = "javax.swing.colorchooser";
        stringArray[123] = "javax.swing.filechooser";
        stringArray[124] = "javax.swing.event";
        stringArray[125] = "javax.swing.table";
        stringArray[126] = "javax.swing.text";
        stringArray[127] = "javax.swing.text.html";
        stringArray[128] = "javax.swing.text.html.parser";
        stringArray[129] = "javax.swing.text.rtf";
        stringArray[130] = "javax.swing.tree";
        stringArray[131] = "javax.swing.undo";
        stringArray[132] = "javax.swing.plaf";
        stringArray[133] = "javax.swing.plaf.basic";
        stringArray[134] = "javax.swing.plaf.metal";
        stringArray[135] = "javax.swing.plaf.multi";
        stringArray[136] = "javax.swing.plaf.synth";
        stringArray[137] = "javax.tools";
        stringArray[138] = "javax.transaction";
        stringArray[139] = "javax.transaction.xa";
        stringArray[140] = "javax.xml.parsers";
        stringArray[141] = "javax.xml.bind";
        stringArray[142] = "javax.xml.bind.annotation";
        stringArray[143] = "javax.xml.bind.annotation.adapters";
        stringArray[144] = "javax.xml.bind.attachment";
        stringArray[145] = "javax.xml.bind.helpers";
        stringArray[146] = "javax.xml.bind.util";
        stringArray[147] = "javax.xml.soap";
        stringArray[148] = "javax.xml.ws";
        stringArray[149] = "javax.xml.ws.handler";
        stringArray[150] = "javax.xml.ws.handler.soap";
        stringArray[151] = "javax.xml.ws.http";
        stringArray[152] = "javax.xml.ws.soap";
        stringArray[153] = "javax.xml.ws.spi";
        stringArray[154] = "javax.xml.transform";
        stringArray[155] = "javax.xml.transform.sax";
        stringArray[156] = "javax.xml.transform.dom";
        stringArray[157] = "javax.xml.transform.stax";
        stringArray[158] = "javax.xml.transform.stream";
        stringArray[159] = "javax.xml";
        stringArray[160] = "javax.xml.crypto";
        stringArray[161] = "javax.xml.crypto.dom";
        stringArray[162] = "javax.xml.crypto.dsig";
        stringArray[163] = "javax.xml.crypto.dsig.dom";
        stringArray[164] = "javax.xml.crypto.dsig.keyinfo";
        stringArray[165] = "javax.xml.crypto.dsig.spec";
        stringArray[166] = "javax.xml.datatype";
        stringArray[167] = "javax.xml.validation";
        stringArray[168] = "javax.xml.namespace";
        stringArray[169] = "javax.xml.xpath";
        stringArray[170] = "javax.xml.stream";
        stringArray[171] = "javax.xml.stream.events";
        stringArray[172] = "javax.xml.stream.util";
        stringArray[173] = "org.ietf.jgss";
        stringArray[174] = "org.omg.CORBA";
        stringArray[175] = "org.omg.CORBA.DynAnyPackage";
        stringArray[176] = "org.omg.CORBA.ORBPackage";
        stringArray[177] = "org.omg.CORBA.TypeCodePackage";
        stringArray[178] = "org.omg.stub.java.rmi";
        stringArray[179] = "org.omg.CORBA.portable";
        stringArray[180] = "org.omg.CORBA_2_3";
        stringArray[181] = "org.omg.CORBA_2_3.portable";
        stringArray[182] = "org.omg.CosNaming";
        stringArray[183] = "org.omg.CosNaming.NamingContextExtPackage";
        stringArray[184] = "org.omg.CosNaming.NamingContextPackage";
        stringArray[185] = "org.omg.SendingContext";
        stringArray[186] = "org.omg.PortableServer";
        stringArray[187] = "org.omg.PortableServer.CurrentPackage";
        stringArray[188] = "org.omg.PortableServer.POAPackage";
        stringArray[189] = "org.omg.PortableServer.POAManagerPackage";
        stringArray[190] = "org.omg.PortableServer.ServantLocatorPackage";
        stringArray[191] = "org.omg.PortableServer.portable";
        stringArray[192] = "org.omg.PortableInterceptor";
        stringArray[193] = "org.omg.PortableInterceptor.ORBInitInfoPackage";
        stringArray[194] = "org.omg.Messaging";
        stringArray[195] = "org.omg.IOP";
        stringArray[196] = "org.omg.IOP.CodecFactoryPackage";
        stringArray[197] = "org.omg.IOP.CodecPackage";
        stringArray[198] = "org.omg.Dynamic";
        stringArray[199] = "org.omg.DynamicAny";
        stringArray[200] = "org.omg.DynamicAny.DynAnyPackage";
        stringArray[201] = "org.omg.DynamicAny.DynAnyFactoryPackage";
        stringArray[202] = "org.w3c.dom";
        stringArray[203] = "org.w3c.dom.events";
        stringArray[204] = "org.w3c.dom.bootstrap";
        stringArray[205] = "org.w3c.dom.ls";
        stringArray[206] = "org.xml.sax";
        stringArray[207] = "org.xml.sax.ext";
        stringArray[208] = "org.xml.sax.helpers";
        stringArray[209] = "org.w3c.dom";
        stringArray[210] = "org.w3c.dom.bootstrap";
        stringArray[211] = "org.w3c.dom.ls";
        stringArray[212] = "org.w3c.dom.ranges";
        stringArray[213] = "org.w3c.dom.traversal";
        stringArray[214] = "org.w3c.dom.html";
        stringArray[215] = "org.w3c.dom.stylesheets";
        stringArray[216] = "org.w3c.dom.css";
        stringArray[217] = "org.w3c.dom.events";
        stringArray[218] = "org.w3c.dom.views";
        stringArray[219] = "com.sun.management";
        stringArray[220] = "com.sun.security.auth";
        stringArray[221] = "com.sun.security.auth.callback";
        stringArray[222] = "com.sun.security.auth.login";
        stringArray[223] = "com.sun.security.auth.module";
        stringArray[224] = "com.sun.security.jgss";
        stringArray[225] = "com.sun.net.httpserver";
        stringArray[226] = "com.sun.net.httpserver.spi";
        stringArray[227] = "javax.smartcardio";
        args = stringArray;
        Main.compile(args);
    }
}

