/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.logging;

import com.google.cloud.logging.logback.LoggingAppender;
import com.google.cloud.spring.autoconfigure.trace.StackdriverTraceAutoConfiguration;
import com.google.cloud.spring.logging.LoggingWebMvcConfigurer;
import com.google.cloud.spring.logging.TraceIdLoggingWebMvcInterceptor;
import com.google.cloud.spring.logging.extractors.CloudTraceIdExtractor;
import com.google.cloud.spring.logging.extractors.TraceIdExtractor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.HandlerInterceptor;

@AutoConfiguration
@ConditionalOnClass(value={HandlerInterceptor.class, LoggingAppender.class, TraceIdExtractor.class})
@ConditionalOnMissingBean(name={"stackdriverTracingCustomizer"})
@AutoConfigureAfter(value={StackdriverTraceAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(value={"spring.cloud.gcp.logging.enabled"}, matchIfMissing=true)
@Import(value={LoggingWebMvcConfigurer.class})
public class StackdriverLoggingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TraceIdLoggingWebMvcInterceptor loggingWebMvcInterceptor(TraceIdExtractor extractor) {
        return new TraceIdLoggingWebMvcInterceptor(extractor);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceIdExtractor traceIdExtractor() {
        return new CloudTraceIdExtractor();
    }
}

