/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.ServerConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerConnection
implements ServerConnection {
    private static final int MAX_SEND_TRIES = 3;
    protected static final String POST = "POST";
    protected static final String GET = "GET";
    protected AppAdminFactory.ConnectOptions options;
    protected static Logger logger = Logger.getLogger(AbstractServerConnection.class.getCanonicalName());

    protected AbstractServerConnection() {
    }

    protected AbstractServerConnection(AppAdminFactory.ConnectOptions options) {
        this.options = options;
        if (System.getProperty("http.proxyHost") != null) {
            logger.info("proxying HTTP through " + System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort"));
        }
        if (System.getProperty("https.proxyHost") != null) {
            logger.info("proxying HTTPS through " + System.getProperty("https.proxyHost") + ":" + System.getProperty("https.proxyPort"));
        }
    }

    protected String buildQuery(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        for (String key : params.keySet()) {
            buf.append(URLEncoder.encode(key, "UTF-8"));
            buf.append('=');
            buf.append(URLEncoder.encode(params.get(key), "UTF-8"));
            buf.append('&');
        }
        return buf.toString();
    }

    protected URL buildURL(String path) throws MalformedURLException {
        String protocol = this.options.getSecure() ? "https" : "http";
        return new URL(protocol + "://" + this.options.getServer() + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IOException connect(String method, HttpURLConnection conn, DataPoster data) throws IOException {
        this.doPreConnect(method, conn, data);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod(method);
        if (POST.equals(method)) {
            conn.setDoOutput(true);
            OutputStream out = conn.getOutputStream();
            if (data != null) {
                data.post(out);
            }
            out.close();
        }
        try {
            conn.getInputStream();
        }
        catch (IOException ex) {
            IOException iOException = ex;
            return iOException;
        }
        finally {
            this.doPostConnect(method, conn, data);
        }
        return null;
    }

    protected String constructHttpErrorMessage(HttpURLConnection conn, BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder("Error posting to URL: ");
        sb.append(conn.getURL());
        sb.append('\n');
        sb.append(conn.getResponseCode());
        sb.append(' ');
        sb.append(conn.getResponseMessage());
        sb.append('\n');
        if (reader != null) {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    protected abstract void doHandleSendErrors(int var1, URL var2, HttpURLConnection var3, BufferedReader var4) throws IOException;

    protected abstract void doPostConnect(String var1, HttpURLConnection var2, DataPoster var3) throws IOException;

    protected abstract void doPreConnect(String var1, HttpURLConnection var2, DataPoster var3) throws IOException;

    @Override
    public String get(String url, Map<String, String> params) throws IOException {
        return this.send(GET, url, null, null, params);
    }

    private InputStream getInputStream(HttpURLConnection conn) {
        try {
            return conn.getInputStream();
        }
        catch (IOException ex) {
            return conn.getErrorStream();
        }
    }

    private BufferedReader getReader(InputStream is) {
        if (is == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    protected BufferedReader getReader(HttpURLConnection conn) {
        return this.getReader(this.getInputStream(conn));
    }

    @Override
    public String post(String url, File payload, String contentType, Map<String, String> params) throws IOException {
        return this.send(POST, url, new FilePoster(payload), contentType, params);
    }

    @Override
    public String post(String url, File payload, String contentType, String ... params) throws IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            paramMap.put(params[i], params[i + 1]);
        }
        return this.send(POST, url, new FilePoster(payload), contentType, paramMap);
    }

    @Override
    public String post(String url, String payload, Map<String, String> params) throws IOException {
        return this.send(POST, url, new StringPoster(payload), null, params);
    }

    @Override
    public String post(String url, String payload, String ... params) throws IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            paramMap.put(params[i], params[i + 1]);
        }
        return this.send(POST, url, new StringPoster(payload), null, paramMap);
    }

    @Override
    public InputStream postAndGetInputStream(String url, String payload, String ... params) throws IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            paramMap.put(params[i], params[i + 1]);
        }
        return this.send1(POST, url, new StringPoster(payload), null, paramMap);
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    protected String send(String method, String path, DataPoster payload, String content_type, Map<String, String> params) throws IOException {
        BufferedReader reader = this.getReader(this.send1(method, path, payload, content_type, params));
        StringBuffer response = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            response.append(line);
            response.append("\n");
        }
        return response.toString();
    }

    private InputStream send1(String method, String path, DataPoster payload, String content_type, Map<String, String> params) throws IOException {
        URL url = this.buildURL(path + '?' + this.buildQuery(params));
        if (content_type == null) {
            content_type = "application/octet-stream";
        }
        int tries = 0;
        while (true) {
            HttpURLConnection conn = this.openConnection(url);
            conn.setRequestProperty("Content-type", content_type);
            conn.setRequestProperty("X-appcfg-api-version", "1");
            if (this.options.getHost() != null) {
                conn.setRequestProperty("Host", this.options.getHost());
            }
            IOException ioe = this.connect(method, conn, payload);
            int status = conn.getResponseCode();
            if (status == 200) {
                return this.getInputStream(conn);
            }
            BufferedReader reader = this.getReader(conn);
            logger.finer("Got http error " + status + ". this is try #" + tries);
            if (++tries > 3) {
                throw new IOException(this.constructHttpErrorMessage(conn, reader));
            }
            this.doHandleSendErrors(status, url, conn, reader);
        }
    }

    static class StringPoster
    implements DataPoster {
        private String str;

        public StringPoster(String s) {
            this.str = s;
        }

        public void post(OutputStream s) throws IOException {
            s.write(this.str.getBytes("UTF-8"));
        }
    }

    private static class FilePoster
    implements DataPoster {
        private static final int BUFFER_SIZE = 4096;
        private File file;

        public FilePoster(File file) {
            assert (file != null && file.exists());
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post(OutputStream out) throws IOException {
            FileInputStream in = new FileInputStream(this.file);
            try {
                int len;
                byte[] buf = new byte[4096];
                while ((len = ((InputStream)in).read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    static interface DataPoster {
        public void post(OutputStream var1) throws IOException;
    }
}

