/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.LocalVersionFactory;
import com.google.appengine.tools.info.Version;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SdkInfo {
    public static final String SDK_ROOT_PROPERTY = "appengine.sdk.root";
    private static final String DEFAULT_SERVER = "appengine.google.com";
    private static File sdkRoot = SdkInfo.findSdkRoot();
    private static List<File> sharedLibFiles = Collections.unmodifiableList(SdkInfo.getLibsRecursive(sdkRoot, "shared"));
    private static List<URL> sharedLibs = Collections.unmodifiableList(SdkInfo.toURLs(sharedLibFiles));
    private static List<File> userLibFiles = Collections.unmodifiableList(SdkInfo.getLibsRecursive(sdkRoot, "user"));
    private static List<URL> userLibs = Collections.unmodifiableList(SdkInfo.toURLs(userLibFiles));

    static List<URL> toURLs(List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        for (File file : files) {
            urls.add(SdkInfo.toURL(file));
        }
        return urls;
    }

    static URL toURL(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable get a URL from " + file, e);
        }
    }

    static List<File> getLibs(File sdkRoot, String libSubDir) {
        return SdkInfo._getLibs(sdkRoot, libSubDir, false);
    }

    static List<File> getLibsRecursive(File sdkRoot, String libSubDir) {
        return SdkInfo._getLibs(sdkRoot, libSubDir, true);
    }

    static List<File> _getLibs(File sdkRoot, String libSubDir, boolean recursive) {
        File subDir = new File(sdkRoot, "lib" + File.separator + libSubDir);
        if (!subDir.exists()) {
            throw new IllegalArgumentException("Unable to find " + subDir.getAbsolutePath());
        }
        ArrayList<File> libs = new ArrayList<File>();
        SdkInfo.getLibs(subDir, libs, recursive);
        return libs;
    }

    static void getLibs(File dir, List<File> list, boolean recursive) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory() && recursive) {
                SdkInfo.getLibs(f, list, recursive);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            list.add(f);
        }
    }

    private static File findSdkRoot() {
        File libDir;
        String explicitRootString = System.getProperty(SDK_ROOT_PROPERTY);
        if (explicitRootString != null) {
            return new File(explicitRootString);
        }
        URL codeLocation = SdkInfo.class.getProtectionDomain().getCodeSource().getLocation();
        String msg = "Unable to discover the Google App Engine SDK root. This code should be loaded from the SDK directory, but was instead loaded from " + codeLocation + ".  Specify " + "-Dappengine.sdk.root to override the SDK location.";
        try {
            libDir = new File(codeLocation.toURI());
        }
        catch (URISyntaxException e) {
            libDir = new File(codeLocation.getFile());
        }
        while (!libDir.getName().equals("lib")) {
            if ((libDir = libDir.getParentFile()) != null) continue;
            throw new RuntimeException(msg);
        }
        return libDir.getParentFile();
    }

    public static List<URL> getSharedLibs() {
        return sharedLibs;
    }

    public static List<File> getSharedLibFiles() {
        return sharedLibFiles;
    }

    public static List<URL> getUserLibs() {
        return userLibs;
    }

    public static List<File> getUserLibFiles() {
        return userLibFiles;
    }

    public static File getSdkRoot() {
        return sdkRoot;
    }

    public static Version getLocalVersion() {
        return new LocalVersionFactory(SdkInfo.getUserLibFiles()).getVersion();
    }

    public static String getDefaultServer() {
        return DEFAULT_SERVER;
    }
}

