/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppEngineWebXml {
    private final Map<String, String> systemProperties = Maps.newHashMap();
    private final Map<String, String> envVariables = Maps.newHashMap();
    private final List<UserPermission> userPermissions = new ArrayList<UserPermission>();
    static final String WARMUP_SERVICE = "warmup";
    private String appId;
    private String majorVersionId;
    private boolean sslEnabled = true;
    private boolean useSessions = false;
    private boolean asyncSessionPersistence = false;
    private String asyncSessionPersistenceQueueName;
    private final List<StaticFileInclude> staticFileIncludes;
    private final List<String> staticFileExcludes;
    private final List<String> resourceFileIncludes;
    private final List<String> resourceFileExcludes;
    private Pattern staticIncludePattern;
    private Pattern staticExcludePattern;
    private Pattern resourceIncludePattern;
    private Pattern resourceExcludePattern;
    private String publicRoot = "";
    private String appRoot;
    private final Set<String> inboundServices;
    private boolean precompilationEnabled = true;
    private final List<AdminConsolePage> adminConsolePages = new ArrayList<AdminConsolePage>();
    private final List<ErrorHandler> errorHandlers = new ArrayList<ErrorHandler>();
    private boolean threadsafe = false;
    private ApiConfig apiConfig;
    private final List<String> apiEndpointIds;

    public AppEngineWebXml() {
        this.staticFileIncludes = new ArrayList<StaticFileInclude>();
        this.staticFileExcludes = new ArrayList<String>();
        this.staticFileExcludes.add("WEB-INF/**");
        this.staticFileExcludes.add("**.jsp");
        this.resourceFileIncludes = new ArrayList<String>();
        this.resourceFileExcludes = new ArrayList<String>();
        this.inboundServices = new LinkedHashSet<String>();
        this.apiEndpointIds = new ArrayList<String>();
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public void addSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.envVariables);
    }

    public void addEnvironmentVariable(String key, String value) {
        this.envVariables.put(key, value);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMajorVersionId() {
        return this.majorVersionId;
    }

    public void setMajorVersionId(String majorVersionId) {
        this.majorVersionId = majorVersionId;
    }

    public void setSslEnabled(boolean ssl) {
        this.sslEnabled = ssl;
    }

    public boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSessionsEnabled(boolean sessions) {
        this.useSessions = sessions;
    }

    public boolean getSessionsEnabled() {
        return this.useSessions;
    }

    public void setAsyncSessionPersistence(boolean asyncSessionPersistence) {
        this.asyncSessionPersistence = asyncSessionPersistence;
    }

    public boolean getAsyncSessionPersistence() {
        return this.asyncSessionPersistence;
    }

    public void setAsyncSessionPersistenceQueueName(String asyncSessionPersistenceQueueName) {
        this.asyncSessionPersistenceQueueName = asyncSessionPersistenceQueueName;
    }

    public String getAsyncSessionPersistenceQueueName() {
        return this.asyncSessionPersistenceQueueName;
    }

    public List<StaticFileInclude> getStaticFileIncludes() {
        return this.staticFileIncludes;
    }

    public List<String> getStaticFileExcludes() {
        return this.staticFileExcludes;
    }

    public void includeStaticPattern(String pattern, String expiration) {
        this.staticIncludePattern = null;
        this.staticFileIncludes.add(new StaticFileInclude(pattern, expiration));
    }

    public void excludeStaticPattern(String url) {
        this.staticExcludePattern = null;
        this.staticFileExcludes.add(url);
    }

    public List<String> getResourcePatterns() {
        return this.resourceFileIncludes;
    }

    public List<String> getResourceFileExcludes() {
        return this.resourceFileExcludes;
    }

    public void includeResourcePattern(String url) {
        this.resourceExcludePattern = null;
        this.resourceFileIncludes.add(url);
    }

    public void excludeResourcePattern(String url) {
        this.resourceIncludePattern = null;
        this.resourceFileExcludes.add(url);
    }

    public void addUserPermission(String className, String name, String actions) {
        if (className.startsWith("java.")) {
            throw new AppEngineConfigException("Cannot specify user-permissions for classes in java.* packages.");
        }
        this.userPermissions.add(new UserPermission(className, name, actions));
    }

    public Permissions getUserPermissions() {
        Permissions permissions = new Permissions();
        for (UserPermission permission : this.userPermissions) {
            permissions.add(new UnresolvedPermission(permission.getClassName(), permission.getName(), permission.getActions(), null));
        }
        permissions.setReadOnly();
        return permissions;
    }

    public void setPublicRoot(String root) {
        if (root.indexOf(42) != -1) {
            throw new AppEngineConfigException("public-root cannot contain wildcards");
        }
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        if (root.length() > 0 && !root.startsWith("/")) {
            root = "/" + root;
        }
        this.staticIncludePattern = null;
        this.publicRoot = root;
    }

    public String getPublicRoot() {
        return this.publicRoot;
    }

    public void addInboundService(String service) {
        this.inboundServices.add(service);
    }

    public Set<String> getInboundServices() {
        return this.inboundServices;
    }

    public boolean getPrecompilationEnabled() {
        return this.precompilationEnabled;
    }

    public void setPrecompilationEnabled(boolean precompilationEnabled) {
        this.precompilationEnabled = precompilationEnabled;
    }

    public boolean getWarmupRequestsEnabled() {
        return this.inboundServices.contains(WARMUP_SERVICE);
    }

    public void setWarmupRequestsEnabled(boolean warmupRequestsEnabled) {
        if (warmupRequestsEnabled) {
            this.inboundServices.add(WARMUP_SERVICE);
        } else {
            this.inboundServices.remove(WARMUP_SERVICE);
        }
    }

    public List<AdminConsolePage> getAdminConsolePages() {
        return Collections.unmodifiableList(this.adminConsolePages);
    }

    public void addAdminConsolePage(AdminConsolePage page) {
        this.adminConsolePages.add(page);
    }

    public List<ErrorHandler> getErrorHandlers() {
        return Collections.unmodifiableList(this.errorHandlers);
    }

    public void addErrorHandler(ErrorHandler handler) {
        this.errorHandlers.add(handler);
    }

    public boolean getThreadsafe() {
        return this.threadsafe;
    }

    public void setThreadsafe(boolean threadsafe) {
        this.threadsafe = threadsafe;
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public void setApiConfig(ApiConfig config) {
        this.apiConfig = config;
    }

    public boolean isApiEndpoint(String id) {
        return this.apiEndpointIds.contains(id);
    }

    public void addApiEndpoint(String id) {
        this.apiEndpointIds.add(id);
    }

    public String toString() {
        return "AppEngineWebXml{systemProperties=" + this.systemProperties + ", envVariables=" + this.envVariables + ", userPermissions=" + this.userPermissions + ", appId='" + this.appId + '\'' + ", majorVersionId='" + this.majorVersionId + '\'' + ", sslEnabled=" + this.sslEnabled + ", useSessions=" + this.useSessions + ", asyncSessionPersistence=" + this.asyncSessionPersistence + ", asyncSessionPersistenceQueueName='" + this.asyncSessionPersistenceQueueName + '\'' + ", staticFileIncludes=" + this.staticFileIncludes + ", staticFileExcludes=" + this.staticFileExcludes + ", resourceFileIncludes=" + this.resourceFileIncludes + ", resourceFileExcludes=" + this.resourceFileExcludes + ", staticIncludePattern=" + this.staticIncludePattern + ", staticExcludePattern=" + this.staticExcludePattern + ", resourceIncludePattern=" + this.resourceIncludePattern + ", resourceExcludePattern=" + this.resourceExcludePattern + ", publicRoot='" + this.publicRoot + '\'' + ", appRoot='" + this.appRoot + '\'' + ", inboundServices=" + this.inboundServices + ", precompilationEnabled=" + this.precompilationEnabled + ", adminConsolePages=" + this.adminConsolePages + ", errorHandlers=" + this.errorHandlers + ", threadsafe=" + this.threadsafe + ", apiConfig=" + this.apiConfig + ", apiEndpointIds=" + this.apiEndpointIds + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEngineWebXml that = (AppEngineWebXml)o;
        if (this.asyncSessionPersistence != that.asyncSessionPersistence) {
            return false;
        }
        if (this.precompilationEnabled != that.precompilationEnabled) {
            return false;
        }
        if (this.sslEnabled != that.sslEnabled) {
            return false;
        }
        if (this.threadsafe != that.threadsafe) {
            return false;
        }
        if (this.useSessions != that.useSessions) {
            return false;
        }
        if (this.adminConsolePages != null ? !((Object)this.adminConsolePages).equals(that.adminConsolePages) : that.adminConsolePages != null) {
            return false;
        }
        if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) {
            return false;
        }
        if (this.appRoot != null ? !this.appRoot.equals(that.appRoot) : that.appRoot != null) {
            return false;
        }
        if (this.asyncSessionPersistenceQueueName != null ? !this.asyncSessionPersistenceQueueName.equals(that.asyncSessionPersistenceQueueName) : that.asyncSessionPersistenceQueueName != null) {
            return false;
        }
        if (this.envVariables != null ? !((Object)this.envVariables).equals(that.envVariables) : that.envVariables != null) {
            return false;
        }
        if (this.errorHandlers != null ? !((Object)this.errorHandlers).equals(that.errorHandlers) : that.errorHandlers != null) {
            return false;
        }
        if (this.inboundServices != null ? !((Object)this.inboundServices).equals(that.inboundServices) : that.inboundServices != null) {
            return false;
        }
        if (this.majorVersionId != null ? !this.majorVersionId.equals(that.majorVersionId) : that.majorVersionId != null) {
            return false;
        }
        if (this.publicRoot != null ? !this.publicRoot.equals(that.publicRoot) : that.publicRoot != null) {
            return false;
        }
        if (this.resourceExcludePattern != null ? !this.resourceExcludePattern.equals(that.resourceExcludePattern) : that.resourceExcludePattern != null) {
            return false;
        }
        if (this.resourceFileExcludes != null ? !((Object)this.resourceFileExcludes).equals(that.resourceFileExcludes) : that.resourceFileExcludes != null) {
            return false;
        }
        if (this.resourceFileIncludes != null ? !((Object)this.resourceFileIncludes).equals(that.resourceFileIncludes) : that.resourceFileIncludes != null) {
            return false;
        }
        if (this.resourceIncludePattern != null ? !this.resourceIncludePattern.equals(that.resourceIncludePattern) : that.resourceIncludePattern != null) {
            return false;
        }
        if (this.staticExcludePattern != null ? !this.staticExcludePattern.equals(that.staticExcludePattern) : that.staticExcludePattern != null) {
            return false;
        }
        if (this.staticFileExcludes != null ? !((Object)this.staticFileExcludes).equals(that.staticFileExcludes) : that.staticFileExcludes != null) {
            return false;
        }
        if (this.staticFileIncludes != null ? !((Object)this.staticFileIncludes).equals(that.staticFileIncludes) : that.staticFileIncludes != null) {
            return false;
        }
        if (this.staticIncludePattern != null ? !this.staticIncludePattern.equals(that.staticIncludePattern) : that.staticIncludePattern != null) {
            return false;
        }
        if (this.systemProperties != null ? !((Object)this.systemProperties).equals(that.systemProperties) : that.systemProperties != null) {
            return false;
        }
        if (this.userPermissions != null ? !((Object)this.userPermissions).equals(that.userPermissions) : that.userPermissions != null) {
            return false;
        }
        if (this.apiConfig != null ? !this.apiConfig.equals(that.apiConfig) : that.apiConfig != null) {
            return false;
        }
        return !(this.apiEndpointIds != null ? !((Object)this.apiEndpointIds).equals(that.apiEndpointIds) : that.apiEndpointIds != null);
    }

    public int hashCode() {
        int result = this.systemProperties != null ? ((Object)this.systemProperties).hashCode() : 0;
        result = 31 * result + (this.envVariables != null ? ((Object)this.envVariables).hashCode() : 0);
        result = 31 * result + (this.userPermissions != null ? ((Object)this.userPermissions).hashCode() : 0);
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + (this.majorVersionId != null ? this.majorVersionId.hashCode() : 0);
        result = 31 * result + (this.sslEnabled ? 1 : 0);
        result = 31 * result + (this.useSessions ? 1 : 0);
        result = 31 * result + (this.asyncSessionPersistence ? 1 : 0);
        result = 31 * result + (this.asyncSessionPersistenceQueueName != null ? this.asyncSessionPersistenceQueueName.hashCode() : 0);
        result = 31 * result + (this.staticFileIncludes != null ? ((Object)this.staticFileIncludes).hashCode() : 0);
        result = 31 * result + (this.staticFileExcludes != null ? ((Object)this.staticFileExcludes).hashCode() : 0);
        result = 31 * result + (this.resourceFileIncludes != null ? ((Object)this.resourceFileIncludes).hashCode() : 0);
        result = 31 * result + (this.resourceFileExcludes != null ? ((Object)this.resourceFileExcludes).hashCode() : 0);
        result = 31 * result + (this.staticIncludePattern != null ? this.staticIncludePattern.hashCode() : 0);
        result = 31 * result + (this.staticExcludePattern != null ? this.staticExcludePattern.hashCode() : 0);
        result = 31 * result + (this.resourceIncludePattern != null ? this.resourceIncludePattern.hashCode() : 0);
        result = 31 * result + (this.resourceExcludePattern != null ? this.resourceExcludePattern.hashCode() : 0);
        result = 31 * result + (this.publicRoot != null ? this.publicRoot.hashCode() : 0);
        result = 31 * result + (this.appRoot != null ? this.appRoot.hashCode() : 0);
        result = 31 * result + (this.inboundServices != null ? ((Object)this.inboundServices).hashCode() : 0);
        result = 31 * result + (this.precompilationEnabled ? 1 : 0);
        result = 31 * result + (this.adminConsolePages != null ? ((Object)this.adminConsolePages).hashCode() : 0);
        result = 31 * result + (this.errorHandlers != null ? ((Object)this.errorHandlers).hashCode() : 0);
        result = 31 * result + (this.threadsafe ? 1 : 0);
        result = 31 * result + (this.apiConfig != null ? this.apiConfig.hashCode() : 0);
        result = 31 * result + (this.apiEndpointIds != null ? ((Object)this.apiEndpointIds).hashCode() : 0);
        return result;
    }

    public boolean includesResource(String path) {
        if (this.resourceIncludePattern == null) {
            this.resourceIncludePattern = this.resourceFileIncludes.size() == 0 ? Pattern.compile(".*") : Pattern.compile(this.makeRegexp(this.resourceFileIncludes));
        }
        if (this.resourceExcludePattern == null && this.resourceFileExcludes.size() > 0) {
            this.resourceExcludePattern = Pattern.compile(this.makeRegexp(this.resourceFileExcludes));
        }
        return this.includes(path, this.resourceIncludePattern, this.resourceExcludePattern);
    }

    public boolean includesStatic(String path) {
        if (this.staticIncludePattern == null) {
            if (this.staticFileIncludes.size() == 0) {
                String staticRoot = this.publicRoot.length() > 0 ? this.publicRoot + "/**" : "**";
                this.staticIncludePattern = Pattern.compile(this.makeRegexp(Collections.singletonList(staticRoot)));
            } else {
                ArrayList<String> patterns = new ArrayList<String>();
                for (StaticFileInclude include : this.staticFileIncludes) {
                    patterns.add(include.getPattern());
                }
                this.staticIncludePattern = Pattern.compile(this.makeRegexp(patterns));
            }
        }
        if (this.staticExcludePattern == null && this.staticFileExcludes.size() > 0) {
            this.staticExcludePattern = Pattern.compile(this.makeRegexp(this.staticFileExcludes));
        }
        return this.includes(path, this.staticIncludePattern, this.staticExcludePattern);
    }

    public boolean includes(String path, Pattern includes, Pattern excludes) {
        assert (includes != null);
        if (!includes.matcher(path).matches()) {
            return false;
        }
        return excludes == null || !excludes.matcher(path).matches();
    }

    public String makeRegexp(List<String> patterns) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String item : patterns) {
            if (first) {
                first = false;
            } else {
                builder.append('|');
            }
            while (item.charAt(0) == '/') {
                item = item.substring(1);
            }
            builder.append('(');
            if (this.appRoot != null) {
                builder.append(AppEngineWebXml.makeFileRegex(this.appRoot));
            }
            builder.append("/");
            builder.append(AppEngineWebXml.makeFileRegex(item));
            builder.append(')');
        }
        return builder.toString();
    }

    static String makeFileRegex(String fileGlob) {
        fileGlob = fileGlob.replaceAll("([^A-Za-z0-9\\-_/])", "\\\\$1");
        fileGlob = fileGlob.replaceAll("\\\\\\*\\\\\\*", ".*");
        fileGlob = fileGlob.replaceAll("\\\\\\*", "[^/]*");
        return fileGlob;
    }

    public void setSourcePrefix(String appRoot) {
        this.appRoot = appRoot;
    }

    public static class ApiConfig {
        private final String servletClass;
        private final String url;

        public ApiConfig(String servletClass, String url) {
            this.servletClass = servletClass;
            this.url = url;
        }

        public String getservletClass() {
            return this.servletClass;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.servletClass == null ? 0 : this.servletClass.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ApiConfig other = (ApiConfig)obj;
            if (this.servletClass == null ? other.servletClass != null : !this.servletClass.equals(other.servletClass)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        public String toString() {
            return "ApiConfig{servletClass=\"" + this.servletClass + "\", url=\"" + this.url + "\"}";
        }
    }

    public static class ErrorHandler {
        private final String file;
        private final String errorCode;

        public ErrorHandler(String file, String errorCode) {
            this.file = file;
            this.errorCode = errorCode;
        }

        public String getFile() {
            return this.file;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ErrorHandler)) {
                return false;
            }
            ErrorHandler handler = (ErrorHandler)obj;
            if (!this.file.equals(handler.file)) {
                return false;
            }
            return !(this.errorCode == null ? handler.errorCode != null : !this.errorCode.equals(handler.errorCode));
        }
    }

    public static class AdminConsolePage {
        private final String name;
        private final String url;

        public AdminConsolePage(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdminConsolePage other = (AdminConsolePage)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }

    public static class StaticFileInclude {
        private final String pattern;
        private final String expiration;

        public StaticFileInclude(String pattern, String expiration) {
            this.pattern = pattern;
            this.expiration = expiration;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public int hashCode() {
            return Objects.hashCode(this.pattern, this.expiration);
        }

        public boolean equals(Object obj) {
            if (obj instanceof StaticFileInclude) {
                StaticFileInclude include = (StaticFileInclude)obj;
                if (this.pattern.equals(include.pattern) && (this.expiration == null ? include.expiration == null : this.expiration.equals(include.expiration))) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class UserPermission {
        private final String className;
        private final String name;
        private final String actions;
        private boolean hasHashCode = false;
        private int hashCode;

        public UserPermission(String className, String name, String actions) {
            this.className = className;
            this.name = name;
            this.actions = actions;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public String getActions() {
            return this.actions;
        }

        public int hashCode() {
            if (this.hasHashCode) {
                return this.hashCode;
            }
            int hash = this.className.hashCode();
            hash = 31 * hash + this.name.hashCode();
            if (this.actions != null) {
                hash = 31 * hash + this.actions.hashCode();
            }
            this.hashCode = hash;
            this.hasHashCode = true;
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UserPermission) {
                UserPermission perm = (UserPermission)obj;
                if (this.className.equals(perm.className) && this.name.equals(perm.name) && (this.actions == null ? perm.actions == null : this.actions.equals(perm.actions))) {
                    return true;
                }
            }
            return false;
        }
    }
}

