/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jmx;

import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JMXInvokerJob
implements Job {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$quartz$jobs$ee$jmx$JMXInvokerJob;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            Object[] params = null;
            String[] types = null;
            String objName = null;
            String objMethod = null;
            String[] keys = context.getJobDetail().getJobDataMap().getKeys();
            for (int i = 0; i < keys.length; ++i) {
                String value = context.getJobDetail().getJobDataMap().getString(keys[i]);
                if ("JMX_OBJECTNAME".equalsIgnoreCase(keys[i])) {
                    objName = value;
                    continue;
                }
                if ("JMX_METHOD".equalsIgnoreCase(keys[i])) {
                    objMethod = value;
                    continue;
                }
                if (!"JMX_PARAMDEFS".equalsIgnoreCase(keys[i])) continue;
                String[] paramdefs = this.split(value, ",");
                params = new Object[paramdefs.length];
                types = new String[paramdefs.length];
                block16: for (int k = 0; k < paramdefs.length; ++k) {
                    String[] parts = this.split(paramdefs[k], ":");
                    if (parts.length < 2) {
                        throw new Exception("Invalid parameter definition: required parts missing " + paramdefs[k]);
                    }
                    switch (parts[0].charAt(0)) {
                        case 'i': {
                            params[k] = new Integer(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = Integer.TYPE.getName();
                            continue block16;
                        }
                        case 'I': {
                            params[k] = new Integer(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = (class$java$lang$Integer == null ? JMXInvokerJob.class$("java.lang.Integer") : class$java$lang$Integer).getName();
                            continue block16;
                        }
                        case 'l': {
                            params[k] = new Long(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = Long.TYPE.getName();
                            continue block16;
                        }
                        case 'L': {
                            params[k] = new Long(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = (class$java$lang$Long == null ? JMXInvokerJob.class$("java.lang.Long") : class$java$lang$Long).getName();
                            continue block16;
                        }
                        case 'f': {
                            params[k] = new Float(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = Float.TYPE.getName();
                            continue block16;
                        }
                        case 'F': {
                            params[k] = new Float(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = (class$java$lang$Float == null ? JMXInvokerJob.class$("java.lang.Float") : class$java$lang$Float).getName();
                            continue block16;
                        }
                        case 'd': {
                            params[k] = new Double(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = Double.TYPE.getName();
                            continue block16;
                        }
                        case 'D': {
                            params[k] = new Double(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = (class$java$lang$Double == null ? JMXInvokerJob.class$("java.lang.Double") : class$java$lang$Double).getName();
                            continue block16;
                        }
                        case 's': {
                            params[k] = new String(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = (class$java$lang$String == null ? JMXInvokerJob.class$("java.lang.String") : class$java$lang$String).getName();
                            continue block16;
                        }
                        case 'b': {
                            params[k] = new Boolean(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = Boolean.TYPE.getName();
                            continue block16;
                        }
                        case 'B': {
                            params[k] = new Boolean(context.getJobDetail().getJobDataMap().getString(parts[1]));
                            types[k] = (class$java$lang$Boolean == null ? JMXInvokerJob.class$("java.lang.Boolean") : class$java$lang$Boolean).getName();
                        }
                    }
                }
            }
            if (objName == null || objMethod == null) {
                throw new Exception("Required parameters missing");
            }
            this.invoke(objName, objMethod, params, types);
        }
        catch (Exception e) {
            String m = "Caught a " + e.getClass().getName() + " exception : " + e.getMessage();
            JMXInvokerJob.getLog().error(m, e);
            throw new JobExecutionException(m, e, false);
        }
    }

    private String[] split(String str, String splitStr) {
        LinkedList<String> l = new LinkedList<String>();
        StringTokenizer strTok = new StringTokenizer(str, splitStr);
        while (strTok.hasMoreTokens()) {
            String tok = strTok.nextToken();
            l.add(tok);
        }
        return l.toArray(new String[l.size()]);
    }

    private void invoke(String objectName, String method, Object[] params, String[] types) throws Exception {
        MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
        ObjectName mbean = new ObjectName(objectName);
        if (server == null) {
            throw new Exception("Can't find mbean server");
        }
        JMXInvokerJob.getLog().info("invoking " + method);
        server.invoke(mbean, method, params, types);
    }

    private static Log getLog() {
        return LogFactory.getLog(class$org$quartz$jobs$ee$jmx$JMXInvokerJob == null ? (class$org$quartz$jobs$ee$jmx$JMXInvokerJob = JMXInvokerJob.class$("org.quartz.jobs.ee.jmx.JMXInvokerJob")) : class$org$quartz$jobs$ee$jmx$JMXInvokerJob);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

