/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.DevQueue;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.QueueXml;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DevPullQueue
extends DevQueue {
    private Map<String, TaskQueuePb.TaskQueueAddRequest> taskMap = Collections.synchronizedMap(new HashMap());
    private Clock clock;

    @Override
    TaskQueuePb.TaskQueueMode.Mode getMode() {
        return TaskQueuePb.TaskQueueMode.Mode.PULL;
    }

    DevPullQueue(QueueXml.Entry queueXmlEntry, Clock clock) {
        super(queueXmlEntry);
        this.clock = clock;
    }

    @Override
    synchronized TaskQueuePb.TaskQueueAddResponse add(TaskQueuePb.TaskQueueAddRequest addRequest) {
        if (addRequest.getMode() != TaskQueuePb.TaskQueueMode.Mode.PULL.getValue()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_MODE.getValue());
        }
        if (!addRequest.getQueueName().equals(this.getQueueName())) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_REQUEST.getValue());
        }
        String taskName = addRequest.hasTaskName() && !addRequest.getTaskName().isEmpty() ? addRequest.getTaskName() : DevPullQueue.genTaskName();
        if (this.taskMap.containsKey(taskName)) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.TASK_ALREADY_EXISTS.getValue());
        }
        this.taskMap.put(taskName, addRequest);
        TaskQueuePb.TaskQueueAddResponse addResponse = new TaskQueuePb.TaskQueueAddResponse();
        if (!addRequest.hasTaskName() || addRequest.getTaskName().isEmpty()) {
            addRequest.setTaskName(taskName);
            addResponse.setChosenTaskName(taskName);
        }
        return addResponse;
    }

    @Override
    boolean deleteTask(String taskName) {
        return this.taskMap.remove(taskName) != null;
    }

    @Override
    void flush() {
        this.taskMap.clear();
    }

    @Override
    QueueStateInfo getStateInfo() {
        ArrayList<QueueStateInfo.TaskStateInfo> taskInfoList = new ArrayList<QueueStateInfo.TaskStateInfo>();
        for (String taskName : this.getSortedTaskNames()) {
            TaskQueuePb.TaskQueueAddRequest addRequest = this.taskMap.get(taskName);
            if (addRequest == null) continue;
            long etaMillis = addRequest.getEtaUsec() / 1000L;
            taskInfoList.add(new QueueStateInfo.TaskStateInfo(taskName, etaMillis, addRequest, this.clock));
        }
        Collections.sort(taskInfoList, new Comparator<QueueStateInfo.TaskStateInfo>(){

            @Override
            public int compare(QueueStateInfo.TaskStateInfo t1, QueueStateInfo.TaskStateInfo t2) {
                return Long.compare(t1.getEtaMillis(), t2.getEtaMillis());
            }
        });
        return new QueueStateInfo(this.queueXmlEntry, taskInfoList);
    }

    QueueStateInfo getStateInfoByTag(byte[] tag) {
        QueueStateInfo.TaskStateInfo t;
        byte[] taskTag;
        QueueStateInfo.TaskStateInfo firstTask;
        ArrayList<QueueStateInfo.TaskStateInfo> taskInfoList = new ArrayList<QueueStateInfo.TaskStateInfo>();
        for (String taskName : this.getSortedTaskNames()) {
            TaskQueuePb.TaskQueueAddRequest addRequest = this.taskMap.get(taskName);
            if (addRequest == null) continue;
            long etaMillis = addRequest.getEtaUsec() / 1000L;
            taskInfoList.add(new QueueStateInfo.TaskStateInfo(taskName, etaMillis, addRequest, this.clock));
        }
        if ((tag == null || tag.length == 0) && (firstTask = Collections.min(taskInfoList, new Comparator<QueueStateInfo.TaskStateInfo>(){

            @Override
            public int compare(QueueStateInfo.TaskStateInfo t1, QueueStateInfo.TaskStateInfo t2) {
                return Long.compare(t1.getEtaMillis(), t2.getEtaMillis());
            }
        })) != null) {
            tag = firstTask.getTagAsBytes();
        }
        final byte[] chosenTag = tag == null ? null : (byte[])tag.clone();
        Collections.sort(taskInfoList, new Comparator<QueueStateInfo.TaskStateInfo>(){

            @Override
            public int compare(QueueStateInfo.TaskStateInfo t1, QueueStateInfo.TaskStateInfo t2) {
                byte[] tag2;
                byte[] tag1 = t1.getTagAsBytes();
                if (Arrays.equals(tag1, tag2 = t2.getTagAsBytes())) {
                    return Long.compare(t1.getEtaMillis(), t2.getEtaMillis());
                }
                if (Arrays.equals(tag1, chosenTag)) {
                    return -1;
                }
                if (Arrays.equals(tag2, chosenTag)) {
                    return 1;
                }
                return Long.compare(t1.getEtaMillis(), t2.getEtaMillis());
            }
        });
        ArrayList<QueueStateInfo.TaskStateInfo> taggedTaskInfoList = new ArrayList<QueueStateInfo.TaskStateInfo>();
        Iterator iterator = taskInfoList.iterator();
        while (iterator.hasNext() && Arrays.equals(taskTag = (t = (QueueStateInfo.TaskStateInfo)iterator.next()).getTagAsBytes(), chosenTag)) {
            taggedTaskInfoList.add(t);
        }
        return new QueueStateInfo(this.queueXmlEntry, taggedTaskInfoList);
    }

    List<String> getSortedTaskNames() {
        List taskNameList = Ordering.natural().sortedCopy(this.taskMap.keySet());
        return taskNameList;
    }

    @Override
    boolean runTask(String taskName) {
        return false;
    }

    long currentTimeMillis() {
        if (this.clock != null) {
            return this.clock.getCurrentTime();
        }
        return System.currentTimeMillis();
    }

    int availableTaskCount(List<QueueStateInfo.TaskStateInfo> tasks, long nowMillis) {
        int index = Collections.binarySearch(tasks, new QueueStateInfo.TaskStateInfo(null, nowMillis, null, null), new Comparator<QueueStateInfo.TaskStateInfo>(){

            @Override
            public int compare(QueueStateInfo.TaskStateInfo t1, QueueStateInfo.TaskStateInfo t2) {
                return Long.compare(t1.getEtaMillis(), t2.getEtaMillis());
            }
        });
        if (index < 0) {
            index = -index - 1;
        }
        return index;
    }

    synchronized List<TaskQueuePb.TaskQueueAddRequest> queryAndOwnTasks(double leaseSeconds, long maxTasks, boolean groupByTag, byte[] tag) {
        if (leaseSeconds < 0.0 || leaseSeconds > (double)QueueConstants.maxLease((TimeUnit)TimeUnit.SECONDS)) {
            throw new IllegalArgumentException("Invalid value for lease time.");
        }
        if (maxTasks <= 0L || maxTasks > QueueConstants.maxLeaseCount()) {
            throw new IllegalArgumentException("Invalid value for lease count.");
        }
        List<QueueStateInfo.TaskStateInfo> tasks = groupByTag ? this.getStateInfoByTag(tag).getTaskInfo() : this.getStateInfo().getTaskInfo();
        long nowMillis = this.currentTimeMillis();
        int available = this.availableTaskCount(tasks, nowMillis);
        int resultSize = (int)Math.min((long)tasks.size(), Math.min((long)available, maxTasks));
        tasks = tasks.subList(0, resultSize);
        ArrayList<TaskQueuePb.TaskQueueAddRequest> result = new ArrayList<TaskQueuePb.TaskQueueAddRequest>();
        for (QueueStateInfo.TaskStateInfo task : tasks) {
            String taskName = task.getTaskName();
            TaskQueuePb.TaskQueueAddRequest addRequest = task.getAddRequest();
            addRequest.setEtaUsec((long)((double)nowMillis * 1000.0 + leaseSeconds * 1000000.0));
            result.add(addRequest);
        }
        return result;
    }

    synchronized TaskQueuePb.TaskQueueModifyTaskLeaseResponse modifyTaskLease(TaskQueuePb.TaskQueueModifyTaskLeaseRequest request) {
        TaskQueuePb.TaskQueueModifyTaskLeaseResponse response = new TaskQueuePb.TaskQueueModifyTaskLeaseResponse();
        TaskQueuePb.TaskQueueAddRequest task = this.taskMap.get(request.getTaskName());
        if (task == null) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_TASK.getValue());
        }
        if (task.getEtaUsec() != request.getEtaUsec()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.TASK_LEASE_EXPIRED.getValue());
        }
        long timeNowUsec = (long)((double)this.currentTimeMillis() * 1000.0);
        if (task.getEtaUsec() < timeNowUsec) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.TASK_LEASE_EXPIRED.getValue());
        }
        long requestLeaseUsec = (long)(request.getLeaseSeconds() * 1000000.0);
        long etaUsec = timeNowUsec + requestLeaseUsec;
        task.setEtaUsec(etaUsec);
        response.setUpdatedEtaUsec(etaUsec);
        return response;
    }
}

