/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch.dev;

import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public final class LocalURLFetchService
implements LocalRpcService {
    private static final int DEFAULT_TIMEOUT_IN_MS = 5000;
    private static final int CONNECTIONS_PER_HOST = 20;
    static final int DEFAULT_TRUNCATABLE_MAX_RESPONSE_LENGTH = 0x100000;
    static final int DEFAULT_MAX_RESPONSE_LENGTH = 0x1000000;
    static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final String PACKAGE = "urlfetch";
    int truncatableMaxResponseLength = 0x100000;
    int maxResponseLength = 0x1000000;
    int maxRedirects = 5;
    Logger logger = Logger.getLogger(LocalURLFetchService.class.getName());
    private static final Map<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> METHOD_FACTORY_MAP = LocalURLFetchService.buildMethodFactoryMap();
    private HttpClient httpClient;
    private int timeoutInMs = 5000;

    private static Map<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> buildMethodFactoryMap() {
        HashMap<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> map = new HashMap<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory>();
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.GET, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new GetMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.DELETE, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new DeleteMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.HEAD, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new HeadMethod(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.POST, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                RedirectablePostMethod post = new RedirectablePostMethod(request.getUrl());
                if (request.hasPayload()) {
                    ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(request.getPayload().toByteArray());
                    post.setRequestEntity(requestEntity);
                }
                return post;
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.PUT, new MethodFactory(){

            public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                PutMethod put = new PutMethod(request.getUrl());
                if (request.hasPayload()) {
                    ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(request.getPayload().toByteArray());
                    put.setRequestEntity(requestEntity);
                }
                return put;
            }
        });
        return map;
    }

    protected HttpClient initializeHttpClient() {
        MultiThreadedHttpConnectionManager connManager = new MultiThreadedHttpConnectionManager();
        connManager.getParams().setDefaultMaxConnectionsPerHost(20);
        HttpClient theClient = new HttpClient(connManager);
        theClient.getParams().setLongParameter("http.connection-manager.timeout", this.timeoutInMs);
        theClient.getParams().setIntParameter("http.protocol.max-redirects", this.maxRedirects + 1);
        return theClient;
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void setTimeoutInMs(int timeoutInMs) {
        this.timeoutInMs = timeoutInMs;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.httpClient = this.initializeHttpClient();
    }

    public void start() {
    }

    public void stop() {
    }

    public URLFetchServicePb.URLFetchResponse fetch(LocalRpcService.Status status, URLFetchServicePb.URLFetchRequest request) {
        if (status == null) {
            throw new NullPointerException("status cannot be null.");
        }
        if (request == null) {
            throw new NullPointerException("request cannot be null.");
        }
        if (!this.hasValidURL(request)) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.INVALID_URL.getNumber(), "Invalid URL: " + request.getUrl());
        }
        MethodFactory methodFactory = METHOD_FACTORY_MAP.get(request.getMethod());
        if (methodFactory == null) {
            throw new IllegalArgumentException("Unsupported method: " + request.getMethod());
        }
        HttpMethodBase method = methodFactory.buildMethod(request);
        method.setFollowRedirects(request.getFollowRedirects());
        method.getParams().setIntParameter("http.connection.timeout", this.timeoutInMs);
        method.getParams().setIntParameter("http.socket.timeout", this.timeoutInMs);
        boolean sawContentType = false;
        for (URLFetchServicePb.URLFetchRequest.Header pbHeader : request.getHeaderList()) {
            method.addRequestHeader(this.pbHeaderToJakartaHeader(pbHeader));
            if (!pbHeader.getKey().equalsIgnoreCase("Content-Type")) continue;
            sawContentType = true;
        }
        if (!sawContentType && request.getMethod() == URLFetchServicePb.URLFetchRequest.RequestMethod.POST) {
            Header header = new Header();
            header.setName("Content-Type");
            header.setValue("application/x-www-form-urlencoded");
            method.addRequestHeader(header);
        }
        URLFetchServicePb.URLFetchResponse.Builder response = URLFetchServicePb.URLFetchResponse.newBuilder();
        try {
            byte[] responseBodyBytes = this.doPrivilegedExecute(method, response);
            if (responseBodyBytes != null) {
                if (responseBodyBytes.length > this.maxResponseLength) {
                    throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.RESPONSE_TOO_LARGE.getNumber(), "Response for URL " + request.getUrl() + " is too large.");
                }
                response.setContent(ByteString.copyFrom((byte[])this.limitLength(responseBodyBytes, response)));
            }
            this.jakartaHeadersToPbHeaders(method.getResponseHeaders(), response);
        }
        catch (SocketTimeoutException ste) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.DEADLINE_EXCEEDED.getNumber(), "http method " + method.getName() + " against URL " + request.getUrl() + " timed out.");
        }
        catch (IOException e) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.FETCH_ERROR.getNumber(), "Received exception executing http method " + method.getName() + " against URL " + request.getUrl() + ": " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return response.build();
    }

    private byte[] doPrivilegedExecute(final HttpMethodBase method, final URLFetchServicePb.URLFetchResponse.Builder response) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws IOException {
                    URI initialURI = method.getURI();
                    int result = LocalURLFetchService.this.httpClient.executeMethod(method);
                    response.setStatusCode(result);
                    if (!method.getURI().equals(initialURI)) {
                        response.setFinalUrl(method.getURI().toString());
                    }
                    return method.getResponseBody();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(e);
        }
    }

    byte[] limitLength(byte[] responseBody, URLFetchServicePb.URLFetchResponse.Builder response) {
        if (responseBody != null && responseBody.length > this.truncatableMaxResponseLength) {
            byte[] newResponseBody = new byte[this.truncatableMaxResponseLength];
            System.arraycopy(responseBody, 0, newResponseBody, 0, newResponseBody.length);
            responseBody = newResponseBody;
            response.setContentWasTruncated(true);
        }
        return responseBody;
    }

    boolean isAllowedPort(int port) {
        return port == -1 || port >= 80 && port <= 90 || port >= 440 && port <= 450 || port >= 1024;
    }

    boolean hasValidURL(URLFetchServicePb.URLFetchRequest request) {
        URL url;
        if (!request.hasUrl() || request.getUrl().length() == 0) {
            return false;
        }
        try {
            url = new URL(request.getUrl());
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            return false;
        }
        if (!this.isAllowedPort(url.getPort())) {
            this.logger.log(Level.WARNING, String.format("urlfetch received %s ; port %s is not allowed in production!", url, url.getPort()));
        }
        return true;
    }

    Header pbHeaderToJakartaHeader(URLFetchServicePb.URLFetchRequest.Header pbHeader) {
        Header jakartaHeader = new Header();
        jakartaHeader.setName(pbHeader.getKey());
        jakartaHeader.setValue(pbHeader.getValue());
        return jakartaHeader;
    }

    void jakartaHeadersToPbHeaders(Header[] headers, URLFetchServicePb.URLFetchResponse.Builder response) {
        LinkedHashMap<String, String> newHeaders = new LinkedHashMap<String, String>(headers.length);
        for (Header header : headers) {
            String name = header.getName();
            String value = (String)newHeaders.get(name);
            value = value == null ? header.getValue() : value + ", " + header.getValue();
            newHeaders.put(name, value);
        }
        for (Map.Entry entry : newHeaders.entrySet()) {
            response.addHeader(URLFetchServicePb.URLFetchResponse.Header.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()));
        }
    }

    private static class RedirectablePostMethod
    extends PostMethod {
        private boolean followRedirects;

        public RedirectablePostMethod() {
        }

        public RedirectablePostMethod(String uri) {
            super(uri);
        }

        public void setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
        }

        public boolean getFollowRedirects() {
            return this.followRedirects;
        }
    }

    private static interface MethodFactory {
        public HttpMethodBase buildMethod(URLFetchServicePb.URLFetchRequest var1);
    }
}

