/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.client.datastoreservice.app.AllocateIdsHandler;
import com.google.apphosting.client.datastoreservice.app.BeginTransactionHandler;
import com.google.apphosting.client.datastoreservice.app.BlindWriteHandler;
import com.google.apphosting.client.datastoreservice.app.CommitHandler;
import com.google.apphosting.client.datastoreservice.app.DatastoreClient;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.app.LookupHandler;
import com.google.apphosting.client.datastoreservice.app.RollbackHandler;
import com.google.apphosting.client.datastoreservice.app.RunQueryHandler;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.client.serviceapp.RpcService;
import com.google.apphosting.client.serviceapp.ServiceRegistry;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.Map;

public class DatastoreRpcService
implements RpcService {
    private static final int MAX_KEYS_PER_BATCH = 500;
    private final DatastoreClient datastoreClient;
    private final EntityV4Normalizer entityNormalizer;
    private final EntityTranslator entityTranslator;
    private final Map<EntityTranslator.Format, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult>> resultTransforms = ImmutableMap.of(EntityTranslator.Format.V1BETA1, this.newResultTransform(EntityTranslator.Format.V1BETA1), EntityTranslator.Format.V1BETA2, this.newResultTransform(EntityTranslator.Format.V1BETA2));

    public DatastoreRpcService(String defaultDatasetId) {
        this(defaultDatasetId, new InternDatastoreRpcService());
    }

    DatastoreRpcService(String defaultDatasetId, InternDatastoreRpcService internService) {
        this(internService, new EntityV4Normalizer(defaultDatasetId, EntityTranslator.DEFAULT), EntityTranslator.DEFAULT);
    }

    private DatastoreRpcService(InternDatastoreRpcService internService, EntityV4Normalizer entityNormalizer, EntityTranslator entityTranslator) {
        this.entityNormalizer = entityNormalizer;
        this.entityTranslator = entityTranslator;
        this.datastoreClient = new DatastoreClient(internService);
    }

    AllocateIdsHandler newAllocateIdsHandler(int maxKeysPerBatch) {
        return new AllocateIdsHandler(this.datastoreClient, this.entityNormalizer, maxKeysPerBatch);
    }

    BeginTransactionHandler newBeginTransactionHandler() {
        return new BeginTransactionHandler(this.datastoreClient);
    }

    CommitHandler newCommitHandler() {
        return new CommitHandler(this.datastoreClient, this.entityNormalizer);
    }

    RollbackHandler newRollbackHandler() {
        return new RollbackHandler(this.datastoreClient);
    }

    LookupHandler newLookupHandler(EntityTranslator.Format outputFormat) {
        return new LookupHandler(this.datastoreClient, this.entityNormalizer, this.resultTransforms.get((Object)outputFormat));
    }

    RunQueryHandler newRunQueryHandler(EntityTranslator.Format outputFormat) {
        return new RunQueryHandler(this.datastoreClient, this.entityNormalizer, this.resultTransforms.get((Object)outputFormat));
    }

    @Override
    public void registerService(ServiceRegistry registry) {
        String[] v1beta1 = new String[]{"v1beta1"};
        String[] v1beta2 = new String[]{"v1", "v1beta2"};
        String[] all = new String[]{"v1", "v1beta1", "v1beta2"};
        CommitHandler commitHandler = this.newCommitHandler();
        this.registerHandler(registry, all, "allocateIds", this.newAllocateIdsHandler(500));
        this.registerHandler(registry, all, "beginTransaction", this.newBeginTransactionHandler());
        this.registerHandler(registry, all, "commit", commitHandler);
        this.registerHandler(registry, all, "rollback", this.newRollbackHandler());
        this.registerHandler(registry, v1beta1, "lookup", this.newLookupHandler(EntityTranslator.Format.V1BETA1));
        this.registerHandler(registry, v1beta2, "lookup", this.newLookupHandler(EntityTranslator.Format.V1BETA2));
        this.registerHandler(registry, v1beta1, "runQuery", this.newRunQueryHandler(EntityTranslator.Format.V1BETA1));
        this.registerHandler(registry, v1beta2, "runQuery", this.newRunQueryHandler(EntityTranslator.Format.V1BETA2));
        this.registerHandler(registry, v1beta1, "blindWrite", new BlindWriteHandler(commitHandler));
    }

    private <R extends MessageLite, S extends MessageLite> void registerHandler(ServiceRegistry registry, String[] versions, String methodName, RpcHandler<R, S> handler) {
        for (String versionName : versions) {
            registry.registerHandler("datastore", versionName, methodName, handler);
        }
    }

    Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> newResultTransform(final EntityTranslator.Format format) {
        return new Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult>(){

            @Override
            public DatastoreV4.EntityResult apply(DatastoreV4.EntityResult input) {
                EntityV4.Entity entity = DatastoreRpcService.this.entityTranslator.isFormat(format, input.getEntity()) ? input.getEntity() : DatastoreRpcService.this.entityTranslator.toFormat(format, input.getEntity().toBuilder()).build();
                return DatastoreV4.EntityResult.newBuilder().setEntity(entity).build();
            }
        };
    }
}

