/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.log.InvalidRequestException;
import com.google.appengine.api.log.LogQuery;
import com.google.appengine.api.log.LogQueryResult;
import com.google.appengine.api.log.LogService;
import com.google.appengine.api.log.LogServiceException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.logservice.LogServicePb;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class LogServiceImpl
implements LogService {
    static final String PACKAGE = "logservice";
    static final String READ_RPC_NAME = "Read";

    LogServiceImpl() {
    }

    public LogQueryResult fetch(LogQuery query) {
        try {
            return this.fetchAsync(query).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof LogServiceException) {
                throw (LogServiceException)e.getCause();
            }
            if (e.getCause() instanceof InvalidRequestException) {
                throw (InvalidRequestException)e.getCause();
            }
            throw new LogServiceException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new LogServiceException(e.getMessage());
        }
    }

    Future<LogQueryResult> fetchAsync(LogQuery query) {
        Long endTimeUs;
        LogServicePb.LogReadRequest request = new LogServicePb.LogReadRequest();
        request.setAppId(ApiProxy.getCurrentEnvironment().getAppId());
        Long startTimeUs = query.getStartTimeUsec();
        if (startTimeUs != null) {
            request.setStartTime(startTimeUs);
        }
        if ((endTimeUs = query.getEndTimeUsec()) != null) {
            request.setEndTime(endTimeUs);
        }
        request.setCount(query.getBatchSize().intValue());
        if (query.getMinLogLevel() != null) {
            request.setMinimumLogLevel(query.getMinLogLevel().ordinal());
        }
        request.setIncludeIncomplete(query.getIncludeIncomplete());
        request.setIncludeAppLogs(query.getIncludeAppLogs());
        TreeSet<LogQuery.Version> convertedModuleInfos = Sets.newTreeSet(LogQuery.VERSION_COMPARATOR);
        if (!query.getMajorVersionIds().isEmpty()) {
            for (String string : query.getMajorVersionIds()) {
                convertedModuleInfos.add(new LogQuery.Version("default", string));
            }
        } else if (!query.getModuleVersions().isEmpty()) {
            for (Pair pair : query.getModuleVersions()) {
                convertedModuleInfos.add(new LogQuery.Version((String)pair.getFirst(), (String)pair.getSecond()));
            }
        } else if (!query.getVersions().isEmpty()) {
            convertedModuleInfos.addAll(query.getVersions());
        } else {
            String currentVersionId = ApiProxy.getCurrentEnvironment().getVersionId();
            String string = currentVersionId.split("\\.")[0];
            convertedModuleInfos.add(new LogQuery.Version(ApiProxy.getCurrentEnvironment().getModuleId(), string));
        }
        for (LogQuery.Version version : convertedModuleInfos) {
            LogServicePb.LogModuleVersion requestModuleVersion = request.addModuleVersion();
            if (!version.getModuleId().equals("default")) {
                requestModuleVersion.setModuleId(version.getModuleId());
            }
            requestModuleVersion.setVersionId(version.getVersionId());
        }
        for (String string : query.getRequestIds()) {
            request.addRequestId(string);
        }
        String offset = query.getOffset();
        if (offset != null) {
            request.setOffset(LogQueryResult.parseOffset(offset));
        }
        final LogQuery logQuery = query;
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(PACKAGE, READ_RPC_NAME, request.toByteArray(), apiConfig);
        return new FutureWrapper<byte[], LogQueryResult>(responseBytes){

            @Override
            protected LogQueryResult wrap(byte[] responseBytes) {
                LogServicePb.LogReadResponse response = new LogServicePb.LogReadResponse();
                response.mergeFrom(responseBytes);
                return new LogQueryResult(response, logQuery);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    ApiProxy.ApplicationException e = (ApiProxy.ApplicationException)cause;
                    LogServicePb.LogServiceError.ErrorCode errorCode = LogServicePb.LogServiceError.ErrorCode.valueOf(e.getApplicationError());
                    if (errorCode == LogServicePb.LogServiceError.ErrorCode.INVALID_REQUEST) {
                        return new InvalidRequestException(e.getErrorDetail());
                    }
                    return new LogServiceException(e.getErrorDetail());
                }
                return cause;
            }
        };
    }
}

