/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CacheValueUtil;
import com.google.appengine.api.datastore.EntityCacheTranslator;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.MemcacheServiceHelper;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.datastore.EntityStorage;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

class EntityCache {
    static final double EXTRA_STATE_EXPIRATION_SECS = 5.0;
    private final MemcacheServiceHelper memcacheServiceHelper;
    private final double datastoreRpcDeadlineSecs;

    public EntityCache(MemcacheServiceHelper memcacheServiceHelper, double datastoreRpcDeadlineSecs) {
        Preconditions.checkArgument(datastoreRpcDeadlineSecs > 0.0, "The datastoreRpcDeadlineSecs argument must be greater than 0");
        this.memcacheServiceHelper = memcacheServiceHelper;
        this.datastoreRpcDeadlineSecs = datastoreRpcDeadlineSecs;
    }

    public Future<Set<Key>> putStateAsync(Collection<Key> keys, EntityStorage.CacheValue.State state, MemcacheService.SetPolicy policy) {
        Preconditions.checkArgument(CacheValueUtil.isDatastoreOpState(state), "The state argument is not for a datastore operation: " + state);
        HashMap<String, byte[]> memcacheValues = Maps.newHashMapWithExpectedSize(keys.size());
        byte[] stateMemcacheValue = EntityCacheTranslator.toMemcacheValue(CacheValueUtil.createCacheValue(state, null));
        for (Key key : keys) {
            memcacheValues.put(EntityCacheTranslator.toMemcacheKey(key), stateMemcacheValue);
        }
        return EntityCache.translateMemcacheKeySetResult(this.memcacheServiceHelper.put(memcacheValues, policy, this.computeDatastoreOpStateExpiration(0)));
    }

    public Map<Key, IdentifiableCacheValue> putStateIdentifiable(Collection<Key> keys, final EntityStorage.CacheValue.State state, MemcacheService.SetPolicy policy) {
        Preconditions.checkArgument(CacheValueUtil.isDatastoreOpState(state), "The state argument is not for a datastore operation: " + state);
        HashMap<String, byte[]> memcacheValues = Maps.newHashMapWithExpectedSize(keys.size());
        byte[] stateMemcacheValue = EntityCacheTranslator.toMemcacheValue(CacheValueUtil.createCacheValue(state, null));
        for (Key key : keys) {
            memcacheValues.put(EntityCacheTranslator.toMemcacheKey(key), stateMemcacheValue);
        }
        Set<String> keysPut = FutureHelper.quietGet(this.memcacheServiceHelper.put(memcacheValues, policy, this.computeDatastoreOpStateExpiration(2)));
        Predicate<EntityStorage.CacheValue> validateState = new Predicate<EntityStorage.CacheValue>(){

            @Override
            public boolean apply(EntityStorage.CacheValue value) {
                return value.getStateEnum() == state;
            }
        };
        return FutureHelper.quietGet(this.getIdentifiableHelper(keysPut, validateState));
    }

    public Future<Set<Key>> putEntitiesAsync(Map<Key, OnestoreEntity.EntityProto> entityValues, MemcacheService.SetPolicy policy) {
        HashMap<String, byte[]> memcacheValues = Maps.newHashMapWithExpectedSize(entityValues.size());
        for (Map.Entry<Key, OnestoreEntity.EntityProto> entityValueEntry : entityValues.entrySet()) {
            OnestoreEntity.EntityProto entity = Preconditions.checkNotNull(entityValueEntry.getValue(), "The entity value can not be null\n");
            memcacheValues.put(EntityCacheTranslator.toMemcacheKey(entityValueEntry.getKey()), EntityCacheTranslator.toMemcacheValue(CacheValueUtil.createCacheValue(EntityStorage.CacheValue.State.ENTITY, entity)));
        }
        return EntityCache.translateMemcacheKeySetResult(this.memcacheServiceHelper.put(memcacheValues, policy));
    }

    public Future<Set<Key>> putIfUntouchedAsync(Map<Key, CasCacheValues> values) {
        HashMap<String, MemcacheService.CasValues> memcacheValues = Maps.newHashMapWithExpectedSize(values.size());
        for (Map.Entry<Key, CasCacheValues> valueEntry : values.entrySet()) {
            memcacheValues.put(EntityCacheTranslator.toMemcacheKey(valueEntry.getKey()), EntityCacheTranslator.toMemcacheCasValues(valueEntry.getValue()));
        }
        return EntityCache.translateMemcacheKeySetResult(this.memcacheServiceHelper.putIfUntouched(memcacheValues));
    }

    public Future<Map<Key, IdentifiableCacheValue>> getIdentifiableAsync(Collection<Key> keys) {
        ArrayList<String> memcacheKeys = Lists.newArrayListWithExpectedSize(keys.size());
        for (Key key : keys) {
            memcacheKeys.add(EntityCacheTranslator.toMemcacheKey(key));
        }
        return this.getIdentifiableHelper(memcacheKeys, null);
    }

    private Future<Map<Key, IdentifiableCacheValue>> getIdentifiableHelper(Collection<String> memcacheKeys, final Predicate<EntityStorage.CacheValue> valueFilter) {
        Future<Map<String, MemcacheService.IdentifiableValue>> getResults = this.memcacheServiceHelper.getIdentifiable(memcacheKeys);
        return new FutureWrapper<Map<String, MemcacheService.IdentifiableValue>, Map<Key, IdentifiableCacheValue>>(getResults){

            @Override
            protected Map<Key, IdentifiableCacheValue> wrap(Map<String, MemcacheService.IdentifiableValue> memcacheResults) throws Exception {
                HashMap<Key, IdentifiableCacheValue> results = Maps.newHashMapWithExpectedSize(memcacheResults.size());
                for (Map.Entry<String, MemcacheService.IdentifiableValue> memcacheResult : memcacheResults.entrySet()) {
                    IdentifiableCacheValue identifiableCacheValue = EntityCacheTranslator.fromMemcacheIdentifiableValue(memcacheResult.getValue());
                    if (identifiableCacheValue == null) continue;
                    EntityStorage.CacheValue cacheValue = identifiableCacheValue.getValue();
                    if (valueFilter != null && !valueFilter.apply(cacheValue)) continue;
                    results.put(EntityCacheTranslator.fromMemcacheKey(memcacheResult.getKey()), identifiableCacheValue);
                }
                return results;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    public Future<Set<Key>> evictIfUntouchedAsync(Map<Key, IdentifiableCacheValue> values) {
        HashMap<String, MemcacheService.CasValues> memcacheValues = Maps.newHashMapWithExpectedSize(values.size());
        for (Map.Entry<Key, IdentifiableCacheValue> valueEntry : values.entrySet()) {
            CasCacheValues casCacheValue = new CasCacheValues(valueEntry.getValue(), null);
            memcacheValues.put(EntityCacheTranslator.toMemcacheKey(valueEntry.getKey()), EntityCacheTranslator.toMemcacheCasValues(casCacheValue));
        }
        return EntityCache.translateMemcacheKeySetResult(this.memcacheServiceHelper.putIfUntouched(memcacheValues));
    }

    public Future<Set<Key>> evictAsync(Collection<Key> keys) {
        ArrayList<String> memcacheKeys = Lists.newArrayListWithExpectedSize(keys.size());
        for (Key key : keys) {
            memcacheKeys.add(EntityCacheTranslator.toMemcacheKey(key));
        }
        return EntityCache.translateMemcacheKeySetResult(this.memcacheServiceHelper.delete(memcacheKeys));
    }

    public Set<Key> evictEntitiesOnly(Collection<Key> keys) {
        ArrayList<String> memcacheKeys = Lists.newArrayListWithExpectedSize(keys.size());
        for (Key key : keys) {
            memcacheKeys.add(EntityCacheTranslator.toMemcacheKey(key));
        }
        Predicate<EntityStorage.CacheValue> entitiesOnly = new Predicate<EntityStorage.CacheValue>(){

            @Override
            public boolean apply(EntityStorage.CacheValue value) {
                return value.getStateEnum() == EntityStorage.CacheValue.State.ENTITY;
            }
        };
        Map<Key, IdentifiableCacheValue> getResults = FutureHelper.quietGet(this.getIdentifiableHelper(memcacheKeys, entitiesOnly));
        return FutureHelper.quietGet(this.evictIfUntouchedAsync(getResults));
    }

    private static Future<Set<Key>> translateMemcacheKeySetResult(Future<Set<String>> inputSet) {
        return new FutureWrapper<Set<String>, Set<Key>>(inputSet){

            @Override
            protected Set<Key> wrap(Set<String> memcacheKeys) throws Exception {
                LinkedHashSet<Key> outputResults = Sets.newLinkedHashSetWithExpectedSize(memcacheKeys.size());
                for (String memcacheKey : memcacheKeys) {
                    outputResults.add(EntityCacheTranslator.fromMemcacheKey(memcacheKey));
                }
                return outputResults;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    Expiration computeDatastoreOpStateExpiration(int numSyncMemcacheOps) {
        double stateExpirationTimeSecs = (double)numSyncMemcacheOps * this.memcacheServiceHelper.getRpcDeadlineSecs() + this.datastoreRpcDeadlineSecs + 5.0;
        return Expiration.byDeltaMillis((int)(stateExpirationTimeSecs * 1000.0));
    }

    public static final class CasCacheValues {
        private final IdentifiableCacheValue oldValue;
        private final EntityStorage.CacheValue newValue;

        public CasCacheValues(IdentifiableCacheValue oldValue, EntityStorage.CacheValue newValue) {
            this.oldValue = Preconditions.checkNotNull(oldValue, "The oldValue argument can not be null");
            if (newValue != null) {
                Preconditions.checkArgument(newValue.getStateEnum() == EntityStorage.CacheValue.State.ENTITY, "The newValue argument does not contain an entity");
            }
            this.newValue = newValue;
        }

        public IdentifiableCacheValue getOldValue() {
            return this.oldValue;
        }

        public EntityStorage.CacheValue getNewValue() {
            return this.newValue;
        }
    }

    public static final class IdentifiableCacheValue {
        private final MemcacheService.IdentifiableValue memcacheValue;
        private final EntityStorage.CacheValue value;

        public IdentifiableCacheValue(MemcacheService.IdentifiableValue memcacheValue, EntityStorage.CacheValue value) {
            this.memcacheValue = memcacheValue;
            this.value = value;
        }

        public EntityStorage.CacheValue getValue() {
            return this.value;
        }

        public MemcacheService.IdentifiableValue getMemcacheValue() {
            return this.memcacheValue;
        }
    }
}

