/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.utils;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class FutureWrapper<K, V>
implements Future<V> {
    private final Future<K> parent;
    private boolean hasResult;
    private V successResult;
    private ExecutionException exceptionResult;
    private final Lock lock = new ReentrantLock();

    public FutureWrapper(Future<K> parent) {
        this.parent = Preconditions.checkNotNull(parent);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.parent.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.parent.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.parent.isDone();
    }

    private V handleParentException(Throwable cause) throws Throwable {
        return this.setSuccessResult(this.absorbParentException(cause));
    }

    private V wrapAndCache(K data) throws Exception {
        return this.setSuccessResult(this.wrap(data));
    }

    private V setSuccessResult(V result) {
        this.successResult = result;
        this.hasResult = true;
        return result;
    }

    private ExecutionException setExceptionResult(Throwable ex) {
        this.exceptionResult = new ExecutionException(ex);
        this.hasResult = true;
        return this.exceptionResult;
    }

    private V getCachedResult() throws ExecutionException {
        if (this.exceptionResult != null) {
            throw this.exceptionResult;
        }
        return this.successResult;
    }

    @Override
    public V get() throws ExecutionException, InterruptedException {
        this.lock.lock();
        try {
            K value;
            if (this.hasResult) {
                V v = this.getCachedResult();
                return v;
            }
            try {
                value = this.parent.get();
            }
            catch (ExecutionException ex) {
                V v = this.handleParentException(ex.getCause());
                this.lock.unlock();
                return v;
            }
            V v = this.wrapAndCache(value);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        long tryLockStart = System.currentTimeMillis();
        if (!this.lock.tryLock(timeout, unit)) {
            throw new TimeoutException();
        }
        try {
            K value;
            if (this.hasResult) {
                V v = this.getCachedResult();
                return v;
            }
            long remainingDeadline = TimeUnit.MILLISECONDS.convert(timeout, unit) - (System.currentTimeMillis() - tryLockStart);
            try {
                try {
                    value = this.parent.get(remainingDeadline, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException ex) {
                    V v = this.handleParentException(ex.getCause());
                    this.lock.unlock();
                    return v;
                }
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (TimeoutException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw this.setExceptionResult(this.convertException(ex));
            }
            V v = this.wrapAndCache(value);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected abstract V wrap(K var1) throws Exception;

    protected V absorbParentException(Throwable cause) throws Throwable {
        throw cause;
    }

    protected abstract Throwable convertException(Throwable var1);
}

