/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail;

import javax.mail.internet.MimeMessage;

public final class BounceNotification {
    private final MimeMessage rawMessage;
    private final Details original;
    private final Details notification;

    BounceNotification(MimeMessage rawMessage, Details original, Details notification) {
        this.rawMessage = rawMessage;
        this.original = original;
        this.notification = notification;
    }

    public final MimeMessage getRawMessage() {
        return this.rawMessage;
    }

    public final Details getOriginal() {
        return this.original;
    }

    public final Details getNotification() {
        return this.notification;
    }

    static class BounceNotificationBuilder {
        private MimeMessage rawMessage;
        private Details original;
        private Details notification;

        BounceNotificationBuilder() {
        }

        public BounceNotification build() {
            return new BounceNotification(this.rawMessage, this.original, this.notification);
        }

        public BounceNotificationBuilder withRawMessage(MimeMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public BounceNotificationBuilder withOriginal(Details original) {
            this.original = original;
            return this;
        }

        public BounceNotificationBuilder withNotification(Details notification) {
            this.notification = notification;
            return this;
        }
    }

    static class DetailsBuilder {
        private String from;
        private String to;
        private String subject;
        private String text;

        DetailsBuilder() {
        }

        public Details build() {
            return new Details(this.from, this.to, this.subject, this.text);
        }

        public DetailsBuilder withFrom(String from) {
            this.from = from;
            return this;
        }

        public DetailsBuilder withTo(String to) {
            this.to = to;
            return this;
        }

        public DetailsBuilder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public DetailsBuilder withText(String text) {
            this.text = text;
            return this;
        }
    }

    public static final class Details {
        private final String from;
        private final String to;
        private final String subject;
        private final String text;

        private Details(String from, String to, String subject, String text) {
            this.from = from;
            this.to = to;
            this.subject = subject;
            this.text = text;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getText() {
            return this.text;
        }
    }
}

