/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.io.protocol.MessageSet;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class UnknownFieldChecker {
    private final Set<Class<? extends MessageOrBuilder>> messagesToIgnore;

    UnknownFieldChecker() {
        this(ImmutableSet.of());
    }

    UnknownFieldChecker(Set<Class<? extends MessageOrBuilder>> messagesToIgnore) {
        this.messagesToIgnore = messagesToIgnore;
    }

    Set<String> getUnknownFields(MessageOrBuilder message) {
        HashSet<String> unknownFieldNames = new HashSet<String>();
        this.collectUnknownFields(null, message, unknownFieldNames);
        return unknownFieldNames;
    }

    private void collectUnknownFields(Descriptors.FieldDescriptor parentFieldDescriptor, MessageOrBuilder message, Set<String> unknownFieldsCollector) {
        if (this.messagesToIgnore.contains(message.getClass()) || message.getClass().equals(MessageSet.class)) {
            return;
        }
        Map<Integer, UnknownFieldSet.Field> unknownFieldMap = message.getUnknownFields().asMap();
        Descriptors.Descriptor messageDescriptor = message.getDescriptorForType();
        for (Integer n : unknownFieldMap.keySet()) {
            if (messageDescriptor.isExtensionNumber(n)) continue;
            String fieldName = parentFieldDescriptor == null ? "" : parentFieldDescriptor.getName();
            unknownFieldsCollector.add(String.format("%s[tag=%d]", fieldName, n));
        }
        for (Map.Entry entry : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)entry.getKey();
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            Object fieldValue = entry.getValue();
            ImmutableList<MessageOrBuilder> subMessages = fieldDescriptor.isRepeated() ? (ImmutableList<MessageOrBuilder>)fieldValue : ImmutableList.of((MessageOrBuilder)fieldValue);
            for (MessageOrBuilder subMessage : subMessages) {
                this.collectUnknownFields(fieldDescriptor, subMessage, unknownFieldsCollector);
            }
        }
    }
}

