/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.memcache.AsyncMemcacheService;
import com.google.appengine.api.memcache.ConsistentErrorHandler;
import com.google.appengine.api.memcache.ErrorHandlers;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

class MemcacheServiceHelper {
    static final double DEFAULT_MEMCACHE_RPC_DEADLINE_SECS = 1.0;
    static Logger logger = Logger.getLogger(MemcacheServiceHelper.class.getName());
    private static final Level LOG_LEVEL = Level.INFO;
    static final String NAMESPACE = "__ah-datastore-l2-v1__";
    private double rpcDeadlineSecs = 1.0;
    private Expiration defaultValueExpirationTime;
    private final AsyncMemcacheService memcacheService;

    private MemcacheServiceHelper() {
        this.memcacheService = MemcacheServiceFactory.getAsyncMemcacheService(NAMESPACE);
        this.memcacheService.setErrorHandler(new MemcacheExceptionConvertingErrorHandler());
    }

    MemcacheServiceHelper(AsyncMemcacheService memcacheService) {
        this.memcacheService = memcacheService;
    }

    public MemcacheServiceHelper rpcDeadlineSecs(double rpcDeadlineSecs) {
        Preconditions.checkArgument(rpcDeadlineSecs > 0.0, "The rpcDeadlineSecs argument must be greater than 0");
        this.rpcDeadlineSecs = rpcDeadlineSecs;
        return this;
    }

    public double getRpcDeadlineSecs() {
        return this.rpcDeadlineSecs;
    }

    public MemcacheServiceHelper defaultValueExpirationTime(Expiration defaultValueExpirationTime) {
        this.defaultValueExpirationTime = defaultValueExpirationTime;
        return this;
    }

    public Expiration getDefaultValueExpirationTime() {
        return this.defaultValueExpirationTime;
    }

    public MemcacheServiceHelper logAndAbsorbMemcacheServiceErrors() {
        this.memcacheService.setErrorHandler(ErrorHandlers.getConsistentLogAndContinue(LOG_LEVEL));
        return this;
    }

    public <K> Future<Map<K, MemcacheService.IdentifiableValue>> getIdentifiable(Collection<K> keys) {
        return this.memcacheService.getIdentifiables(keys);
    }

    public <K> Future<Set<K>> put(Map<K, ?> values, MemcacheService.SetPolicy policy) {
        return this.put(values, policy, this.defaultValueExpirationTime);
    }

    public <K> Future<Set<K>> put(Map<K, ?> values, MemcacheService.SetPolicy policy, Expiration valueExpirationTime) {
        return this.memcacheService.putAll(values, valueExpirationTime, policy);
    }

    public <K> Future<Set<K>> putIfUntouched(Map<K, MemcacheService.CasValues> values) {
        return this.putIfUntouched(values, this.defaultValueExpirationTime);
    }

    public <K> Future<Set<K>> putIfUntouched(Map<K, MemcacheService.CasValues> values, Expiration valueExpirationTime) {
        return this.memcacheService.putIfUntouched(values, valueExpirationTime);
    }

    public <K> Future<Set<K>> delete(Collection<K> keys) {
        return this.memcacheService.deleteAll(keys);
    }

    public static final class Builder {
        public static MemcacheServiceHelper withRpcDeadlineSecs(double rpcDeadlineSecs) {
            return new MemcacheServiceHelper().rpcDeadlineSecs(rpcDeadlineSecs);
        }

        public static MemcacheServiceHelper withDefaultValueExpirationTime(Expiration defaultValueExpirationTime) {
            return new MemcacheServiceHelper().defaultValueExpirationTime(defaultValueExpirationTime);
        }

        public static MemcacheServiceHelper withLogAndAbsorbMemcacheServiceErrors() {
            return new MemcacheServiceHelper().logAndAbsorbMemcacheServiceErrors();
        }

        public static MemcacheServiceHelper withDefaults() {
            return new MemcacheServiceHelper();
        }

        private Builder() {
        }
    }

    private static class MemcacheExceptionConvertingErrorHandler
    implements ConsistentErrorHandler {
        private MemcacheExceptionConvertingErrorHandler() {
        }

        @Override
        public void handleDeserializationError(InvalidValueException t) {
            throw new DatastoreFailureException("Memcache deserialization error", t);
        }

        @Override
        public void handleServiceError(MemcacheServiceException t) {
            throw new DatastoreFailureException("Memcache service error", t);
        }
    }
}

