/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Category;
import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.Email;
import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.IMHandle;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Link;
import com.google.appengine.api.datastore.PhoneNumber;
import com.google.appengine.api.datastore.PostalAddress;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.PropertyContainer;
import com.google.appengine.api.datastore.Rating;
import com.google.appengine.api.datastore.RawValue;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.EntityV4;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class DataTypeTranslator {
    private static final RawValueType RAW_VALUE_TYPE = new RawValueType();
    private static final Map<Class<?>, Type<?>> typeMap = Maps.newHashMap();
    private static final Map<Class<? extends Comparable<?>>, Integer> comparableTypeMap;

    public static void addPropertiesToPb(Map<String, Object> map, OnestoreEntity.EntityProto proto) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            boolean indexed = !(entry.getValue() instanceof Entity.UnindexedValue);
            Object value = PropertyContainer.unwrapValue(entry.getValue());
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                if (values.isEmpty()) {
                    DataTypeTranslator.addPropertyToPb(name, null, indexed, false, proto);
                    continue;
                }
                for (Object listValue : values) {
                    DataTypeTranslator.addPropertyToPb(name, listValue, indexed, true, proto);
                }
                continue;
            }
            DataTypeTranslator.addPropertyToPb(name, value, indexed, false, proto);
        }
    }

    private static void addPropertyToPb(String name, Object value, boolean indexed, boolean multiple, OnestoreEntity.EntityProto entity) {
        OnestoreEntity.Property property = new OnestoreEntity.Property();
        property.setName(name);
        property.setMultiple(multiple);
        OnestoreEntity.PropertyValue newValue = property.getMutableValue();
        if (value != null) {
            Type<?> type = DataTypeTranslator.getType(value.getClass());
            OnestoreEntity.Property.Meaning meaning = type.getV3Meaning();
            if (meaning != property.getMeaningEnum()) {
                property.setMeaning(meaning);
            }
            indexed &= type.toV3Value(value, newValue);
        }
        if (!indexed) {
            entity.addRawProperty(property);
        } else {
            entity.addProperty(property);
        }
    }

    static OnestoreEntity.PropertyValue toV3Value(Object value) {
        OnestoreEntity.PropertyValue propertyValue = new OnestoreEntity.PropertyValue();
        if (value != null) {
            DataTypeTranslator.getType(value.getClass()).toV3Value(value, propertyValue);
        }
        return propertyValue;
    }

    public static void extractIndexedPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : proto.propertys()) {
            DataTypeTranslator.addPropertyToMap(property, true, map);
        }
    }

    private static void extractUnindexedPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : proto.rawPropertys()) {
            DataTypeTranslator.addPropertyToMap(property, false, map);
        }
    }

    public static void extractPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        DataTypeTranslator.extractIndexedPropertiesFromPb(proto, map);
        DataTypeTranslator.extractUnindexedPropertiesFromPb(proto, map);
    }

    public static void extractImplicitPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : DataTypeTranslator.getImplicitProperties(proto)) {
            DataTypeTranslator.addPropertyToMap(property, true, map);
        }
    }

    private static Iterable<OnestoreEntity.Property> getImplicitProperties(OnestoreEntity.EntityProto proto) {
        return Collections.singleton(DataTypeTranslator.buildImplicitKeyProperty(proto));
    }

    private static OnestoreEntity.Property buildImplicitKeyProperty(OnestoreEntity.EntityProto proto) {
        OnestoreEntity.Property keyProp = new OnestoreEntity.Property();
        keyProp.setName("__key__");
        OnestoreEntity.PropertyValue propVal = new OnestoreEntity.PropertyValue();
        propVal.setReferenceValue(KeyType.toReferenceValue(proto.getKey()));
        keyProp.setValue(propVal);
        return keyProp;
    }

    public static Collection<OnestoreEntity.Property> findIndexedPropertiesOnPb(OnestoreEntity.EntityProto proto, String propertyName) {
        if (propertyName.equals("__key__")) {
            return Collections.singleton(DataTypeTranslator.buildImplicitKeyProperty(proto));
        }
        ArrayList<OnestoreEntity.Property> matchingMultipleProps = new ArrayList<OnestoreEntity.Property>();
        for (OnestoreEntity.Property prop : proto.propertys()) {
            if (!prop.getName().equals(propertyName)) continue;
            if (!prop.isMultiple()) {
                return Collections.singleton(prop);
            }
            matchingMultipleProps.add(prop);
        }
        return matchingMultipleProps;
    }

    private static void addPropertyToMap(OnestoreEntity.Property property, boolean indexed, Map<String, Object> map) {
        String name = property.getName();
        Object value = DataTypeTranslator.getPropertyValue(property);
        if (property.isMultiple()) {
            ArrayList<Object> results = (ArrayList<Object>)PropertyContainer.unwrapValue(map.get(name));
            if (results == null) {
                results = new ArrayList<Object>();
                map.put(name, indexed ? results : new Entity.UnindexedValue(results));
            }
            results.add(value);
        } else {
            map.put(name, indexed ? value : new Entity.UnindexedValue(value));
        }
    }

    public static Object getPropertyValue(OnestoreEntity.Property property) {
        OnestoreEntity.PropertyValue value = property.getValue();
        for (Type<?> type : typeMap.values()) {
            if (!type.isType(property.getMeaningEnum(), value)) continue;
            return type.getValue(value);
        }
        return null;
    }

    static void addPropertiesToPb(Map<String, Object> map, EntityV4.Entity.Builder proto) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            proto.addProperty(DataTypeTranslator.toV4Property(entry.getKey(), entry.getValue()));
        }
    }

    static void extractPropertiesFromPb(EntityV4.EntityOrBuilder proto, boolean indexOnly, Map<String, Object> map) {
        if (indexOnly) {
            for (EntityV4.PropertyOrBuilder propertyOrBuilder : proto.getPropertyOrBuilderList()) {
                map.put(propertyOrBuilder.getName(), new RawValue(propertyOrBuilder.getValue()));
            }
        } else {
            for (EntityV4.PropertyOrBuilder propertyOrBuilder : proto.getPropertyOrBuilderList()) {
                DataTypeTranslator.addPropertyToMap(propertyOrBuilder, map);
            }
        }
    }

    static EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
        if (value == null) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            DataTypeTranslator.setIndexed(indexed, builder);
            return builder;
        }
        return DataTypeTranslator.getType(value.getClass()).toV4Value(value, indexed);
    }

    private static EntityV4.Property.Builder toV4Property(String name, Object value) {
        EntityV4.Property.Builder builder = EntityV4.Property.newBuilder();
        builder.setName(name);
        boolean indexed = !(value instanceof Entity.UnindexedValue);
        value = PropertyContainer.unwrapValue(value);
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.isEmpty()) {
                builder.setValue(DataTypeTranslator.toV4Value(null, indexed));
            } else {
                EntityV4.Value.Builder valueBuilder = builder.getValueBuilder();
                for (Object listValue : values) {
                    valueBuilder.addListValue(DataTypeTranslator.toV4Value(listValue, indexed));
                }
            }
        } else {
            builder.setValue(DataTypeTranslator.toV4Value(value, indexed));
        }
        return builder;
    }

    private static void addPropertyToMap(EntityV4.PropertyOrBuilder prop, Map<String, Object> map) {
        ArrayList<Object> result;
        EntityV4.ValueOrBuilder value = prop.getValueOrBuilder();
        boolean indexed = value.getIndexed();
        if (value.getListValueCount() > 0) {
            ArrayList<Object> resultList = new ArrayList<Object>(value.getListValueCount());
            for (EntityV4.ValueOrBuilder valueOrBuilder : value.getListValueOrBuilderList()) {
                indexed &= valueOrBuilder.getIndexed();
                if (valueOrBuilder.getListValueCount() > 0) {
                    throw new IllegalArgumentException("Invalid Entity PB: list within a list.");
                }
                resultList.add(DataTypeTranslator.getValue(valueOrBuilder));
            }
            result = resultList;
        } else {
            result = DataTypeTranslator.getValue(value);
        }
        if (!indexed) {
            result = new Entity.UnindexedValue(result);
        }
        map.put(prop.getName(), result);
    }

    private static Object getValue(EntityV4.ValueOrBuilder value) {
        for (Type<?> type : typeMap.values()) {
            if (!type.isType(value)) continue;
            return type.getValue(value);
        }
        return null;
    }

    private static OnestoreEntity.Property.Meaning getV3MeaningOf(EntityV4.ValueOrBuilder value) {
        return OnestoreEntity.Property.Meaning.valueOf(value.getMeaning());
    }

    private static AppIdNamespace toAppIdNamespace(EntityV4.PartitionIdOrBuilder partitionId) {
        return new AppIdNamespace(partitionId.getDatasetId(), partitionId.hasNamespace() ? partitionId.getNamespace() : "");
    }

    private static EntityV4.PartitionId.Builder toV4PartitionId(AppIdNamespace appNs) {
        EntityV4.PartitionId.Builder builder = EntityV4.PartitionId.newBuilder();
        builder.setDatasetId(appNs.getAppId());
        if (!appNs.getNamespace().isEmpty()) {
            builder.setNamespace(appNs.getNamespace());
        }
        return builder;
    }

    static EntityV4.Key.Builder toV4Key(Key key) {
        EntityV4.Key.Builder builder = EntityV4.Key.newBuilder();
        builder.setPartitionId(DataTypeTranslator.toV4PartitionId(key.getAppIdNamespace()));
        ArrayList<EntityV4.Key.PathElement> pathElementList = new ArrayList<EntityV4.Key.PathElement>();
        do {
            EntityV4.Key.PathElement.Builder pathElement = EntityV4.Key.PathElement.newBuilder();
            pathElement.setKind(key.getKind());
            if (key.getName() != null) {
                pathElement.setName(key.getName());
            } else if (key.getId() != 0L) {
                pathElement.setId(key.getId());
            }
            pathElementList.add(pathElement.build());
        } while ((key = key.getParent()) != null);
        builder.addAllPathElement(Lists.reverse(pathElementList));
        return builder;
    }

    static Key toKey(EntityV4.KeyOrBuilder proto) {
        AppIdNamespace appIdNamespace = DataTypeTranslator.toAppIdNamespace(proto.getPartitionId());
        if (proto.getPathElementCount() == 0) {
            throw new IllegalArgumentException("Invalid Key PB: no elements.");
        }
        Key key = null;
        for (EntityV4.Key.PathElementOrBuilder pathElementOrBuilder : proto.getPathElementOrBuilderList()) {
            String kind = pathElementOrBuilder.getKind();
            if (pathElementOrBuilder.hasName() && pathElementOrBuilder.hasId()) {
                throw new IllegalArgumentException("Invalid Key PB: both id and name are set.");
            }
            key = new Key(kind, key, pathElementOrBuilder.getId(), pathElementOrBuilder.hasName() ? pathElementOrBuilder.getName() : null, appIdNamespace);
        }
        return key;
    }

    static Entity toEntity(EntityV4.EntityOrBuilder v4Entity) {
        Entity entity = new Entity(DataTypeTranslator.toKey(v4Entity.getKey()));
        DataTypeTranslator.extractPropertiesFromPb(v4Entity, false, entity.getPropertyMap());
        return entity;
    }

    static Entity toEntity(EntityV4.EntityOrBuilder v4Entity, Collection<Projection> projections) {
        Entity entity = new Entity(DataTypeTranslator.toKey(v4Entity.getKey()));
        HashMap<String, Object> values = Maps.newHashMap();
        DataTypeTranslator.extractPropertiesFromPb(v4Entity, true, values);
        for (Projection projection : projections) {
            entity.setProperty(projection.getName(), projection.getValue(values));
        }
        return entity;
    }

    static EntityV4.Entity.Builder toV4Entity(Entity entity) {
        EntityV4.Entity.Builder v4Entity = EntityV4.Entity.newBuilder();
        v4Entity.setKey(DataTypeTranslator.toV4Key(entity.getKey()));
        DataTypeTranslator.addPropertiesToPb(entity.getPropertyMap(), v4Entity);
        return v4Entity;
    }

    public static Comparable<Object> getComparablePropertyValue(OnestoreEntity.Property property) {
        return RAW_VALUE_TYPE.asComparable(new RawValue(property.getValue()));
    }

    static Comparable<Object> getComparablePropertyValue(Object value) {
        return value == null ? null : DataTypeTranslator.getType(value.getClass()).asComparable(value);
    }

    public static int getTypeRank(Class<? extends Comparable> datastoreType) {
        return comparableTypeMap.get(datastoreType);
    }

    private static <T> Type<T> getType(Class<T> clazz) {
        if (typeMap.containsKey(clazz)) {
            return typeMap.get(clazz);
        }
        throw new UnsupportedOperationException("Unsupported data type: " + clazz.getName());
    }

    private static EntityV4.Property makeUnindexedProperty(String name, double value) {
        return EntityV4.Property.newBuilder().setName(name).setValue(EntityV4.Value.newBuilder().setDoubleValue(value).setIndexed(false)).build();
    }

    private static EntityV4.Property makeUnindexedProperty(String name, String value) {
        return EntityV4.Property.newBuilder().setName(name).setValue(EntityV4.Value.newBuilder().setStringValue(value).setIndexed(false)).build();
    }

    static Map<Class<?>, Type<?>> getTypeMap() {
        return typeMap;
    }

    private static void setIndexed(boolean indexed, EntityV4.Value.Builder builder) {
        if (indexed != builder.getIndexed()) {
            builder.setIndexed(indexed);
        }
    }

    private static void setMeaning(int meaning, EntityV4.Value.Builder builder) {
        if (meaning != builder.getMeaning()) {
            builder.setMeaning(meaning);
        }
    }

    private DataTypeTranslator() {
    }

    static {
        typeMap.put(RawValue.class, RAW_VALUE_TYPE);
        typeMap.put(Float.class, new DoubleType());
        typeMap.put(Double.class, new DoubleType());
        typeMap.put(Byte.class, new Int64Type());
        typeMap.put(Short.class, new Int64Type());
        typeMap.put(Integer.class, new Int64Type());
        typeMap.put(Long.class, new Int64Type());
        typeMap.put(Date.class, new DateType());
        typeMap.put(Rating.class, new RatingType());
        typeMap.put(String.class, new StringType());
        typeMap.put(Link.class, new LinkType());
        typeMap.put(ShortBlob.class, new ShortBlobType());
        typeMap.put(Category.class, new CategoryType());
        typeMap.put(PhoneNumber.class, new PhoneNumberType());
        typeMap.put(PostalAddress.class, new PostalAddressType());
        typeMap.put(Email.class, new EmailType());
        typeMap.put(IMHandle.class, new IMHandleType());
        typeMap.put(BlobKey.class, new BlobKeyType());
        typeMap.put(Blob.class, new BlobType());
        typeMap.put(Text.class, new TextType());
        typeMap.put(EmbeddedEntity.class, new EmbeddedEntityType());
        typeMap.put(Boolean.class, new BoolType());
        typeMap.put(User.class, new UserType());
        typeMap.put(Key.class, new KeyType());
        typeMap.put(GeoPt.class, new GeoPtType());
        assert (typeMap.keySet().equals(DataTypeUtils.getSupportedTypes())) : "Warning:  DataTypeUtils and DataTypeTranslator do not agree about supported classes: " + typeMap.keySet() + " vs. " + DataTypeUtils.getSupportedTypes();
        comparableTypeMap = new HashMap();
        comparableTypeMap.put(ComparableByteArray.class, 3);
        comparableTypeMap.put(Long.class, 1);
        comparableTypeMap.put(Double.class, 4);
        comparableTypeMap.put(Boolean.class, 2);
        comparableTypeMap.put(User.class, 8);
        comparableTypeMap.put(Key.class, 12);
        comparableTypeMap.put(GeoPt.class, 5);
    }

    public static final class ComparableByteArray
    implements Comparable<ComparableByteArray> {
        private final byte[] bytes;

        public ComparableByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int compareTo(ComparableByteArray other) {
            byte[] otherBytes = other.bytes;
            for (int i = 0; i < Math.min(this.bytes.length, otherBytes.length); ++i) {
                int v1 = this.bytes[i] & 0xFF;
                int v2 = otherBytes[i] & 0xFF;
                if (v1 == v2) continue;
                return v1 - v2;
            }
            return this.bytes.length - otherBytes.length;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return Arrays.equals(this.bytes, ((ComparableByteArray)obj).bytes);
        }

        public int hashCode() {
            int result = 1;
            for (byte b : this.bytes) {
                result = 31 * result + b;
            }
            return result;
        }
    }

    private static final class IMHandleType
    extends BaseStringType<IMHandle> {
        private IMHandleType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_IM;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((IMHandle)value).toDatastoreString();
        }

        @Override
        protected IMHandle fromDatastoreValue(String datastoreString) {
            return IMHandle.fromDatastoreString(datastoreString);
        }
    }

    private static final class PhoneNumberType
    extends BaseStringType<PhoneNumber> {
        private PhoneNumberType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_PHONENUMBER;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((PhoneNumber)value).getNumber();
        }

        @Override
        protected PhoneNumber fromDatastoreValue(String datastoreString) {
            return new PhoneNumber(datastoreString);
        }
    }

    private static final class PostalAddressType
    extends BaseStringType<PostalAddress> {
        private PostalAddressType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_POSTALADDRESS;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((PostalAddress)value).getAddress();
        }

        @Override
        protected PostalAddress fromDatastoreValue(String datastoreString) {
            return new PostalAddress(datastoreString);
        }
    }

    private static final class EmailType
    extends BaseStringType<Email> {
        private EmailType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_EMAIL;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((Email)value).getEmail();
        }

        @Override
        protected Email fromDatastoreValue(String datastoreString) {
            return new Email(datastoreString);
        }
    }

    private static final class RatingType
    extends BaseInt64Type<Rating> {
        private RatingType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_RATING;
        }

        @Override
        protected Long toDatastoreValue(Object value) {
            return ((Rating)value).getRating();
        }

        @Override
        protected Rating fromDatastoreValue(Long datastoreLong) {
            return new Rating(datastoreLong.intValue());
        }
    }

    private static final class CategoryType
    extends BaseStringType<Category> {
        private CategoryType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.ATOM_CATEGORY;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((Category)value).getCategory();
        }

        @Override
        protected Category fromDatastoreValue(String datastoreString) {
            return new Category(datastoreString);
        }
    }

    private static final class LinkType
    extends BaseStringType<Link> {
        private LinkType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.ATOM_LINK;
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((Link)value).getValue();
        }

        @Override
        protected Link fromDatastoreValue(String datastoreValue) {
            return new Link(datastoreValue);
        }
    }

    private static final class DateType
    extends BaseInt64Type<Date> {
        private DateType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GD_WHEN;
        }

        @Override
        public boolean isType(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.getMeaning() == 0 && this.hasValue(propertyValue);
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasTimestampMicrosecondsValue() || DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE && propertyValue.hasIntegerValue();
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setTimestampMicrosecondsValue(this.toDatastoreValue(value));
            DataTypeTranslator.setIndexed(indexed, builder);
            return builder;
        }

        @Override
        public Date getValue(EntityV4.ValueOrBuilder propertyValue) {
            if (DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE && propertyValue.hasIntegerValue()) {
                return this.fromDatastoreValue(propertyValue.getIntegerValue());
            }
            return this.fromDatastoreValue(propertyValue.getTimestampMicrosecondsValue());
        }

        @Override
        protected Long toDatastoreValue(Object value) {
            return ((Date)value).getTime() * 1000L;
        }

        @Override
        protected Date fromDatastoreValue(Long datastoreValue) {
            return new Date(datastoreValue / 1000L);
        }
    }

    private static final class BlobKeyType
    extends BaseStringType<BlobKey> {
        private BlobKeyType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.BLOBKEY;
        }

        @Override
        public boolean isType(EntityV4.ValueOrBuilder propertyValue) {
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.NO_MEANING && this.hasValue(propertyValue);
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasBlobKeyValue() || DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE && propertyValue.hasStringValue();
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setBlobKeyValue(this.toDatastoreValue(value));
            DataTypeTranslator.setIndexed(indexed, builder);
            return builder;
        }

        @Override
        public BlobKey getValue(EntityV4.ValueOrBuilder propertyValue) {
            if (DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE && propertyValue.hasStringValue()) {
                return this.fromDatastoreValue(propertyValue.getStringValue());
            }
            return this.fromDatastoreValue(propertyValue.getBlobKeyValue());
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((BlobKey)value).getKeyString();
        }

        @Override
        protected BlobKey fromDatastoreValue(String datastoreString) {
            return new BlobKey(datastoreString);
        }
    }

    private static final class TextType
    extends BaseStringType<Text> {
        private TextType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.TEXT;
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            super.toV3Value(value, propertyValue);
            return false;
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            return super.toV4Value(value, false);
        }

        @Override
        protected Text fromDatastoreValue(String datastoreString) {
            return new Text(datastoreString);
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return ((Text)value).getValue();
        }

        @Override
        public ComparableByteArray asComparable(Object value) {
            return null;
        }
    }

    private static final class EmbeddedEntityType
    extends Type<EmbeddedEntity> {
        private EmbeddedEntityType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.ENTITY_PROTO;
        }

        @Override
        public boolean isType(EntityV4.ValueOrBuilder propertyValue) {
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.NO_MEANING && this.hasValue(propertyValue);
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasEntityValue();
        }

        @Override
        public EmbeddedEntity getValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
            proto.mergeFrom(propertyValue.getStringValueAsBytes());
            EmbeddedEntity result = new EmbeddedEntity();
            if (proto.hasKey() && !proto.getKey().getApp().isEmpty()) {
                result.setKey(KeyTranslator.createFromPb(proto.getKey()));
            }
            DataTypeTranslator.extractPropertiesFromPb(proto, result.getPropertyMap());
            return result;
        }

        @Override
        public EmbeddedEntity getValue(EntityV4.ValueOrBuilder propertyValue) {
            EmbeddedEntity result = new EmbeddedEntity();
            EntityV4.Entity proto = propertyValue.getEntityValue();
            if (proto.hasKey()) {
                result.setKey(DataTypeTranslator.toKey(proto.getKey()));
            }
            DataTypeTranslator.extractPropertiesFromPb(proto, false, result.getPropertyMap());
            return result;
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            EmbeddedEntity structProp = (EmbeddedEntity)value;
            OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
            if (structProp.getKey() != null) {
                proto.setKey(KeyTranslator.convertToPb(structProp.getKey()));
            }
            DataTypeTranslator.addPropertiesToPb(structProp.getPropertyMap(), proto);
            propertyValue.setStringValueAsBytes(proto.toByteArray());
            return false;
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EmbeddedEntity structProp = (EmbeddedEntity)value;
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            EntityV4.Entity.Builder proto = builder.getEntityValueBuilder();
            if (structProp.getKey() != null) {
                proto.setKey(DataTypeTranslator.toV4Key(structProp.getKey()));
            }
            DataTypeTranslator.addPropertiesToPb(structProp.getPropertyMap(), proto);
            builder.setIndexed(false);
            return builder;
        }

        @Override
        public Comparable<?> asComparable(Object value) {
            return null;
        }
    }

    private static class ShortBlobType
    extends BaseBlobType<ShortBlob> {
        private ShortBlobType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.BYTESTRING;
        }

        @Override
        public boolean isType(EntityV4.ValueOrBuilder propertyValue) {
            if (!this.hasValue(propertyValue)) {
                return false;
            }
            if (propertyValue.getIndexed()) {
                return DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.NO_MEANING;
            }
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == this.getV3Meaning();
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = super.toV4Value(value, indexed);
            if (!indexed) {
                builder.setMeaning(this.getV3Meaning().getValue());
            }
            return builder;
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasBlobValue() || DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE && propertyValue.hasStringValue();
        }

        @Override
        public ShortBlob getValue(EntityV4.ValueOrBuilder propertyValue) {
            if (DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.INDEX_VALUE && propertyValue.hasStringValue()) {
                return this.fromDatastoreValue(propertyValue.getStringValueBytes().toByteArray());
            }
            return this.fromDatastoreValue(propertyValue.getBlobValue().toByteArray());
        }

        @Override
        protected byte[] toDatastoreValue(Object value) {
            return ((ShortBlob)value).getBytes();
        }

        @Override
        protected ShortBlob fromDatastoreValue(byte[] datastoreValue) {
            return new ShortBlob(datastoreValue);
        }

        @Override
        public boolean isIndexable() {
            return true;
        }
    }

    private static class BlobType
    extends BaseBlobType<Blob> {
        private BlobType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.BLOB;
        }

        @Override
        public boolean isType(EntityV4.ValueOrBuilder propertyValue) {
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == OnestoreEntity.Property.Meaning.NO_MEANING && !propertyValue.getIndexed() && this.hasValue(propertyValue);
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasBlobValue();
        }

        @Override
        public Blob getValue(EntityV4.ValueOrBuilder propertyValue) {
            return this.fromDatastoreValue(propertyValue.getBlobValue().toByteArray());
        }

        @Override
        protected Blob fromDatastoreValue(byte[] datastoreValue) {
            return new Blob(datastoreValue);
        }

        @Override
        protected byte[] toDatastoreValue(Object value) {
            return ((Blob)value).getBytes();
        }

        @Override
        public boolean isIndexable() {
            return false;
        }
    }

    private static final class KeyType
    extends Type<Key> {
        private KeyType() {
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.Reference keyRef = KeyTranslator.convertToPb((Key)value);
            propertyValue.setReferenceValue(KeyType.toReferenceValue(keyRef));
            return true;
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setKeyValue(DataTypeTranslator.toV4Key((Key)value));
            DataTypeTranslator.setIndexed(indexed, builder);
            return builder;
        }

        @Override
        public Key getValue(OnestoreEntity.PropertyValue propertyValue) {
            return KeyTranslator.createFromPb(KeyType.toReference(propertyValue.getReferenceValue()));
        }

        @Override
        public Key getValue(EntityV4.ValueOrBuilder propertyValue) {
            return DataTypeTranslator.toKey(propertyValue.getKeyValue());
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasReferenceValue();
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasKeyValue();
        }

        public Key asComparable(Object value) {
            return (Key)value;
        }

        private static OnestoreEntity.PropertyValue.ReferenceValue toReferenceValue(OnestoreEntity.Reference keyRef) {
            OnestoreEntity.PropertyValue.ReferenceValue refValue = new OnestoreEntity.PropertyValue.ReferenceValue();
            refValue.setApp(keyRef.getApp());
            if (keyRef.hasNameSpace()) {
                refValue.setNameSpace(keyRef.getNameSpace());
            }
            OnestoreEntity.Path path = keyRef.getPath();
            for (OnestoreEntity.Path.Element element : path.elements()) {
                OnestoreEntity.PropertyValue.ReferenceValuePathElement newElement = new OnestoreEntity.PropertyValue.ReferenceValuePathElement();
                newElement.setType(element.getType());
                if (element.hasName()) {
                    newElement.setName(element.getName());
                }
                if (element.hasId()) {
                    newElement.setId(element.getId());
                }
                refValue.addPathElement(newElement);
            }
            return refValue;
        }

        private static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue.ReferenceValue refValue) {
            OnestoreEntity.Reference reference = new OnestoreEntity.Reference();
            reference.setApp(refValue.getApp());
            if (refValue.hasNameSpace()) {
                reference.setNameSpace(refValue.getNameSpace());
            }
            OnestoreEntity.Path path = new OnestoreEntity.Path();
            for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : refValue.pathElements()) {
                OnestoreEntity.Path.Element newElement = new OnestoreEntity.Path.Element();
                newElement.setType(element.getType());
                if (element.hasName()) {
                    newElement.setName(element.getName());
                }
                if (element.hasId()) {
                    newElement.setId(element.getId());
                }
                path.addElement(newElement);
            }
            reference.setPath(path);
            return reference;
        }
    }

    private static class GeoPtType
    extends Type<GeoPt> {
        public static final int MEANING_PREDEFINED_ENTITY_GEORSS_POINT = 9;
        public static final String PROPERTY_NAME_X = "x";
        public static final String PROPERTY_NAME_Y = "y";

        private GeoPtType() {
        }

        @Override
        public boolean isType(EntityV4.ValueOrBuilder propertyValue) {
            if (propertyValue.hasGeoPointValue() && !propertyValue.hasMeaning()) {
                return true;
            }
            return propertyValue.hasEntityValue() && propertyValue.getMeaning() == 9;
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            GeoPt geoPt = (GeoPt)value;
            OnestoreEntity.PropertyValue.PointValue pv = new OnestoreEntity.PropertyValue.PointValue().setX(geoPt.getLatitude()).setY(geoPt.getLongitude());
            propertyValue.setPointValue(pv);
            return true;
        }

        @Override
        public final EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            GeoPt geoPt = (GeoPt)value;
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.getEntityValueBuilder().addProperty(DataTypeTranslator.makeUnindexedProperty(PROPERTY_NAME_X, geoPt.getLatitude())).addProperty(DataTypeTranslator.makeUnindexedProperty(PROPERTY_NAME_Y, geoPt.getLongitude())).build();
            DataTypeTranslator.setIndexed(indexed, builder);
            DataTypeTranslator.setMeaning(9, builder);
            return builder;
        }

        @Override
        public GeoPt getValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.PropertyValue.PointValue pv = propertyValue.getPointValue();
            return new GeoPt((float)pv.getX(), (float)pv.getY());
        }

        @Override
        public GeoPt getValue(EntityV4.ValueOrBuilder propertyValue) {
            double x = 0.0;
            double y = 0.0;
            for (EntityV4.PropertyOrBuilder propertyOrBuilder : propertyValue.getEntityValueOrBuilder().getPropertyOrBuilderList()) {
                if (propertyOrBuilder.getName().equals(PROPERTY_NAME_X)) {
                    x = propertyOrBuilder.getValueOrBuilder().getDoubleValue();
                    continue;
                }
                if (!propertyOrBuilder.getName().equals(PROPERTY_NAME_Y)) continue;
                y = propertyOrBuilder.getValueOrBuilder().getDoubleValue();
            }
            if (propertyValue.hasGeoPointValue()) {
                x = propertyValue.getGeoPointValue().getLatitude();
                y = propertyValue.getGeoPointValue().getLongitude();
            }
            return new GeoPt((float)x, (float)y);
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasPointValue();
        }

        @Override
        public final boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasGeoPointValue() || propertyValue.hasEntityValue();
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.GEORSS_POINT;
        }

        @Override
        public final Comparable<GeoPt> asComparable(Object value) {
            return (GeoPt)value;
        }
    }

    private static final class UserType
    extends BasePredefinedEntityType<User> {
        public static final int MEANING_PREDEFINED_ENTITY_USER = 20;
        public static final String PROPERTY_NAME_EMAIL = "email";
        public static final String PROPERTY_NAME_AUTH_DOMAIN = "auth_domain";
        public static final String PROPERTY_NAME_USER_ID = "user_id";

        private UserType() {
        }

        @Override
        public int getV4Meaning() {
            return 20;
        }

        @Override
        public EntityV4.Entity getEntity(Object value) {
            User user = (User)value;
            EntityV4.Entity.Builder builder = EntityV4.Entity.newBuilder();
            builder.addProperty(DataTypeTranslator.makeUnindexedProperty(PROPERTY_NAME_EMAIL, user.getEmail()));
            builder.addProperty(DataTypeTranslator.makeUnindexedProperty(PROPERTY_NAME_AUTH_DOMAIN, user.getAuthDomain()));
            if (user.getUserId() != null) {
                builder.addProperty(DataTypeTranslator.makeUnindexedProperty(PROPERTY_NAME_USER_ID, user.getUserId()));
            }
            return builder.build();
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            User user = (User)value;
            OnestoreEntity.PropertyValue.UserValue userValue = new OnestoreEntity.PropertyValue.UserValue();
            userValue.setEmail(user.getEmail());
            userValue.setAuthDomain(user.getAuthDomain());
            if (user.getUserId() != null) {
                userValue.setObfuscatedGaiaid(user.getUserId());
            }
            userValue.setGaiaid(0L);
            propertyValue.setUserValue(userValue);
            return true;
        }

        @Override
        public User getValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.PropertyValue.UserValue userValue = propertyValue.getUserValue();
            String userId = userValue.hasObfuscatedGaiaid() ? userValue.getObfuscatedGaiaid() : null;
            return new User(userValue.getEmail(), userValue.getAuthDomain(), userId);
        }

        @Override
        public User getValue(EntityV4.ValueOrBuilder propertyValue) {
            String email = "";
            String authDomain = "";
            String userId = null;
            for (EntityV4.PropertyOrBuilder propertyOrBuilder : propertyValue.getEntityValueOrBuilder().getPropertyOrBuilderList()) {
                if (propertyOrBuilder.getName().equals(PROPERTY_NAME_EMAIL)) {
                    email = propertyOrBuilder.getValueOrBuilder().getStringValue();
                    continue;
                }
                if (propertyOrBuilder.getName().equals(PROPERTY_NAME_AUTH_DOMAIN)) {
                    authDomain = propertyOrBuilder.getValueOrBuilder().getStringValue();
                    continue;
                }
                if (!propertyOrBuilder.getName().equals(PROPERTY_NAME_USER_ID)) continue;
                userId = propertyOrBuilder.getValueOrBuilder().getStringValue();
            }
            return new User(email, authDomain, userId);
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasUserValue();
        }

        @Override
        public final Comparable<User> asComparable(Object value) {
            return (User)value;
        }
    }

    private static final class BoolType
    extends Type<Boolean> {
        private BoolType() {
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setBooleanValue((Boolean)value);
            return true;
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setBooleanValue((Boolean)value);
            DataTypeTranslator.setIndexed(indexed, builder);
            return builder;
        }

        @Override
        public Boolean getValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.isBooleanValue();
        }

        @Override
        public Boolean getValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.getBooleanValue();
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasBooleanValue();
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasBooleanValue();
        }

        public Boolean asComparable(Object value) {
            return (Boolean)value;
        }
    }

    private static final class DoubleType
    extends Type<Double> {
        private DoubleType() {
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setDoubleValue(((Number)value).doubleValue());
            return true;
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setDoubleValue(((Number)value).doubleValue());
            DataTypeTranslator.setIndexed(indexed, builder);
            return builder;
        }

        @Override
        public Double getValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.getDoubleValue();
        }

        @Override
        public Double getValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.getDoubleValue();
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasDoubleValue();
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasDoubleValue();
        }

        public Double asComparable(Object value) {
            return ((Number)value).doubleValue();
        }
    }

    private static final class Int64Type
    extends BaseInt64Type<Long> {
        private Int64Type() {
        }

        @Override
        protected Long toDatastoreValue(Object value) {
            return ((Number)value).longValue();
        }

        @Override
        protected Long fromDatastoreValue(Long datastoreValue) {
            return datastoreValue;
        }
    }

    private static final class StringType
    extends BaseStringType<String> {
        private StringType() {
        }

        @Override
        protected String toDatastoreValue(Object value) {
            return value.toString();
        }

        @Override
        protected String fromDatastoreValue(String datastoreValue) {
            return datastoreValue;
        }
    }

    private static final class RawValueType
    extends Type<RawValue> {
        private RawValueType() {
        }

        @Override
        public OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.INDEX_VALUE;
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return true;
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return true;
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RawValue getValue(OnestoreEntity.PropertyValue propertyValue) {
            return new RawValue(propertyValue);
        }

        @Override
        public RawValue getValue(EntityV4.ValueOrBuilder propertyValue) {
            EntityV4.Value value = null;
            value = propertyValue instanceof EntityV4.Value ? (EntityV4.Value)propertyValue : ((EntityV4.Value.Builder)propertyValue).build();
            return new RawValue(value);
        }

        @Override
        public Comparable<?> asComparable(Object value) {
            if ((value = ((RawValue)value).getValue()) instanceof byte[]) {
                return new ComparableByteArray((byte[])value);
            }
            return (Comparable)value;
        }
    }

    private static abstract class BaseInt64Type<T>
    extends BaseVariantType<Long, T> {
        private BaseInt64Type() {
        }

        @Override
        public final boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setInt64Value((Long)this.toDatastoreValue(value));
            return true;
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setIntegerValue((Long)this.toDatastoreValue(value));
            DataTypeTranslator.setIndexed(indexed, builder);
            DataTypeTranslator.setMeaning(this.getV3Meaning().getValue(), builder);
            return builder;
        }

        @Override
        public T getValue(OnestoreEntity.PropertyValue propertyValue) {
            return this.fromDatastoreValue(propertyValue.getInt64Value());
        }

        @Override
        public T getValue(EntityV4.ValueOrBuilder propertyValue) {
            return this.fromDatastoreValue(propertyValue.getIntegerValue());
        }

        @Override
        public boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasInt64Value();
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasIntegerValue();
        }

        public Long asComparable(Object value) {
            return (Long)this.toDatastoreValue(value);
        }
    }

    private static abstract class BasePredefinedEntityType<T>
    extends Type<T> {
        private BasePredefinedEntityType() {
        }

        protected abstract int getV4Meaning();

        protected abstract EntityV4.Entity getEntity(Object var1);

        @Override
        public final boolean isType(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.getMeaning() == this.getV4Meaning() && this.hasValue(propertyValue);
        }

        @Override
        public final boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasEntityValue();
        }

        @Override
        public final EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setEntityValue(this.getEntity(value));
            DataTypeTranslator.setIndexed(indexed, builder);
            DataTypeTranslator.setMeaning(this.getV4Meaning(), builder);
            return builder;
        }
    }

    private static abstract class BaseBlobType<T>
    extends BaseVariantType<byte[], T> {
        private BaseBlobType() {
        }

        protected abstract boolean isIndexable();

        @Override
        public final boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public final boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setStringValueAsBytes((byte[])this.toDatastoreValue(value));
            return this.isIndexable();
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setBlobValue(ByteString.copyFrom((byte[])this.toDatastoreValue(value)));
            DataTypeTranslator.setIndexed(indexed && this.isIndexable(), builder);
            return builder;
        }

        @Override
        public final T getValue(OnestoreEntity.PropertyValue propertyValue) {
            return this.fromDatastoreValue(propertyValue.getStringValueAsBytes());
        }

        public final ComparableByteArray asComparable(Object value) {
            return this.isIndexable() ? new ComparableByteArray((byte[])this.toDatastoreValue(value)) : null;
        }
    }

    private static abstract class BaseStringType<T>
    extends BaseVariantType<String, T> {
        private BaseStringType() {
        }

        @Override
        public boolean toV3Value(Object value, OnestoreEntity.PropertyValue propertyValue) {
            propertyValue.setStringValue((String)this.toDatastoreValue(value));
            return true;
        }

        @Override
        public EntityV4.Value.Builder toV4Value(Object value, boolean indexed) {
            EntityV4.Value.Builder builder = EntityV4.Value.newBuilder();
            builder.setStringValue((String)this.toDatastoreValue(value));
            DataTypeTranslator.setIndexed(indexed, builder);
            DataTypeTranslator.setMeaning(this.getV3Meaning().getValue(), builder);
            return builder;
        }

        @Override
        public final T getValue(OnestoreEntity.PropertyValue propertyValue) {
            return this.fromDatastoreValue(propertyValue.getStringValue());
        }

        @Override
        public T getValue(EntityV4.ValueOrBuilder propertyValue) {
            return this.fromDatastoreValue(propertyValue.getStringValue());
        }

        @Override
        public final boolean hasValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public boolean hasValue(EntityV4.ValueOrBuilder propertyValue) {
            return propertyValue.hasStringValue();
        }

        public ComparableByteArray asComparable(Object value) {
            return new ComparableByteArray(ProtocolSupport.toBytesUtf8((String)this.toDatastoreValue(value)));
        }
    }

    private static abstract class BaseVariantType<S, T>
    extends Type<T> {
        private BaseVariantType() {
        }

        protected abstract S toDatastoreValue(Object var1);

        protected abstract T fromDatastoreValue(S var1);
    }

    static abstract class Type<T> {
        Type() {
        }

        public final boolean isType(OnestoreEntity.Property.Meaning meaning, OnestoreEntity.PropertyValue propertyValue) {
            return meaning == this.getV3Meaning() && this.hasValue(propertyValue);
        }

        public boolean isType(EntityV4.ValueOrBuilder propertyValue) {
            return DataTypeTranslator.getV3MeaningOf(propertyValue) == this.getV3Meaning() && this.hasValue(propertyValue);
        }

        public abstract Comparable<?> asComparable(Object var1);

        public abstract boolean toV3Value(Object var1, OnestoreEntity.PropertyValue var2);

        public abstract EntityV4.Value.Builder toV4Value(Object var1, boolean var2);

        public abstract T getValue(OnestoreEntity.PropertyValue var1);

        public abstract T getValue(EntityV4.ValueOrBuilder var1);

        public abstract boolean hasValue(OnestoreEntity.PropertyValue var1);

        public abstract boolean hasValue(EntityV4.ValueOrBuilder var1);

        protected OnestoreEntity.Property.Meaning getV3Meaning() {
            return OnestoreEntity.Property.Meaning.NO_MEANING;
        }
    }
}

