/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Asset;
import com.google.appengine.api.conversion.Conversion;
import com.google.appengine.api.conversion.ConversionErrorCode;
import com.google.appengine.api.conversion.ConversionResult;
import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.api.conversion.Document;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConversionHelper {
    ConversionHelper() {
    }

    static ConversionServicePb.ConversionRequest toConversionRequestProto(List<Conversion> conversions) {
        if (conversions.size() == 0) {
            throw new IllegalArgumentException("At least one conversion is required in the request");
        }
        if (conversions.size() > 10) {
            throw new IllegalArgumentException(String.format("At most %d conversions are allowed in one request.", 10));
        }
        ConversionServicePb.ConversionRequest.Builder request = ConversionServicePb.ConversionRequest.newBuilder();
        for (Conversion conversion : conversions) {
            request.addConversion(ConversionHelper.toConversionInputProto(conversion));
        }
        return request.build();
    }

    static ConversionServicePb.ConversionInput toConversionInputProto(Conversion conversion) {
        return ConversionServicePb.ConversionInput.newBuilder().setInput(ConversionHelper.toDocumentInfoProto(conversion.getInputDoc())).setOutputMimeType(conversion.getOutputMimeType()).build();
    }

    static ConversionServicePb.ConversionOutput toConversioOutputProto(ConversionResult result) {
        if (result.success()) {
            return ConversionServicePb.ConversionOutput.newBuilder().setErrorCode(ConversionServicePb.ConversionServiceError.ErrorCode.OK).setOutput(ConversionHelper.toDocumentInfoProto(result.getOutputDoc())).build();
        }
        return ConversionServicePb.ConversionOutput.newBuilder().setErrorCode(ConversionErrorCode.enumToProto(result.getErrorCode())).build();
    }

    static ConversionServicePb.DocumentInfo toDocumentInfoProto(Document document) {
        ConversionServicePb.DocumentInfo.Builder documentInfo = ConversionServicePb.DocumentInfo.newBuilder();
        for (Asset asset : document.getAssets()) {
            documentInfo.addAsset(ConversionHelper.toAssetInfoProto(asset));
        }
        return documentInfo.build();
    }

    static ConversionServicePb.AssetInfo toAssetInfoProto(Asset asset) {
        return ConversionServicePb.AssetInfo.newBuilder().setMimeType(asset.getMimeType()).setData(ByteString.copyFrom(asset.getData())).setName(asset.getName()).build();
    }

    static ConversionResult fromConversionOutputProto(ConversionServicePb.ConversionOutput result) {
        if (result.getErrorCode() == ConversionServicePb.ConversionServiceError.ErrorCode.OK) {
            return new ConversionResult(ConversionHelper.fromDocumentInfoProto(result.getOutput()));
        }
        return new ConversionResult(ConversionErrorCode.intToEnum(result.getErrorCode().getNumber()));
    }

    static Document fromDocumentInfoProto(ConversionServicePb.DocumentInfo document) {
        ArrayList<Asset> assets = Lists.newArrayList();
        for (ConversionServicePb.AssetInfo asset : document.getAssetList()) {
            assets.add(ConversionHelper.fromAssetInfoProto(asset));
        }
        Document doc = new Document(assets);
        return doc;
    }

    static Asset fromAssetInfoProto(ConversionServicePb.AssetInfo asset) {
        return new Asset(asset.getData().toByteArray(), asset.getMimeType(), asset.getName());
    }

    static byte[] validateAssetData(byte[] data) {
        Preconditions.checkNotNull(data);
        if (data.length > 0xA00000) {
            throw new IllegalArgumentException(String.format("Each conversion should not be over %d bytes.", 0xA00000));
        }
        return data;
    }

    static List<Asset> validateAssets(List<Asset> assets) {
        Preconditions.checkNotNull(assets);
        Preconditions.checkArgument(assets.size() > 0, "The assets list should not be empty");
        int size = 0;
        for (Asset asset : assets) {
            size += asset.getData().length;
        }
        if (size > 0xA00000) {
            throw new IllegalArgumentException(String.format("Each conversion should not be over %d bytes.", 0xA00000));
        }
        return assets;
    }

    static Document validateInputDoc(Document document) {
        Preconditions.checkNotNull(document);
        List<Asset> assets = document.getAssets();
        for (Asset asset : assets.subList(1, assets.size())) {
            if (asset.getName() != null) continue;
            throw new IllegalArgumentException("Additional assets must be set with name");
        }
        return document;
    }
}

