/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DebugPortManager;
import com.android.ddmlib.Device;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class ChunkHandler {
    public static final int CHUNK_HEADER_LEN = 8;
    public static final ByteOrder CHUNK_ORDER = ByteOrder.BIG_ENDIAN;
    public static final int CHUNK_FAIL = ChunkHandler.type("FAIL");

    ChunkHandler() {
    }

    abstract void clientReady(Client var1) throws IOException;

    abstract void clientDisconnected(Client var1);

    abstract void handleChunk(Client var1, int var2, ByteBuffer var3, boolean var4, int var5);

    protected void handleUnknownChunk(Client client, int type, ByteBuffer data, boolean isReply, int msgId) {
        if (type == CHUNK_FAIL) {
            int errorCode = data.getInt();
            int msgLen = data.getInt();
            String msg = ChunkHandler.getString(data, msgLen);
            Log.w("ddms", "WARNING: failure code=" + errorCode + " msg=" + msg);
        } else {
            Log.w("ddms", "WARNING: received unknown chunk " + ChunkHandler.name(type) + ": len=" + data.limit() + ", reply=" + isReply + ", msgId=0x" + Integer.toHexString(msgId));
        }
        Log.w("ddms", "         client " + client + ", handler " + this);
    }

    static String getString(ByteBuffer buf, int len) {
        char[] data = new char[len];
        for (int i = 0; i < len; ++i) {
            data[i] = buf.getChar();
        }
        return new String(data);
    }

    static void putString(ByteBuffer buf, String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            buf.putChar(str.charAt(i));
        }
    }

    static int type(String typeName) {
        int val = 0;
        if (typeName.length() != 4) {
            Log.e("ddms", "Type name must be 4 letter long");
            throw new RuntimeException("Type name must be 4 letter long");
        }
        for (int i = 0; i < 4; ++i) {
            val <<= 8;
            val |= (byte)typeName.charAt(i);
        }
        return val;
    }

    static String name(int type) {
        char[] ascii = new char[]{(char)(type >> 24 & 0xFF), (char)(type >> 16 & 0xFF), (char)(type >> 8 & 0xFF), (char)(type & 0xFF)};
        return new String(ascii);
    }

    static ByteBuffer allocBuffer(int maxChunkLen) {
        ByteBuffer buf = ByteBuffer.allocate(19 + maxChunkLen);
        buf.order(CHUNK_ORDER);
        return buf;
    }

    static ByteBuffer getChunkDataBuf(ByteBuffer jdwpBuf) {
        assert (jdwpBuf.position() == 0);
        jdwpBuf.position(19);
        ByteBuffer slice = jdwpBuf.slice();
        slice.order(CHUNK_ORDER);
        jdwpBuf.position(0);
        return slice;
    }

    static void finishChunkPacket(JdwpPacket packet, int type, int chunkLen) {
        ByteBuffer buf = packet.getPayload();
        buf.putInt(0, type);
        buf.putInt(4, chunkLen);
        packet.finishPacket(8 + chunkLen);
    }

    protected static Client checkDebuggerPortForAppName(Client client, String appName) {
        DeviceMonitor deviceMonitor;
        AndroidDebugBridge bridge;
        Device device;
        int newPort;
        DebugPortManager.IDebugPortProvider provider = DebugPortManager.getProvider();
        if (provider != null && (newPort = provider.getPort(device = client.getDeviceImpl(), appName)) != -1 && newPort != client.getDebuggerListenPort() && (bridge = AndroidDebugBridge.getBridge()) != null && (deviceMonitor = bridge.getDeviceMonitor()) != null) {
            deviceMonitor.addClientToDropAndReopen(client, newPort);
            client = null;
        }
        return client;
    }
}

