package com.cybelia.sandra.web.taglib;


import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class StepTagLib extends TagSupport {

    private static final long serialVersionUID = 1L;

    private Etape etape;

    public void setEtape(Etape etape) {
        this.etape = etape;
    }

    private String method;

    public void setMethod(String method) {
        this.method = method;
    }

    private double round(double value) {
        return Math.round(value * 10.0) / 10.0;
    }

    @Override
    public int doStartTag() throws JspException {
        try {
            JspWriter out = pageContext.getOut();

            if (method.equalsIgnoreCase("quantity")) {
                int quantityTotal = 0;
                if (etape != null) {
                    List<LigneProduit> ligneProduits = etape.getProduits();
                    for (LigneProduit ligneProduit : ligneProduits) {
                        quantityTotal = quantityTotal + ligneProduit.getQuantiteACharger();
                    }
                    // Arrondit à 1 nombre apres la virgule
                    Double quantityTotalInTonne = new Double(quantityTotal) / 1000;
                    quantityTotalInTonne = round(quantityTotalInTonne);
                    // Exprimé en Tonne
                    out.print(quantityTotalInTonne + "T ");
                }
            } else {
                out.print("??error??");
            }

        } catch (Exception e) {
            throw new JspException(e);
        }

        return SKIP_BODY;
    }
}
