package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.web.action.ApplicationSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.nuiton.topia.taas.entities.TaasUser;

/**
 * Permet grâce à la méthode authorized() d'afficher ou non la page ou
 * le body.
 */
public abstract class SecurityTagLib extends BodyTagSupport {

    private static final long serialVersionUID = 1L;

    protected transient Log log;

    public Log getLog() {
        if (log == null) {
            log = LogFactory.getLog(getClass());
        }
        return log;
    }

    protected boolean authorized = false;

    protected boolean inverse;

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    @Override
    public int doStartTag() throws JspException {
        try {
            authorized = authorized() ^ inverse;
            return EVAL_BODY_BUFFERED;

        } catch (Exception e) {
            throw new JspException(e);
        }
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            // Affichage du body
            if (authorized && bodyContent != null) {
                bodyContent.writeOut(pageContext.getOut());
            }

            // Affichage de la page
            if (!authorized && bodyContent == null) {
                SecurityException exception = new SecurityException();
                pageContext.getRequest().setAttribute(Globals.EXCEPTION_KEY, exception);

                pageContext.forward("/appli/error.do");
                return SKIP_PAGE;
            }

            return EVAL_PAGE;

        } catch (Exception e) {
            throw new JspException(e);
        }
    }

    /**
     * Permet authorisé ou non la page ou le body.
     *
     * @return <code>true</code> lorsque l'on autorise, <ocde>false</code> autrement.
     * @throws Exception if any pb ?
     */
    public abstract boolean authorized() throws Exception;

    protected TaasUser getUser() throws Exception {
        ApplicationSession applicationSession = ApplicationSession.get(pageContext.getSession());
        return applicationSession.getUser();
    }
}
