package com.cybelia.sandra.web.taglib;

import java.util.Collection;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;

/**
 * Permet de vérifier si l'utilisateur contient un principal particulier
 * <p/>
 * Exemple d'utilisation :
 * <code>
 * <s:principal name="superadmin"/>
 * </code>
 */
public class PrincipalTagLib extends SecurityTagLib {

    private static final long serialVersionUID = 1L;

    protected String name;

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean authorized() throws Exception {
        TaasUser user = getUser();

        Collection<TaasPrincipal> principals = user.getPrincipals();
        for (TaasPrincipal principal : principals) {
            String principalName = principal.getName();
            String[] list = name.split(",");
            for (String value : list) {
                if (principalName.equals(value.trim()) || principalName.equals("admin")) {
                    return true;
                }
            }
        }

        return false;
    }
}
