package com.cybelia.sandra.web.taglib;

import com.cybelia.sandra.web.action.ApplicationSession;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;

public class NamingTagLib extends TagSupport {

    private static final long serialVersionUID = 1L;

    private String topiaId;

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    @Override
    public int doStartTag() throws JspException {
        if (topiaId != null && !"".equals(topiaId)) {
            try {
                HttpSession session = pageContext.getSession();
                ApplicationSession applicationSession = ApplicationSession.get(session);

                Class<? extends TopiaEntity> klass = TopiaId.getClassName(topiaId);
                Map<String, String> naming = applicationSession.getNaming(klass);

                if (naming != null) {
                    String value = naming.get(topiaId);
                    JspWriter out = pageContext.getOut();
                    out.print(value);
                }
            } catch (Exception e) {
                throw new JspException(e);
            }
        }

        return SKIP_BODY;
    }

    @Override
    public void release() {
        super.release();
        //todo should clean topiaId since, this is a stateless mecanism ?
    }
}
