package com.cybelia.sandra.web.taglib;

import java.util.Collection;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.jaas.TaasPermission;

/**
 * Permet de vérifier si l'utilisateur contient une authorisation. Ceci permet
 * de tester seulement un certain nombre de cas mais pas l'ensemble des cas de
 * JAAS.
 * <p/>
 * Exemple d'utilisation :
 * <code>
 * <s:authorization expression="com.cybelia.sandra.entities.Societe#*" actions="CREATE">
 * <html:link styleClass="button add" action="/appli/ref/societe/view.do"><c:out value="common.new"/></html:link>
 * </s:authorization>
 * </code>
 */
public class AuthorizationTagLib extends SecurityTagLib {

    private static final long serialVersionUID = 1L;

    protected String actions;

    public void setActions(String actions) {
        this.actions = actions;
    }

    protected String expression;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean authorized() throws Exception {
        TaasUser user = getUser();
        TaasPermission permission = new TaasPermission(expression, TaasUtil.actionsString2Int(actions));

        Collection<TaasPrincipal> principals = user.getPrincipals();
        for (TaasPrincipal principal : principals) {
            Collection<TaasAuthorization> authorizations = principal.getAuthorizations();
            for (TaasAuthorization authorization : authorizations) {
                TaasPermission other = new TaasPermission(authorization);
                if (other.implies(permission)) {
                    return true;
                }
            }
        }

        return false;
    }

}
