package com.cybelia.sandra.web.converter;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.Converter;
import org.apache.log4j.Logger;

/**
 * Converter for java.util.Date
 * <p/>
 * Because struts populate action form use commonbeanutils, and common beans doesn't have a
 * converter for java.util.Date. You need to create specific converter.
 */
public class DateConverter implements Converter {

    private static final Logger log = Logger.getLogger(DateConverter.class);

    private Object defaultValue = null;

    public DateConverter() {
        this.defaultValue = null;
    }

    public DateConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            return (defaultValue);
        }

        if (value instanceof Date) {
            return (value);
        }

        if (value.toString().equals("")) {
            return defaultValue;
        }

        // pattern of date in config file
        String pattern = "dd/MM/yy";
        try {
            // instance of SimpleDateFormat with this pattern
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.FRENCH);
            // parse date
            Date date = dateFormat.parse(value.toString());
            return date;
        } catch (Exception e) {
            log.warn("Unable to convert " + value + " into Date format. Pattern : " + pattern, e);
            return defaultValue;
        }
    }
}
