package com.cybelia.sandra.web.action.user;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.displaytag.AbstractPaginedListExtractor;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.displaytag.properties.SortOrderEnum;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

public class UserAction extends CommonMappingDispatchAction {

    public ActionForward logout(ActionMapping mapping, ActionForm form,
                                HttpServletRequest request, HttpServletResponse response,
                                ApplicationSession applicationSession, ServiceWeb serviceWeb)
            throws Exception {

        HttpSession session = request.getSession();
        session.invalidate();
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward admin(ActionMapping mapping, ActionForm form,
                               HttpServletRequest request, HttpServletResponse response,
                               ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward list(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        UserPaginedListExtractor extractor = new UserPaginedListExtractor(serviceWeb);
        PaginedListImpl<TaasUser> list = new PaginedListImpl<TaasUser>(extractor);
        list.setSortCriterion("lastConnectionDate");
        list.setSortDirection(SortOrderEnum.DESCENDING);
        request.setAttribute("users", list.fromRequest(request).acquireData(request));

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward listCamion(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        CamionSearchForm searchForm = (CamionSearchForm)form;

        UserCamionIndicateursPaginedListExtractor extractor = new UserCamionIndicateursPaginedListExtractor(serviceWeb, searchForm.getSociety(), !searchForm.isShowInactif());
        PaginedListImpl<Camion> list = new PaginedListImpl<Camion>(extractor);
        list.setSortCriterion("userIndicateurs.lastSynch");
        list.setSortDirection(SortOrderEnum.DESCENDING);
        request.setAttribute("camions", list.fromRequest(request).acquireData(request));

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward setInactifCamion(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        String topiaId = request.getParameter("topiaId");

        serviceWeb.setActifCamion(null, topiaId, false);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward setActifCamion(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        String topiaId = request.getParameter("topiaId");

        serviceWeb.setActifCamion(null, topiaId, true);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward sendUserActivityEmail(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ApplicationSession applicationSession, final ServiceWeb serviceWeb) throws Exception {

        serviceWeb.sendStatNotification();

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward view(ActionMapping mapping, UserForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        String topiaId = request.getParameter("topiaId");

        if (StringUtils.isNotBlank(topiaId)) {

            String profilType = form.getProfilType();

            // get user to form
            TaasUser user = serviceWeb.getSafeUser(null, topiaId);
            form.fromBean(user);

            if (StringUtils.isBlank(form.getProfilType())) {
                // no profile from user (take back the one from form)
                form.setProfilType(profilType);
            }

            if (StringUtils.isNotBlank(form.getProfilType())) {
                // build profil values and put them in request['profilValues'])
                buildProfilValues(request, applicationSession, form.getProfilType(), form.getProfils());
            }
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }


    public ActionForward save(ActionMapping mapping, UserForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        TaasUser user = serviceWeb.saveUser(null, form.toBean(), form.getIsWeb(), form.getIsAdmin(), form.getProfilType());
        form.setTopiaId(user.getTopiaId());
        // clean user naming cache
        ApplicationSession.Cache.User.clear(applicationSession);
        ApplicationSession.Cache.UserIndicateurs.clear(applicationSession);
        return mapping.findForward(SUCCESS_FORWARD);
    }


    public ActionForward addProfil(ActionMapping mapping, UserForm form,
                                   HttpServletRequest request, HttpServletResponse response,
                                   ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        String[] selectedProfils = form.getSelectedProfils();
        if (selectedProfils != null) {
            String topiaId = form.getTopiaId();
            for (String profil : selectedProfils) {
                serviceWeb.addProfilUser(null, topiaId, profil);
                form.addProfils(profil);
            }
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward deleteProfil(ActionMapping mapping, UserForm form,
                                      HttpServletRequest request, HttpServletResponse response,
                                      ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        String[] selectedProfils = form.getSelectedProfils();
        if (selectedProfils != null) {
            String topiaId = form.getTopiaId();
            for (String profil : selectedProfils) {
                serviceWeb.deleteProfilUser(null, topiaId, profil);
                form.removeProfils(profil);
            }
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    @SuppressWarnings({"unchecked"})
    protected void buildProfilValues(HttpServletRequest request, ApplicationSession applicationSession,
                                     String profilType, List<String> profils) throws Exception {
        Map<String, String> map = applicationSession.getNaming((Class<? extends TopiaEntity>) Class.forName(profilType));
        Map naming = new LinkedHashMap<String, String>();
        for (Entry<String, String> entry : map.entrySet()) {
            boolean keep = true;
            String key = entry.getKey();
            for (Iterator<String> it = profils.iterator(); keep && it.hasNext();) {
                if (it.next().equals(key)) {
                    keep = false;
                }
            }
            if (keep) {
                naming.put(key, entry.getValue());
            }
        }
        request.setAttribute("profilValues", naming);
    }

    static class UserPaginedListExtractor extends AbstractPaginedListExtractor<TaasUser> {

        private static final long serialVersionUID = 1L;

        private UserPaginedListExtractor(ServiceWeb service) {
            super(service);
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return service.getUsersCount(null, false);
        }

        public List<TaasUser> getList(HttpServletRequest request, int startIndex,
                                      int endIndex, String sortCriterion,
                                      final int sortDirection) throws Exception {
            return service.getUsers(null, false, startIndex, endIndex, sortCriterion, sortDirection);
        }

        public TaasUser getBean(String topiaId) throws Exception {
            return service.getUser(null, topiaId);
        }
    }

    static class UserCamionIndicateursPaginedListExtractor extends AbstractPaginedListExtractor<Camion> {

        private static final long serialVersionUID = 1L;

        protected boolean actif;
        protected String societe;

        private UserCamionIndicateursPaginedListExtractor (ServiceWeb service, String societe, boolean actif) {
            super(service);
            this.actif = actif;
            this.societe = societe;
        }

        @Override
        public int getFullListSize(HttpServletRequest request) throws Exception {
            return service.getCamions(null, societe, true).size();
        }

        @Override
        public List<Camion> getList(HttpServletRequest request, int startIndex,
                                      int endIndex, String sortCriterion,
                                      final int sortDirection) throws Exception {

            return service.getCamions(null, societe, actif, startIndex, endIndex, sortCriterion, sortDirection);
        }

        public Camion getBean(String topiaId) throws Exception {
            return service.getCamion(null, topiaId);
        }
    }
}
