package com.cybelia.sandra.web.action.user;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class PasswdForm extends ActionForm {

    private static final long serialVersionUID = 1L;

    protected String passwdBefore;
    protected String passwdNew;
    protected String passwdConfirm;

    public String getPasswdBefore() {
        return passwdBefore;
    }

    public void setPasswdBefore(String passwdBefore) {
        this.passwdBefore = passwdBefore;
    }

    public String getPasswdNew() {
        return passwdNew;
    }

    public void setPasswdNew(String passwdNew) {
        this.passwdNew = passwdNew;
    }

    public String getPasswdConfirm() {
        return passwdConfirm;
    }

    public void setPasswdConfirm(String passwdConfirm) {
        this.passwdConfirm = passwdConfirm;
    }

    public ActionErrors validate(ActionMapping mapping,
                                 HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        String passwdBefore = (String) request.getParameter("passwdBefore");
        String passwdNew = (String) request.getParameter("passwdNew");
        String passwdConfirm = (String) request.getParameter("passwdConfirm");

        if (StringUtils.isBlank(passwdBefore)) {
            errors.add("passwdBefore", new ActionMessage("error.passwdBefore.required"));
        }

        if (StringUtils.isBlank(passwdNew)) {
            errors.add("passwdNew", new ActionMessage("error.passwdNew.required"));
        }

        if (StringUtils.isBlank(passwdConfirm)) {
            errors.add("passwdConfirm", new ActionMessage("error.passwdConfirm.required"));
        }

        if (passwdBefore.equals(passwdNew)) {
            errors.add("passwdBefore", new ActionMessage("error.passwdBefore.new"));
        }

        if (!passwdNew.equals(passwdConfirm)) {
            errors.add("passwdNew", new ActionMessage("error.passwdNew.confirm"));
        }

        if (passwdNew.length() < 7) {
            errors.add("passwdNew", new ActionMessage("error.passwdNew.length"));
        }

        return errors;
    }
}
