package com.cybelia.sandra.web.action.tour;

import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.tour.StepsHelper.DataStep;
import com.cybelia.sandra.web.action.tour.StepsHelper.DefaultDataSteps;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ListTourTraceability extends ListTour {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response,
                                 ApplicationSession applicationSession, ServiceWeb serviceWeb)
            throws Exception {

        // Recuperation des tours
        super.execute(mapping, form, request, response, applicationSession, serviceWeb);

        PaginedListImpl<Tour> tours = getTours(request);

        // Recuperation des etapes
        DefaultDataSteps defaultDataSteps = new StepsHelper.DefaultDataSteps();
        DefaultDataSteps traceabilityDataSteps = new TraceabilityDataSteps();
        StepsHelper.getSteps(tours.getList(), defaultDataSteps, traceabilityDataSteps);

        // postionnement des resultats dans la requete
        request.setAttribute("steps", defaultDataSteps.getList());
        request.setAttribute("anomalies", traceabilityDataSteps.getList());

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public static class TraceabilityDataSteps extends DefaultDataSteps {
        private static final long serialVersionUID = 1L;

        @Override
        protected void addDataStep(Etape step) {
            TraceabilityDataStep<Etape> data = new TraceabilityDataStep<Etape>(step);
            data.setNoReport(true);
            data.setNoGPS(step.getEleveur().getTomtomGPS() == null);
            add(data);
        }

        @Override
        protected void addDataStep(SuiviEtape step) {
            TraceabilityDataStep<SuiviEtape> data = new TraceabilityDataStep<SuiviEtape>(step);
            Etape etape = step.getEtape();
            data.setNoGPS(etape == null || etape.getEleveur().getTomtomGPS() == null);
            data.setNoReport(step.getCREtape() == null);
            data.setNoDelivery(step.getCREtape() != null && !"RAS".equals(step.getCREtape().getLivraisonStatut()));
            if (data.isIncident()) {
                add(data);
            }
        }

        @Override
        protected void addDataStep(SuiviUsine factory) {
            TraceabilityDataStep<SuiviUsine> data = new TraceabilityDataStep<SuiviUsine>(factory);
            data.setNoGPS(factory.getUsine().getTomtomGPS() == null);
            if (data.isIncident()) {
                add(data);
            }
        }

        @Override
        protected void addDataStep(Usine factory) {
            TraceabilityDataStep<Usine> data = new TraceabilityDataStep<Usine>(factory);
            data.setNoReport(true);
            data.setNoGPS(factory.getTomtomGPS() == null);
            add(data);
        }
    }

    public static class TraceabilityDataStep<T> extends DataStep<T> {
        protected boolean noReport;
        protected boolean noGPS;
        protected boolean noDelivery;

        public TraceabilityDataStep(T step) {
            super(step);
        }

        public void setNoDelivery(boolean noDelivery) {
            this.noDelivery = noDelivery;
        }

        public boolean isNoDelivery() {
            return noDelivery;
        }

        public void setNoReport(boolean noReport) {
            this.noReport = noReport;
        }

        public boolean isNoReport() {
            return noReport;
        }

        public void setNoGPS(boolean noGPS) {
            this.noGPS = noGPS;
        }

        public boolean isNoGPS() {
            return noGPS;
        }

        public boolean isIncident() {
            return noDelivery || noGPS || noDelivery;
        }
    }
}
