package com.cybelia.sandra.web.action.tour;

import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.tour.StepsHelper.DataStep;
import com.cybelia.sandra.web.action.tour.StepsHelper.DefaultDataSteps;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;

public class ListTourProduct extends ListTour {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response,
                                 ApplicationSession applicationSession, ServiceWeb serviceWeb)
            throws Exception {

        // Recuperation des tours
        super.execute(mapping, form, request, response, applicationSession, serviceWeb);

        PaginedListImpl<Tour> tours = getTours(request);

        // Recuperation des etapes
        DefaultDataSteps dataSteps = new ProductDataSteps(serviceWeb);
        StepsHelper.getSteps(tours.getList(), dataSteps);

        // positionnement des etapes dans la requete
        request.setAttribute("steps", dataSteps.getList());

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public class ProductDataSteps extends DefaultDataSteps {
        private static final long serialVersionUID = 1L;

        protected ServiceWeb serviceWeb;

        public ProductDataSteps(ServiceWeb serviceWeb) {
            this.serviceWeb = serviceWeb;
        }

        @Override
        protected void addDataStep(Etape step) {
            for (LigneProduit product : step.getProduits()) {
                ProductDataStep<Etape> data = new ProductDataStep<Etape>(step);
                data.setProduct(product);
                add(data);
            }
        }

        @Override
        protected void addDataStep(SuiviEtape step) {
            if (step.getEtape() != null) {
                for (LigneProduit product : step.getEtape().getProduits()) {
                    ProductDataStep<SuiviEtape> data = new ProductDataStep<SuiviEtape>(step);

                    // Get suvi ligne produit if exist
                    SuiviLigneProduit suiviProduct = null;
                    try {
                        suiviProduct = serviceWeb.getSuiviProduit(null, product);
                    } catch (TopiaException e) {
                        log.info("cant get suiviProduit for : " + product.getTopiaId());
                    }
                    if (suiviProduct != null){
                        data.setSuiviProduct(suiviProduct);
                    }
                    data.setProduct(product);
                    add(data);
                }
            }
        }

        @Override
        protected void addDataStep(SuiviUsine factory) {
            add(new ProductDataStep<SuiviUsine>(factory));
        }

        @Override
        protected void addDataStep(Usine factory) {
            add(new ProductDataStep<Usine>(factory));
        }
    }

    public class ProductDataStep<T> extends DataStep<T> {
        protected LigneProduit product;
        protected SuiviLigneProduit suiviProduct;

        public ProductDataStep(T step) {
            super(step);
        }

        public void setProduct(LigneProduit product) {
            this.product = product;
        }

        public LigneProduit getProduct() {
            return product;
        }

        public SuiviLigneProduit getSuiviProduct() {
            return suiviProduct;
        }

        public void setSuiviProduct(SuiviLigneProduit suiviProduct) {
            this.suiviProduct = suiviProduct;
        }
    }
}
