package com.cybelia.sandra.web.action.tour;

import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonAction;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.displaytag.AbstractPaginedListExtractor;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ListTour extends CommonAction {

    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response,
                                 ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception {

        PaginedListImpl<Tour> listTours;
        CriteriaForm criteria = (CriteriaForm) form;

        TourExtractor extractor = new TourExtractor(serviceWeb, criteria);

        Tour tour = null;

        if (UtilAction.isNotEmptyParameter(request, "tour")) {
            // on recupere le filtre a partir de son identifiant
            String topiaId = request.getParameter("tour").trim();
            tour = extractor.getBean(topiaId);
            // creation de la liste paginee qui ne possede que le tour filtre
            listTours = new PaginedListImpl<Tour>(1, java.util.Collections.<Tour>singletonList(tour));
        } else {
            // recuperation de la liste des tours paginee et triee
            listTours = new PaginedListImpl<Tour>(extractor);
            // do not put default sort, service provide a default one (dateLivraison/camion.code/tour.numero);
            listTours.fromRequest(request).acquireData(request);
        }
        // Mise en cache des tours
        applicationSession.setListTours(listTours);

        // Mise en requete de la liste des tours
        request.setAttribute("tours", listTours);
        // Mise en request du tour
        request.setAttribute("tour", tour);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    /**
     * Recuperation de la liste des tours en requete (ou en session si non trouve en requete)
     *
     * @param request la requete courante
     * @return la liste des tours ou <code>null</code> si non trouvé ni en requete, ni en session
     */
    @SuppressWarnings({"unchecked"})
    protected PaginedListImpl<Tour> getTours(HttpServletRequest request) {
        PaginedListImpl<Tour> tours;
        tours = (PaginedListImpl<Tour>) request.getAttribute("tours");
        return tours;
    }

    public static class TourExtractor extends AbstractPaginedListExtractor<Tour> {

        private static final long serialVersionUID = 1L;

        protected CriteriaForm criteria;

        protected TourExtractor(ServiceWeb service, CriteriaForm criteria) {
            super(service);
            this.criteria = criteria;
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return service.getToursCount(null, criteria.getDateStart(),
                    criteria.getDateEnd(),
                    criteria.isPlanified(),
                    criteria.isTerminated(),
                    criteria.getSociety(),
                    criteria.getTransporter(),
                    criteria.getTruck(),
                    criteria.getDriver());
        }

        public List<Tour> getList(HttpServletRequest request, int startIndex,
                                  int endIndex, String sortCriterion,
                                  int sortDirection) throws Exception {
            /*if ( getFullListSize(request) == 0) {
                return null;
            }*/
            return service.getTours(null, criteria.getDateStart(),
                    criteria.getDateEnd(),
                    criteria.isPlanified(),
                    criteria.isTerminated(),
                    criteria.getSociety(),
                    criteria.getTransporter(),
                    criteria.getTruck(),
                    criteria.getDriver(), startIndex, endIndex, sortCriterion, sortDirection);
        }

        public Tour getBean(String topiaId) throws Exception {
            return service.getTour(null, topiaId);
        }

        public void setCriteria(CriteriaForm criteria) {
            this.criteria = criteria;
        }
    }

}
