package com.cybelia.sandra.web.action.tour;

import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.GenericValidator;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;


public class CriteriaForm extends ActionForm {

    private static final long serialVersionUID = 1L;

    protected Date dateStart;
    protected Date dateEnd;
    protected Boolean planified;
    protected Boolean terminated;
    protected String society;
    protected String transporter;
    protected String truck;
    protected String driver;

    public CriteriaForm() throws Exception {
        // Dates
        Calendar calendar = Calendar.getInstance();

        //calendar.add(Calendar.DATE, -1);
        dateStart = calendar.getTime();

        calendar.add(Calendar.DATE, 3);
        dateEnd = calendar.getTime();

        // Status
        planified = true;
        terminated = true;

        society = Cache.Societe.getDefaultEntry();
        transporter = Cache.Transporteur.getDefaultEntry();
        truck = Cache.Camion.getDefaultEntry();
        driver = Cache.Chauffeur.getDefaultEntry();
    }

    public Date getDateStart() {
        return dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public Date getDateEnd() {
        return dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public boolean isPlanified() {
        return planified;
    }

    public void setPlanified(boolean planified) {
        this.planified = planified;
    }

    public boolean isTerminated() {
        return terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public String getSociety() {
        return society;
    }

    public void setSociety(String society) {
        this.society = society;
    }

    public String getTransporter() {
        return transporter;
    }

    public void setTransporter(String transporter) {
        this.transporter = transporter;
    }

    public String getTruck() {
        return truck;
    }

    public void setTruck(String truck) {
        this.truck = truck;
    }

    public String getDriver() {
        return driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        String dateStartTest = request.getParameter("dateStart");
        String dateEndTest = request.getParameter("dateEnd");

        if (StringUtils.isBlank(dateStartTest)) {
            errors.add("dateStart", new ActionMessage("error.dateStart.required"));
        }

        if (StringUtils.isBlank(dateEndTest)) {
            errors.add("dateEnd", new ActionMessage("error.dateEnd.required"));
        }

        if (!GenericValidator.isDate(dateStartTest, "dd/MM/yy", true)) {
            errors.add("dateStart", new ActionMessage("error.dateStart.invalid"));
        }

        if (!GenericValidator.isDate(dateEndTest, "dd/MM/yy", true)) {
            errors.add("dateEnd", new ActionMessage("error.dateEnd.invalid"));
        }

        return errors;
    }

}
